/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import net.mehvahdjukaar.supplementaries.common.entities.ISpyglassMob;
import net.mehvahdjukaar.supplementaries.common.entities.controllers.BoatMoveController;
import net.mehvahdjukaar.supplementaries.common.entities.controllers.BoatPathNavigation;
import net.mehvahdjukaar.supplementaries.common.entities.controllers.LookControlWithSpyglass;
import net.mehvahdjukaar.supplementaries.common.entities.data.LivingEntityTamable;
import net.mehvahdjukaar.supplementaries.common.entities.goals.AbandonShipGoal;
import net.mehvahdjukaar.supplementaries.common.entities.goals.BoardBoatGoal;
import net.mehvahdjukaar.supplementaries.common.entities.goals.IAmTheCaptainGoal;
import net.mehvahdjukaar.supplementaries.common.entities.goals.MeleeAttackGoalWhenInRange;
import net.mehvahdjukaar.supplementaries.common.entities.goals.PlundererLookAtPlayerGoal;
import net.mehvahdjukaar.supplementaries.common.entities.goals.PlundererNearestAttackableTargetGoal;
import net.mehvahdjukaar.supplementaries.common.entities.goals.UseCannonBlockGoal;
import net.mehvahdjukaar.supplementaries.common.entities.goals.UseCannonBoatGoal;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class PlundererEntity
extends AbstractIllager
implements InventoryCarrier,
ISpyglassMob {
    private static final float PARROT_CHANE = 0.2f;
    private static final int INVENTORY_SIZE = 5;
    private static final int SLOT_OFFSET = 300;
    protected static final EntityDataAccessor<Boolean> USING_SPYGLASS = SynchedEntityData.defineId(PlundererEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<CompoundTag> DATA_SHOULDER_LEFT = SynchedEntityData.defineId(PlundererEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    protected static final EntityDataAccessor<CompoundTag> DATA_SHOULDER_RIGHT = SynchedEntityData.defineId(PlundererEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private final SimpleContainer inventory = new SimpleContainer(5);
    private BoatPathNavigation boatNavigation;
    private PathNavigation defaultNavigation;
    private final BoatMoveController boatController = new BoatMoveController((Mob)this);
    private final MoveControl defaultController = this.moveControl;
    private float timeEntitySatOnShoulder = 0.0f;
    private BlockPos lastKnownCannonPos = null;

    public PlundererEntity(EntityType<? extends PlundererEntity> entityType, Level level) {
        super(entityType, level);
        this.lookControl = new LookControlWithSpyglass<PlundererEntity>(this);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        if (this.getTarget() instanceof Player) {
            return false;
        }
        return super.removeWhenFarAway(distanceToClosestPlayer);
    }

    public void setLastKnownCannonPos(BlockPos lastKnownCannonPos) {
        this.lastKnownCannonPos = lastKnownCannonPos;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new UseCannonBoatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.goalSelector.addGoal(2, (Goal)new BoardBoatGoal((Mob)this, 1, 200));
        this.targetSelector.addGoal(2, new PlundererNearestAttackableTargetGoal<Player>(this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.goalSelector.addGoal(3, (Goal)new AbandonShipGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new UseCannonBlockGoal((PathfinderMob)this, 1.0, 20));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoalWhenInRange((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new IAmTheCaptainGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal(this, (PathfinderMob)this, 0.6){

            public boolean canContinueToUse() {
                return super.canContinueToUse();
            }

            public boolean canUse() {
                return super.canUse();
            }
        });
        this.goalSelector.addGoal(9, (Goal)new PlundererLookAtPlayerGoal(this, Player.class, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new PlundererLookAtPlayerGoal(this, Mob.class));
    }

    public void setNoActionTime(int idleTime) {
        super.setNoActionTime(idleTime);
    }

    protected void customServerAiStep() {
        if (this.getControlledVehicle() instanceof Boat) {
            this.moveControl = this.boatController;
            this.navigation = this.boatNavigation;
        } else {
            this.moveControl = this.defaultController;
            this.navigation = this.defaultNavigation;
        }
        super.customServerAiStep();
    }

    protected PathNavigation createNavigation(Level level) {
        this.boatNavigation = new BoatPathNavigation((Mob)this, level);
        this.defaultNavigation = super.createNavigation(level);
        return this.defaultNavigation;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(USING_SPYGLASS, (Object)false);
        builder.define(DATA_SHOULDER_LEFT, (Object)new CompoundTag());
        builder.define(DATA_SHOULDER_RIGHT, (Object)new CompoundTag());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.35f).add(Attributes.MAX_HEALTH, 24.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.FOLLOW_RANGE, 12.0);
    }

    @Override
    public boolean isUsingSpyglass() {
        return (Boolean)this.entityData.get(USING_SPYGLASS);
    }

    @Override
    public void setUsingSpyglass(boolean using) {
        this.entityData.set(USING_SPYGLASS, (Object)using);
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isUsingSpyglass()) {
            return AbstractIllager.IllagerArmPose.NEUTRAL;
        }
        return this.isAggressive() ? AbstractIllager.IllagerArmPose.ATTACKING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return super.checkSpawnObstruction(level);
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType reason) {
        return super.checkSpawnRules(level, reason);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        RegistryAccess ra = this.registryAccess();
        this.writeInventoryToTag(compound, (HolderLookup.Provider)ra);
        if (!this.getShoulderEntityLeft().isEmpty()) {
            compound.put("ShoulderEntityLeft", (Tag)this.getShoulderEntityLeft());
        }
        if (!this.getShoulderEntityRight().isEmpty()) {
            compound.put("ShoulderEntityRight", (Tag)this.getShoulderEntityRight());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        RegistryAccess ra = this.registryAccess();
        this.readInventoryFromTag(compound, (HolderLookup.Provider)ra);
        this.setCanPickUpLoot(true);
        if (compound.contains("ShoulderEntityLeft", 10)) {
            this.setShoulderEntityLeft(compound.getCompound("ShoulderEntityLeft"));
        }
        if (compound.contains("ShoulderEntityRight", 10)) {
            this.setShoulderEntityRight(compound.getCompound("ShoulderEntityRight"));
        }
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.GOLDEN_SWORD));
    }

    protected void enchantSpawnedWeapon(ServerLevelAccessor level, RandomSource random, DifficultyInstance difficulty) {
        ItemStack itemStack;
        super.enchantSpawnedWeapon(level, random, difficulty);
        if (random.nextInt(300) == 0 && (itemStack = this.getMainHandItem()).is(Items.GOLDEN_SWORD)) {
            EnchantmentHelper.enchantItemFromProvider((ItemStack)itemStack, (RegistryAccess)level.registryAccess(), (ResourceKey)VanillaEnchantmentProviders.RAID_VINDICATOR_POST_WAVE_5, (DifficultyInstance)difficulty, (RandomSource)random);
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.PLUNDERER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.PLUNDERER_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSounds.PLUNDERER_HURT.get();
    }

    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSounds.PLUNDERER_CELEBRATE.get();
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public SlotAccess getSlot(int slot) {
        int i = slot - 300;
        return i >= 0 && i < this.inventory.getContainerSize() ? SlotAccess.forContainer((Container)this.inventory, (int)i) : super.getSlot(slot);
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
        boolean shouldRun;
        Raid raid = this.getCurrentRaid();
        boolean bl = shouldRun = this.random.nextFloat() <= raid.getEnchantOdds();
        if (shouldRun) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.CROSSBOW);
            Object resourceKey = wave > raid.getNumGroups(Difficulty.NORMAL) ? VanillaEnchantmentProviders.RAID_PILLAGER_POST_WAVE_5 : (wave > raid.getNumGroups(Difficulty.EASY) ? VanillaEnchantmentProviders.RAID_PILLAGER_POST_WAVE_3 : null);
            if (resourceKey != null) {
                EnchantmentHelper.enchantItemFromProvider((ItemStack)itemStack, (RegistryAccess)level.registryAccess(), (ResourceKey)resourceKey, (DifficultyInstance)level.getCurrentDifficultyAt(this.blockPosition()), (RandomSource)this.getRandom());
                this.setItemSlot(EquipmentSlot.MAINHAND, itemStack);
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Parrot parrot;
        RandomSource randomSource = level.getRandom();
        this.populateDefaultEquipmentSlots(randomSource, difficulty);
        this.populateDefaultEquipmentEnchantments(level, randomSource, difficulty);
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        if (level.getRandom().nextFloat() < 0.2f && (parrot = (Parrot)EntityType.PARROT.create(this.level())) != null) {
            parrot.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            parrot.finalizeSpawn(level, difficulty, spawnType, null);
            this.setEntityOnShoulder((LivingEntity)parrot);
        }
        return spawnGroupData;
    }

    public CompoundTag getShoulderEntityLeft() {
        return (CompoundTag)this.entityData.get(DATA_SHOULDER_LEFT);
    }

    protected void setShoulderEntityLeft(CompoundTag entityCompound) {
        this.entityData.set(DATA_SHOULDER_LEFT, (Object)entityCompound);
    }

    public CompoundTag getShoulderEntityRight() {
        return (CompoundTag)this.entityData.get(DATA_SHOULDER_RIGHT);
    }

    protected void setShoulderEntityRight(CompoundTag entityCompound) {
        this.entityData.set(DATA_SHOULDER_RIGHT, (Object)entityCompound);
    }

    public boolean setEntityOnShoulder(LivingEntity parrot) {
        CompoundTag compoundTag = new CompoundTag();
        parrot.saveAsPassenger(compoundTag);
        float leftChance = this.getMainArm() == HumanoidArm.RIGHT ? 0.8f : 0.2f;
        if (this.setEntityOnShoulder(compoundTag, this.random.nextFloat() < leftChance)) {
            parrot.discard();
            return true;
        }
        return false;
    }

    public boolean setEntityOnShoulder(CompoundTag entityCompound, boolean leftFirst) {
        boolean success = false;
        if (leftFirst) {
            if (this.getShoulderEntityLeft().isEmpty()) {
                this.setShoulderEntityLeft(entityCompound);
                success = true;
            } else if (this.getShoulderEntityRight().isEmpty()) {
                this.setShoulderEntityRight(entityCompound);
                success = true;
            }
        } else if (this.getShoulderEntityRight().isEmpty()) {
            this.setShoulderEntityRight(entityCompound);
            success = true;
        } else if (this.getShoulderEntityLeft().isEmpty()) {
            this.setShoulderEntityLeft(entityCompound);
            success = true;
        }
        if (success) {
            this.timeEntitySatOnShoulder = this.level().getGameTime();
        }
        return success;
    }

    public void aiStep() {
        super.aiStep();
        this.playShoulderEntityAmbientSound(this.getShoulderEntityLeft());
        this.playShoulderEntityAmbientSound(this.getShoulderEntityRight());
        if (!this.level().isClientSide && (this.fallDistance > 1.5f || this.isUnderWater()) || this.isSleeping() || this.isInPowderSnow) {
            this.removeEntitiesOnShoulder();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean didHurt = super.hurt(source, amount);
        if (didHurt && !this.level().isClientSide) {
            this.removeEntitiesOnShoulder();
        }
        return didHurt;
    }

    protected void removeEntitiesOnShoulder() {
        if (this.timeEntitySatOnShoulder + 20.0f < (float)this.level().getGameTime()) {
            this.respawnEntityOnShoulder(this.getShoulderEntityLeft());
            this.setShoulderEntityLeft(new CompoundTag());
            this.respawnEntityOnShoulder(this.getShoulderEntityRight());
            this.setShoulderEntityRight(new CompoundTag());
        }
    }

    private void respawnEntityOnShoulder(CompoundTag entityCompound) {
        if (!this.level().isClientSide && !entityCompound.isEmpty()) {
            EntityType.create((CompoundTag)entityCompound, (Level)this.level()).ifPresent(entity -> {
                LivingEntityTamable tamable = (LivingEntityTamable)ModEntities.LIVING_TAMABLE.getOrCreate((Object)((LivingEntity)entity));
                tamable.setOwner((LivingEntity)this);
                entity.setPos(this.getX(), this.getY() + (double)0.7f, this.getZ());
                ((ServerLevel)this.level()).addWithUUID(entity);
            });
        }
    }

    private void playShoulderEntityAmbientSound(@Nullable CompoundTag entityCompound) {
        if (!(entityCompound == null || entityCompound.contains("Silent") && entityCompound.getBoolean("Silent") || this.level().random.nextInt(200) != 0)) {
            String string = entityCompound.getString("id");
            EntityType.byString((String)string).filter(entityType -> entityType == EntityType.PARROT).ifPresent(entityType -> {
                if (!Parrot.imitateNearbyMobs((Level)this.level(), (Entity)this)) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Parrot.getAmbient((Level)this.level(), (RandomSource)this.level().random), this.getSoundSource(), 1.0f, Parrot.getPitch((RandomSource)this.level().random));
                }
            });
        }
    }
}

