/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeKnotBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeKnotBlockTile
extends MimicBlockTile {
    private VoxelShape cachedCollisionShape = null;
    private VoxelShape cachedShape = null;
    private static final VoxelShape DOWN_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public RopeKnotBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.ROPE_KNOT_TILE.get(), pos, state);
        this.setHeldBlock(Blocks.AIR.defaultBlockState());
    }

    public VoxelShape getCollisionShape() {
        if (this.cachedCollisionShape == null) {
            this.recalculateShapes(this.getBlockState());
        }
        return Objects.requireNonNullElseGet(this.cachedCollisionShape, Shapes::block);
    }

    public VoxelShape getShape() {
        if (this.cachedShape == null) {
            this.recalculateShapes(this.getBlockState());
        }
        return Objects.requireNonNullElseGet(this.cachedShape, Shapes::block);
    }

    public void recalculateShapes(BlockState state) {
        try {
            VoxelShape r;
            if (state == null || !state.is(ModRegistry.ROPE_KNOT.get()) || this.level == null) {
                return;
            }
            BlockState mimic = this.getHeldBlock();
            if (mimic.isAir()) {
                mimic = Blocks.STONE.defaultBlockState();
            }
            boolean up = (Boolean)state.getValue((Property)AbstractRopeKnotBlock.UP);
            boolean down = (Boolean)state.getValue((Property)AbstractRopeKnotBlock.DOWN);
            if (down && !up) {
                r = DOWN_SHAPE;
            } else {
                BlockState rope = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)ModRegistry.ROPE.get().defaultBlockState().setValue((Property)AbstractRopeBlock.KNOT, (Comparable)Boolean.valueOf(false))).setValue((Property)AbstractRopeKnotBlock.UP, (Comparable)Boolean.valueOf(up))).setValue((Property)AbstractRopeKnotBlock.DOWN, (Comparable)Boolean.valueOf(down))).setValue((Property)AbstractRopeKnotBlock.NORTH, (Comparable)((Boolean)state.getValue((Property)AbstractRopeKnotBlock.NORTH)))).setValue((Property)AbstractRopeKnotBlock.SOUTH, (Comparable)((Boolean)state.getValue((Property)AbstractRopeKnotBlock.SOUTH)))).setValue((Property)AbstractRopeKnotBlock.EAST, (Comparable)((Boolean)state.getValue((Property)AbstractRopeKnotBlock.EAST)))).setValue((Property)AbstractRopeKnotBlock.WEST, (Comparable)((Boolean)state.getValue((Property)AbstractRopeKnotBlock.WEST)));
                r = rope.getShape((BlockGetter)this.level, this.worldPosition);
            }
            VoxelShape c = mimic.getCollisionShape((BlockGetter)this.level, this.worldPosition);
            VoxelShape s = mimic.getShape((BlockGetter)this.level, this.worldPosition);
            c = Shapes.or((VoxelShape)c, (VoxelShape)r);
            s = Shapes.or((VoxelShape)s, (VoxelShape)r);
            this.cachedCollisionShape = c.optimize();
            this.cachedShape = s.optimize();
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("failed to calculate roped fence hitbox: " + String.valueOf(e));
        }
    }

    public void setChanged() {
        if (this.level == null) {
            return;
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        this.requestModelReload();
        this.cachedCollisionShape = null;
        this.cachedShape = null;
        super.setChanged();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.cachedCollisionShape = null;
        this.cachedShape = null;
    }
}

