/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public abstract class PartyHatLayer<E extends LivingEntity, M extends EntityModel<E>>
extends RenderLayer<E, M> {
    protected final ModelPart string;
    protected final ModelPart parentHead;

    public PartyHatLayer(RenderLayerParent<E, M> renderer, EntityModelSet entityModels) {
        super(renderer);
        this.string = entityModels.bakeLayer(ClientRegistry.PARTY_CREEPER_MODEL);
        this.parentHead = this.getParentHead(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, E entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.isInvisible() && this.hasHat(entity)) {
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCullZOffset((ResourceLocation)ModTextures.PARTY_CREEPER));
            poseStack.pushPose();
            this.string.copyFrom(this.parentHead);
            this.string.render(poseStack, vertexConsumer, packedLight, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f));
            this.renderExtra(poseStack, buffer, packedLight, entity);
            poseStack.popPose();
        }
    }

    protected void renderExtra(PoseStack poseStack, MultiBufferSource buffer, int packedLight, E entity) {
    }

    protected abstract ModelPart getParentHead(RenderLayerParent<E, M> var1);

    protected abstract boolean hasHat(E var1);

    public static LayerDefinition createMesh() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE), PartPose.ZERO);
        if (PlatHelper.getPlatform().isFabric()) {
            partDefinition.addOrReplaceChild("hat_1", CubeListBuilder.create().texOffs(0, 23).addBox(-4.0f, -16.0f, 0.0f, 8.0f, 9.0f, 0.0f, new CubeDeformation(4.0f * Mth.sqrt((float)2.0f) - 4.0f, 0.0f, 0.0f)), PartPose.rotation((float)0.0f, (float)0.7853982f, (float)0.0f));
            partDefinition.addOrReplaceChild("hat_2", CubeListBuilder.create().texOffs(0, 23).addBox(-4.0f, -16.0f, 0.0f, 8.0f, 9.0f, 0.0f, new CubeDeformation(4.0f * Mth.sqrt((float)2.0f) - 4.0f, 0.0f, 0.0f)), PartPose.rotation((float)0.0f, (float)-0.7853982f, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public static class Creeper<C extends net.minecraft.world.entity.monster.Creeper>
    extends PartyHatLayer<C, CreeperModel<C>> {
        private final ItemInHandRenderer itemRenderer;
        private final ItemStack stack;
        private final boolean rendersItem;

        public Creeper(RenderLayerParent<C, CreeperModel<C>> renderer, EntityModelSet entityModels, ItemInHandRenderer itemRenderer) {
            super(renderer, entityModels);
            this.itemRenderer = itemRenderer;
            this.stack = ModRegistry.CONFETTI_POPPER.get().getDefaultInstance();
            this.rendersItem = PlatHelper.getPlatform().isForge();
        }

        @Override
        protected boolean hasHat(C livingEntity) {
            return ((IPartyCreeper)livingEntity).supplementaries$isFestive();
        }

        @Override
        protected ModelPart getParentHead(RenderLayerParent<C, CreeperModel<C>> renderer) {
            return ((CreeperModel)this.getParentModel()).root().getChild("head");
        }

        @Override
        protected void renderExtra(PoseStack poseStack, MultiBufferSource buffer, int packedLight, C entity) {
            if (this.rendersItem) {
                this.parentHead.translateAndRotate(poseStack);
                CustomHeadLayer.translateToHead((PoseStack)poseStack, (boolean)false);
                this.itemRenderer.renderItem(entity, this.stack, ItemDisplayContext.HEAD, false, poseStack, buffer, packedLight);
            }
        }
    }

    public static class Generic<P extends LivingEntity>
    extends PartyHatLayer<P, HumanoidModel<P>> {
        public Generic(RenderLayerParent<P, HumanoidModel<P>> renderer, EntityModelSet entityModels) {
            super(renderer, entityModels);
        }

        @Override
        protected boolean hasHat(P livingEntity) {
            return livingEntity.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModRegistry.CONFETTI_POPPER.get();
        }

        @Override
        protected ModelPart getParentHead(RenderLayerParent<P, HumanoidModel<P>> renderer) {
            return ((HumanoidModel)this.getParentModel()).head;
        }
    }
}

