/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.color;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class ColorHelper {
    private static float[][] soapColors;

    public static int pack(float[] rgb) {
        return FastColor.ARGB32.color((int)255, (int)((int)(rgb[0] * 255.0f)), (int)((int)(rgb[1] * 255.0f)), (int)((int)(rgb[2] * 255.0f)));
    }

    public static float normalizeHSLSaturation(float saturation, float lightness) {
        float c = 1.0f - Math.abs(2.0f * lightness - 1.0f);
        return Math.min(saturation, c);
    }

    public static int getRainbowColorPost(float division) {
        float scale = 3600.0f / division;
        float h = (float)((int)(System.currentTimeMillis() % (long)((int)scale))) / scale;
        return new RGBColor(0xFFAA00).asHCL().withHue(h).asRGB().toInt();
    }

    public static int getRandomBrightColor(RandomSource random) {
        float h = random.nextFloat();
        HSLColor hsl = ColorHelper.prettyfyColor(new HSLColor(h, 0.62f + random.nextFloat() * 0.3f, 0.43f + random.nextFloat() * 0.15f, 1.0f));
        return hsl.asRGB().toInt();
    }

    public static int getRainbowColor(float division) {
        float scale = 3600.0f / division;
        float h = (float)((int)(System.currentTimeMillis() % (long)((int)scale))) / scale;
        HSLColor color = new HSLColor(h, 0.6f, 0.5f, 1.0f);
        return color.asRGB().toInt();
    }

    public static float[] getBubbleColor(float phase) {
        int n = soapColors.length;
        int ind = (int)Math.floor((float)n * phase);
        float delta = (float)n * phase % 1.0f;
        float[] start = soapColors[ind];
        float[] end = soapColors[(ind + 1) % n];
        float red = Mth.lerp((float)delta, (float)start[0], (float)end[0]);
        float green = Mth.lerp((float)delta, (float)start[1], (float)end[1]);
        float blue = Mth.lerp((float)delta, (float)start[2], (float)end[2]);
        return new float[]{red, green, blue};
    }

    public static HSLColor prettyfyColor(HSLColor hsl) {
        float h = hsl.hue();
        float s = hsl.saturation();
        float l = hsl.lightness();
        s = ColorHelper.normalizeHSLSaturation(s, l);
        float minLightness = 0.47f;
        l = Math.max(l, minLightness);
        float j = 1.0f - l;
        float ratio = 0.35f;
        if (s < j) {
            s = ratio * j + (1.0f - ratio) * s;
        }
        float scaling = 0.15f;
        float angle = 90.0f;
        float n = (float)((double)scaling * Math.exp((double)(-angle) * Math.pow(h - 0.6666f, 2.0)));
        return new HSLColor(h, s -= n, l, 1.0f);
    }

    public static void refreshBubbleColors(ResourceManager manager) {
        List c = SpriteUtils.parsePaletteStrip((ResourceManager)manager, (ResourceLocation)ResType.TEXTURES.getPath(ModTextures.BUBBLE_BLOCK_COLORS_TEXTURE), (int)6);
        float[][] temp = new float[c.size()][];
        for (int i = 0; i < c.size(); ++i) {
            int j = (Integer)c.get(i);
            temp[i] = new float[]{(float)FastColor.ABGR32.red((int)j) / 255.0f, (float)FastColor.ABGR32.green((int)j) / 255.0f, (float)FastColor.ABGR32.blue((int)j) / 255.0f};
        }
        soapColors = temp;
    }
}

