/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadsTransformer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.supplementaries.client.FlowerBoxModelsManager;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlowerBoxBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlowerBoxBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class FlowerBoxBakedModel
implements CustomBakedModel {
    private final BakedModel box;
    private final BlockModelShaper blockModelShaper;
    private final ModelState rotation;
    private final ThreadLocal<BlockPos> posHack = ThreadLocal.withInitial(() -> BlockPos.ZERO);

    public FlowerBoxBakedModel(BakedModel box, ModelState rotation) {
        this.box = box;
        this.blockModelShaper = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
        this.rotation = rotation;
    }

    public ExtraModelData getModelData(@NotNull ExtraModelData tileData, BlockPos pos, BlockState state, BlockAndTintGetter level) {
        this.posHack.set(pos);
        return tileData;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        BlockPos pos = this.posHack.get();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        try {
            quads.addAll(this.box.getQuads(state, side, rand));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (state != null) {
                float offset;
                BlockState[] flowers = new BlockState[]{(BlockState)data.get(FlowerBoxBlockTile.FLOWER_0), (BlockState)data.get(FlowerBoxBlockTile.FLOWER_1), (BlockState)data.get(FlowerBoxBlockTile.FLOWER_2)};
                PoseStack poseStack = new PoseStack();
                Matrix4f rot = this.rotation.getRotation().getMatrix();
                poseStack.mulPose(rot);
                poseStack.translate(-0.3125, 0.0, 0.0);
                if (state.getValue(FlowerBoxBlock.ATTACHMENT) != AttachFace.WALL) {
                    poseStack.translate(0.0, 0.0, -0.3125);
                }
                float scale = 0.625f;
                poseStack.scale(scale, scale, scale);
                poseStack.translate(0.5, 0.5, 1.0);
                float f = offset = (pos.getX() + pos.getZ()) % 2 == 0 ? 0.001f : -0.001f;
                if (((Direction)state.getValue((Property)FlowerBoxBlock.FACING)).getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                    offset = -offset;
                }
                poseStack.translate(offset, offset, offset);
                for (int i = 0; i < 3; ++i) {
                    BlockState flower = flowers[i];
                    if (flower == null || flower.isAir()) continue;
                    poseStack.pushPose();
                    poseStack.translate(0.5 * (double)i, 0.0, 0.0);
                    if (flower.hasProperty((Property)BlockStateProperties.FLOWER_AMOUNT)) {
                        poseStack.translate(scale / 4.0f, 0.0f, scale / 4.0f);
                    }
                    this.addBlockToModel(i, quads, flower, pos, poseStack, side, rand);
                    if (flower.hasProperty((Property)DoublePlantBlock.HALF)) {
                        poseStack.translate(0.0f, scale, 0.0f);
                        this.addBlockToModel(i, quads, (BlockState)flower.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), pos, poseStack, side, rand);
                    }
                    poseStack.popPose();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return quads;
    }

    private void addBlockToModel(int index, List<BakedQuad> quads, BlockState state, BlockPos pos, PoseStack poseStack, @Nullable Direction side, @NotNull RandomSource rand) {
        BakedModel model;
        ModelResourceLocation modelRes = FlowerBoxModelsManager.INSTANCE.getSpecialFlowerModel(state.getBlock().asItem());
        if (modelRes != null) {
            if (state.hasProperty((Property)DoublePlantBlock.HALF) && state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
                return;
            }
            model = ClientHelper.getModel((ModelManager)this.blockModelShaper.getModelManager(), (ModelResourceLocation)modelRes);
        } else {
            model = this.blockModelShaper.getBlockModel(state);
        }
        List mimicQuads = model.getQuads(state, side, rand);
        if (mimicQuads.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        if (modelRes == null) {
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            poseStack.scale(0.6249f, 0.6249f, 0.6249f);
        } else {
            poseStack.translate(-0.5f, -0.3125f, -0.5f);
            if (CommonConfigs.Building.FLOWER_BOX_SIMPLE_MODE.get().booleanValue()) {
                poseStack.scale(1.6f, 1.6f, 1.6f);
            }
        }
        Matrix4f matrix = poseStack.last().pose();
        poseStack.popPose();
        BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingTransform(matrix).applyingShade(false).applyingAmbientOcclusion(true).applyingTintIndex(index);
        List collection = transformer.transformAll(mimicQuads);
        quads.addAll(collection);
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData extraModelData) {
        return this.box.getParticleIcon();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

