/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin.client;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.moves.categories.DamageCategory;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.cobblemon.mod.common.client.battle.SingleActionRequest;
import com.cobblemon.mod.common.client.gui.battle.subscreen.BattleMoveSelection;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.CritChanceCache;
import name.modid.client.CustomBattleController;
import name.modid.client.CustomTooltipRenderer;
import name.modid.client.TypeChart;
import name.modid.client.TypeIconRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BattleMoveSelection.MoveTile.class})
public abstract class MoveTileMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveTileMixin.class);
    @Shadow
    public MoveTemplate moveTemplate;
    private static String cachedOpponentId = null;
    private static List<ElementalType> cachedFormTypes = null;
    private static long lastCacheTime = 0L;
    private static String cachedPlayerPokemonId = null;
    private static String cachedPlayerAbility = null;
    private static long lastAbilityCacheTime = 0L;
    private static boolean cachedPlayerIsMega = false;

    @Shadow
    public abstract boolean isHovered(double var1, double var3);

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")}, remap=false)
    public void onRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!BattleExtrasConfig.isMoveTooltipsEnabled()) {
            return;
        }
        if (!CustomBattleController.isMovesSelectionActive()) {
            return;
        }
        boolean isMouseHovered = this.isHovered(mouseX, mouseY);
        boolean isControllerSelected = CustomBattleController.isTileControllerSelected(this);
        if (isMouseHovered) {
            if (this.moveTemplate == null) {
                return;
            }
            this.renderTooltipAtPosition(context, mouseX, mouseY);
            return;
        }
        if (isControllerSelected && !CustomBattleController.isMouseHoveringAnyMoveTile()) {
            if (this.moveTemplate == null) {
                return;
            }
            int[] tilePos = CustomBattleController.getSelectedTilePosition();
            int tileIndex = CustomBattleController.getSelectedTileIndex();
            if (tilePos != null && tileIndex >= 0) {
                int tooltipY;
                int tooltipX;
                if (tileIndex <= 1) {
                    tooltipX = 8;
                    tooltipY = tilePos[1] - 140;
                } else {
                    tooltipX = 8;
                    tooltipY = tilePos[1] - 150;
                }
                if (tooltipY < 10) {
                    tooltipY = 10;
                }
                this.renderTooltipAtPosition(context, tooltipX, tooltipY);
            }
        }
    }

    private void renderTooltipAtPosition(GuiGraphics context, int tooltipX, int tooltipY) {
        try {
            ActiveClientBattlePokemon active;
            ClientBattlePokemon battlePokemon;
            ClientBattleActor firstActor;
            List activePokemon;
            ClientBattleSide opponentSide;
            List actors;
            String category;
            String typeName;
            String moveName;
            ArrayList<Component> tooltip = new ArrayList<Component>();
            int typeColor = this.moveTemplate.getElementalType().getHue();
            try {
                Object displayNameComponent = this.moveTemplate.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)this.moveTemplate, new Object[0]);
                moveName = displayNameComponent != null ? displayNameComponent.getClass().getMethod("getString", new Class[0]).invoke(displayNameComponent, new Object[0]).toString() : this.formatMoveName(this.moveTemplate.getName());
            }
            catch (Exception e) {
                moveName = this.formatMoveName(this.moveTemplate.getName());
            }
            tooltip.add((Component)Component.literal((String)moveName).withStyle(style -> style.withColor(typeColor).withBold(Boolean.valueOf(true))));
            try {
                Object typeDisplayName = this.moveTemplate.getElementalType().getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)this.moveTemplate.getElementalType(), new Object[0]);
                typeName = typeDisplayName.getClass().getMethod("getString", new Class[0]).invoke(typeDisplayName, new Object[0]).toString();
            }
            catch (Exception e) {
                typeName = this.capitalize(this.moveTemplate.getElementalType().getName());
            }
            try {
                Object categoryDisplayName = this.moveTemplate.getDamageCategory().getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)this.moveTemplate.getDamageCategory(), new Object[0]);
                category = categoryDisplayName.getClass().getMethod("getString", new Class[0]).invoke(categoryDisplayName, new Object[0]).toString();
            }
            catch (Exception e) {
                category = this.capitalize(this.moveTemplate.getDamageCategory().getName());
            }
            tooltip.add((Component)Component.literal((String)(typeName + " | " + category)).withStyle(ChatFormatting.GRAY));
            try {
                String moveId = this.moveTemplate.getName().toLowerCase();
                String translationKey = "cobblemon.move." + moveId + ".desc";
                MutableComponent descComponent = Component.translatable((String)translationKey);
                String description = descComponent.getString();
                if (description != null && !description.isEmpty() && !description.equals(translationKey)) {
                    tooltip.add((Component)Component.empty());
                    for (String line : this.wrapText(description, 35)) {
                        tooltip.add((Component)Component.literal((String)line).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}));
                    }
                }
            }
            catch (Exception moveId) {
                // empty catch block
            }
            boolean isStatus = this.moveTemplate.getDamageCategory() == DamageCategories.INSTANCE.getSTATUS();
            double power = this.moveTemplate.getPower();
            double accuracy = this.moveTemplate.getAccuracy();
            ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
            ClientBattlePokemon playerPokemon = this.getPlayerActivePokemon(battle);
            String playerPokemonName = null;
            float stabMultiplier = 1.0f;
            double critChance = 6.25;
            double adjustedAccuracy = accuracy;
            if (playerPokemon != null) {
                try {
                    playerPokemonName = this.getPlayerPokemonName(playerPokemon);
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] About to call getCritChancePercentage for: {}", playerPokemonName);
                    stabMultiplier = this.calculateStabMultiplier(this.moveTemplate, playerPokemon, playerPokemonName);
                    critChance = this.getCritChancePercentage(playerPokemonName, playerPokemon, this.moveTemplate);
                    adjustedAccuracy = this.calculateAdjustedAccuracy(accuracy, playerPokemonName, playerPokemon, this.moveTemplate);
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] getCritChancePercentage returned: {}%", critChance);
                }
                catch (Exception e) {
                    LOGGER.error("[MoveTileMixin] Exception in tooltip calculation", (Throwable)e);
                }
            } else {
                CobblemonBattleInfoClient.debug("[MoveTileMixin] playerPokemon is null, using defaults", new Object[0]);
            }
            tooltip.add((Component)Component.empty());
            if (power > 0.0) {
                boolean hasStab;
                int basePower = (int)power;
                boolean bl = hasStab = stabMultiplier > 1.0f;
                if (hasStab) {
                    int adjustedPower = (int)((float)basePower * stabMultiplier);
                    tooltip.add((Component)Component.translatable((String)"move.battleinfo.power.stab", (Object[])new Object[]{basePower, adjustedPower}).withStyle(ChatFormatting.RED));
                } else {
                    tooltip.add((Component)Component.translatable((String)"move.battleinfo.power", (Object[])new Object[]{basePower}).withStyle(ChatFormatting.RED));
                }
            } else if (!isStatus) {
                tooltip.add((Component)Component.translatable((String)"move.battleinfo.power.none").withStyle(ChatFormatting.DARK_GRAY));
            }
            if (accuracy > 0.0) {
                boolean hasAccuracyBoost;
                int finalAccuracy = (int)adjustedAccuracy;
                int baseAccuracy = (int)accuracy;
                boolean bl = hasAccuracyBoost = finalAccuracy != baseAccuracy;
                if (hasAccuracyBoost) {
                    tooltip.add((Component)Component.translatable((String)"move.battleinfo.accuracy.boost", (Object[])new Object[]{baseAccuracy, finalAccuracy}).withStyle(ChatFormatting.BLUE));
                } else {
                    tooltip.add((Component)Component.translatable((String)"move.battleinfo.accuracy", (Object[])new Object[]{baseAccuracy}).withStyle(ChatFormatting.BLUE));
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"move.battleinfo.accuracy.none").withStyle(ChatFormatting.DARK_GRAY));
            }
            if (!isStatus && power > 0.0) {
                ChatFormatting critColor;
                String critText;
                if (critChance <= 4.17) {
                    critText = "4.17%";
                    critColor = ChatFormatting.GRAY;
                } else if (critChance == 12.5) {
                    critText = "12.5%";
                    critColor = ChatFormatting.YELLOW;
                } else if (critChance == 50.0) {
                    critText = "50%";
                    critColor = ChatFormatting.GOLD;
                } else if (critChance >= 100.0) {
                    critText = "100%";
                    critColor = ChatFormatting.RED;
                } else {
                    critText = String.format("%.1f%%", critChance);
                    critColor = ChatFormatting.YELLOW;
                }
                tooltip.add((Component)Component.translatable((String)"move.battleinfo.crit", (Object[])new Object[]{critText}).withStyle(critColor));
            }
            try {
                BattleMoveSelection.MoveTile tile = (BattleMoveSelection.MoveTile)this;
                Field field = tile.getClass().getDeclaredField("move");
                field.setAccessible(true);
                InBattleMove inBattleMove = (InBattleMove)field.get(tile);
                if (inBattleMove != null) {
                    int pp = inBattleMove.getPp();
                    int maxPP = inBattleMove.getMaxpp();
                    ChatFormatting ppColor = pp == 0 ? ChatFormatting.RED : (pp <= maxPP / 4 ? ChatFormatting.GOLD : ChatFormatting.GREEN);
                    tooltip.add((Component)Component.translatable((String)"move.battleinfo.pp", (Object[])new Object[]{pp, maxPP}).withStyle(ppColor));
                }
            }
            catch (Exception tile) {
                // empty catch block
            }
            try {
                Object firstChance;
                int length;
                double effectChance = 0.0;
                try {
                    Method method = this.moveTemplate.getClass().getMethod("getEffectChances", new Class[0]);
                    Object result = method.invoke((Object)this.moveTemplate, new Object[0]);
                    if (result != null && result.getClass().isArray() && (length = Array.getLength(result)) > 0 && (firstChance = Array.get(result, 0)) instanceof Number) {
                        effectChance = ((Number)firstChance).doubleValue();
                    }
                }
                catch (Exception e) {
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Failed to get effectChances for {}: {}", this.moveTemplate.getName(), e.getMessage());
                }
                if (effectChance == 0.0) {
                    try {
                        Field field = this.moveTemplate.getClass().getDeclaredField("effectChances");
                        field.setAccessible(true);
                        Object result = field.get(this.moveTemplate);
                        if (result != null && result.getClass().isArray() && (length = Array.getLength(result)) > 0 && (firstChance = Array.get(result, 0)) instanceof Number) {
                            effectChance = ((Number)firstChance).doubleValue();
                        }
                    }
                    catch (Exception e) {
                        CobblemonBattleInfoClient.debug("[MoveTileMixin] Failed to access effectChances field for {}: {}", this.moveTemplate.getName(), e.getMessage());
                    }
                }
                if (effectChance > 0.0) {
                    String effectText = this.getEffectDescriptionFromMove(this.moveTemplate);
                    if (effectText != null && !effectText.isEmpty()) {
                        tooltip.add((Component)Component.translatable((String)"move.battleinfo.effect", (Object[])new Object[]{(int)effectChance}).append((Component)Component.literal((String)effectText)).withStyle(ChatFormatting.LIGHT_PURPLE));
                    } else {
                        tooltip.add((Component)Component.translatable((String)"move.battleinfo.effect", (Object[])new Object[]{(int)effectChance}).withStyle(ChatFormatting.LIGHT_PURPLE));
                    }
                }
            }
            catch (Exception e) {
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Error extracting effect chance: {}", e.getMessage());
            }
            if (!(battle == null || isStatus || (actors = (opponentSide = battle.getSide2()).getActors()).isEmpty() || (activePokemon = (firstActor = (ClientBattleActor)actors.get(0)).getActivePokemon()).isEmpty() || (battlePokemon = (active = (ActiveClientBattlePokemon)activePokemon.get(0)).getBattlePokemon()) == null)) {
                float effectiveness;
                PokemonProperties properties = battlePokemon.getProperties();
                String formName = properties.getForm();
                Species species = battlePokemon.getSpecies();
                String opponentName = species.getName();
                ElementalType type1 = null;
                ElementalType type2 = null;
                try {
                    List forms = species.getForms();
                    for (FormData form : forms) {
                        String availableFormName = form.getName();
                        boolean matches = false;
                        if (formName != null && !formName.isEmpty()) {
                            matches = availableFormName.equalsIgnoreCase(formName);
                            if (!matches) {
                                matches = availableFormName.equalsIgnoreCase(formName.replace("_", "-"));
                            }
                            if (!matches) {
                                matches = availableFormName.equalsIgnoreCase(formName.replace("-", "_"));
                            }
                        }
                        if (!matches) continue;
                        Iterable types = form.getTypes();
                        ArrayList<ElementalType> typeList = new ArrayList<ElementalType>();
                        for (ElementalType type : types) {
                            typeList.add(type);
                        }
                        type1 = typeList.size() > 0 ? (ElementalType)typeList.get(0) : null;
                        type2 = typeList.size() > 1 ? (ElementalType)typeList.get(1) : null;
                        break;
                    }
                }
                catch (Exception e) {
                    Pokemon pokemon = properties.create();
                    type1 = pokemon.getPrimaryType();
                    type2 = pokemon.getSecondaryType();
                }
                if (type1 == null) {
                    Pokemon pokemon = properties.create();
                    type1 = pokemon.getPrimaryType();
                    type2 = pokemon.getSecondaryType();
                }
                String randType1Name = null;
                String randType2Name = null;
                try {
                    String[] opponentTypes;
                    Boolean hasOpponentTypes;
                    Class<?> randomizerClient = Class.forName("cobblemon.randomizer.client.RandomizerClient");
                    String pokemonUUID = battlePokemon.getUuid().toString();
                    String[] wildTypes = (String[])randomizerClient.getMethod("getWildPokemonTypes", String.class).invoke(null, pokemonUUID);
                    if (wildTypes != null && wildTypes.length > 0) {
                        randType1Name = wildTypes[0].toLowerCase();
                        randType2Name = wildTypes.length > 1 ? wildTypes[1].toLowerCase() : null;
                        CobblemonBattleInfoClient.debug("[MoveTileMixin] Found wild types for {}: {}/{}", opponentName, randType1Name, randType2Name);
                    }
                    if (randType1Name == null && (hasOpponentTypes = (Boolean)randomizerClient.getMethod("hasOpponentPokemonTypes", new Class[0]).invoke(null, new Object[0])) != null && hasOpponentTypes.booleanValue() && (opponentTypes = (String[])randomizerClient.getMethod("getOpponentPokemonTypes", String.class).invoke(null, pokemonUUID)) != null && opponentTypes.length > 0) {
                        randType1Name = opponentTypes[0].toLowerCase();
                        randType2Name = opponentTypes.length > 1 ? opponentTypes[1].toLowerCase() : null;
                        CobblemonBattleInfoClient.debug("[MoveTileMixin] Found PvP opponent types for {}: {}/{}", opponentName, randType1Name, randType2Name);
                    }
                }
                catch (ClassNotFoundException randomizerClient) {
                }
                catch (Throwable randomizerClient) {
                    // empty catch block
                }
                String moveType = this.moveTemplate.getElementalType().getName().toLowerCase();
                String teraType = BattleMessageSubscriber.getTeraType(opponentName);
                if (teraType != null && !teraType.isEmpty()) {
                    effectiveness = TypeChart.getEffectivenessAgainstTypes(moveType, teraType, null);
                } else {
                    String transformedType = BattleMessageSubscriber.getTransformedType(opponentName);
                    if (transformedType != null && !transformedType.isEmpty()) {
                        effectiveness = TypeChart.getEffectivenessAgainstTypes(moveType, transformedType, null);
                    } else {
                        List<String> megaTypes = BattleMessageSubscriber.getMegaTypes(opponentName);
                        if (megaTypes != null && !megaTypes.isEmpty()) {
                            String megaType1 = megaTypes.get(0);
                            String megaType2 = megaTypes.size() > 1 ? megaTypes.get(1) : null;
                            effectiveness = TypeChart.getEffectivenessAgainstTypes(moveType, megaType1, megaType2);
                        } else if (randType1Name != null) {
                            effectiveness = TypeChart.getEffectivenessAgainstTypes(moveType, randType1Name, randType2Name);
                        } else {
                            String addedType = BattleMessageSubscriber.getAddedType(opponentName);
                            if (addedType != null && !addedType.isEmpty()) {
                                String baseType1 = type1 != null ? type1.getName().toLowerCase() : null;
                                String baseType2 = type2 != null ? type2.getName().toLowerCase() : null;
                                float mult1 = baseType1 != null ? TypeChart.getEffectivenessAgainstTypes(moveType, baseType1, null) : 1.0f;
                                float mult2 = baseType2 != null ? TypeChart.getEffectivenessAgainstTypes(moveType, baseType2, null) : 1.0f;
                                float mult3 = TypeChart.getEffectivenessAgainstTypes(moveType, addedType, null);
                                effectiveness = mult1 * mult2 * mult3;
                            } else {
                                effectiveness = TypeChart.getEffectiveness(this.moveTemplate, type1, type2);
                            }
                        }
                    }
                }
                tooltip.add((Component)Component.empty());
                if (effectiveness == 0.0f) {
                    tooltip.add((Component)Component.translatable((String)"move.battleinfo.immune", (Object[])new Object[]{"\u00d70"}).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.BOLD}));
                } else if (effectiveness <= 0.25f) {
                    tooltip.add((Component)Component.translatable((String)"move.battleinfo.mostly_ineffective", (Object[])new Object[]{"\u00d70.25"}).withStyle(ChatFormatting.DARK_GRAY));
                } else if (effectiveness < 1.0f) {
                    tooltip.add((Component)Component.translatable((String)"move.battleinfo.not_effective", (Object[])new Object[]{"\u00d70.5"}).withStyle(ChatFormatting.GRAY));
                } else if (effectiveness == 1.0f) {
                    tooltip.add((Component)Component.literal((String)"\u2022 ").append((Component)Component.translatable((String)"move.battleinfo.normal_effective", (Object[])new Object[]{"\u00d71"})).withStyle(ChatFormatting.GRAY));
                } else if (effectiveness >= 4.0f) {
                    tooltip.add((Component)Component.translatable((String)"move.battleinfo.extremely_effective", (Object[])new Object[]{"\u00d74"}).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                } else {
                    tooltip.add((Component)Component.translatable((String)"move.battleinfo.super_effective", (Object[])new Object[]{"\u00d72"}).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
                }
            }
            if (!tooltip.isEmpty()) {
                ElementalType moveType = this.moveTemplate.getElementalType();
                DamageCategory moveCategory = this.moveTemplate.getDamageCategory();
                if (BattleExtrasConfig.isVanillaStyleMoveTooltipsEnabled()) {
                    CustomTooltipRenderer.renderVanillaStyleMoveTooltip(context, tooltip, tooltipX, tooltipY, typeColor, moveType, moveCategory);
                } else {
                    CustomTooltipRenderer.renderMoveTooltipWithIcons(context, tooltip, tooltipX, tooltipY, typeColor, moveType, moveCategory);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getEffectDescriptionFromMove(MoveTemplate move) {
        String name = move.getName().toLowerCase();
        if (name.contains("thunder") || name.contains("spark") || name.contains("bolt") || name.contains("zap") || name.contains("shock") || name.contains("nuzzle")) {
            return " Paralyze";
        }
        if (name.contains("fire") || name.contains("flame") || name.contains("burn") || name.contains("ember") || name.contains("blaze") || name.contains("scald") || name.contains("lava") || name.contains("inferno") || name.contains("heat")) {
            return " Burn";
        }
        if (name.contains("ice") || name.contains("freeze") || name.contains("blizzard") || name.contains("frost") || name.contains("cold")) {
            return " Freeze";
        }
        if (name.contains("poison") || name.contains("toxic") || name.contains("sludge") || name.contains("venom") || name.contains("smog")) {
            return " Poison";
        }
        if (name.contains("sleep") || name.contains("hypnosis") || name.contains("yawn") || name.contains("spore") || name.contains("sing") || name.contains("rest")) {
            return " Sleep";
        }
        if (name.contains("confuse") || name.contains("confusion") || name.contains("dizzy")) {
            return " Confuse";
        }
        if (name.contains("flinch") || name.contains("bite") || name.contains("headbutt") || name.contains("stomp") || name.contains("rock slide") || name.contains("iron head")) {
            return " Flinch";
        }
        if (name.contains("growl") || name.contains("leer") || name.contains("charm")) {
            return " Stat \u2193";
        }
        if (name.contains("swords") || name.contains("dragon dance") || name.contains("nasty plot")) {
            return " Stat \u2191";
        }
        return "";
    }

    private List<String> wrapText(String text, int maxCharsPerLine) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > maxCharsPerLine && currentLine.length() > 0) {
                lines.add(currentLine.toString().trim());
                currentLine = new StringBuilder();
            }
            currentLine.append(word).append(" ");
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString().trim());
        }
        return lines;
    }

    private String formatMoveName(String name) {
        String[] completeMoveNames;
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.contains(" ")) {
            return this.capitalizeWords(name);
        }
        if (name.contains("_")) {
            return this.capitalizeWords(name.replace("_", " "));
        }
        String spaced = name.replaceAll("([a-z])([A-Z])", "$1 $2");
        if (spaced.contains(" ")) {
            return this.capitalizeWords(spaced);
        }
        String lower = name.toLowerCase();
        for (String completeName : completeMoveNames = new String[]{"ingrain", "agility", "amnesia", "attract", "barrier", "bide", "blizzard", "disable", "embargo", "encore", "endure", "entrainment", "explosion", "facade", "fissure", "flatter", "foresight", "frustration", "growl", "guillotine", "harden", "hypnosis", "imprison", "incinerate", "inferno", "magnitude", "meditate", "memento", "metronome", "mimic", "minimize", "moonlight", "nightmare", "outrage", "overheat", "payback", "protect", "psych", "psychic", "pursuit", "quiver", "rage", "recover", "recycle", "reflect", "refresh", "rest", "retaliate", "return", "revenge", "roar", "safeguard", "screech", "selfdestruct", "sharpen", "sketch", "snore", "splash", "spore", "stockpile", "stomp", "strength", "struggle", "substitute", "swagger", "swallow", "switcheroo", "synthesis", "tackle", "tailwind", "taunt", "teleport", "thrash", "tickle", "torment", "toxic", "transform", "uproar", "venoshock", "whirlpool", "withdraw", "yawn"}) {
            if (!lower.equals(completeName)) continue;
            return this.capitalize(completeName);
        }
        String[] moveWords = new String[]{"chip", "away", "leer", "tackle", "scratch", "pound", "slam", "stomp", "kick", "punch", "slap", "strike", "smash", "crush", "bash", "whack", "swipe", "slash", "cut", "chop", "hack", "rend", "tear", "rip", "bite", "crunch", "chomp", "gnaw", "fang", "claw", "horn", "tusk", "peck", "drill", "stab", "pierce", "thrust", "lunge", "charge", "rush", "dash", "quick", "swift", "rapid", "speed", "agility", "haste", "throw", "fling", "toss", "hurl", "launch", "shoot", "fire", "blast", "gun", "beam", "ray", "pulse", "wave", "burst", "explosion", "boom", "bang", "spin", "roll", "tumble", "flip", "twist", "whirl", "twirl", "gyro", "jump", "leap", "hop", "bounce", "spring", "vault", "soar", "fly", "dive", "plunge", "drop", "fall", "crash", "land", "wrap", "bind", "squeeze", "constrict", "coil", "trap", "snare", "grab", "hold", "grip", "seize", "catch", "snatch", "steal", "thief", "block", "guard", "shield", "protect", "defend", "barrier", "wall", "dodge", "evade", "avoid", "escape", "flee", "run", "retreat", "vine", "whip", "razor", "leaf", "petal", "seed", "spore", "powder", "grass", "plant", "flower", "bloom", "blossom", "garden", "forest", "jungle", "water", "aqua", "hydro", "surf", "splash", "bubble", "foam", "rain", "drizzle", "storm", "flood", "torrent", "cascade", "waterfall", "flame", "blaze", "scorch", "sear", "ember", "inferno", "heat", "warm", "hot", "lava", "magma", "volcano", "eruption", "ice", "freeze", "frost", "cold", "chill", "snow", "hail", "blizzard", "icicle", "glacier", "arctic", "polar", "winter", "frozen", "electric", "thunder", "lightning", "bolt", "shock", "spark", "zap", "volt", "static", "magnetic", "electro", "plasma", "current", "ground", "earth", "rock", "stone", "boulder", "pebble", "sand", "mud", "dirt", "soil", "quake", "tremor", "fissure", "earthquake", "psychic", "psych", "mind", "mental", "brain", "telekinesis", "telepathy", "confusion", "hypnosis", "dream", "sleep", "rest", "wake", "nightmare", "ghost", "shadow", "shade", "spirit", "soul", "haunt", "curse", "hex", "dark", "night", "black", "evil", "wicked", "sinister", "foul", "nasty", "dragon", "draconic", "draco", "rage", "rampage", "outrage", "fury", "fairy", "charm", "cute", "sweet", "lovely", "beauty", "grace", "elegant", "steel", "iron", "metal", "chrome", "silver", "gold", "bronze", "copper", "poison", "toxic", "venom", "acid", "sludge", "smog", "gas", "fume", "bug", "insect", "beetle", "spider", "web", "string", "silk", "cocoon", "flying", "air", "wind", "gust", "breeze", "tornado", "hurricane", "cyclone", "fighting", "combat", "battle", "martial", "karate", "judo", "normal", "basic", "simple", "plain", "regular", "standard", "common", "attack", "defense", "special", "accuracy", "evasion", "power", "force", "strength", "might", "energy", "aura", "chi", "ki", "boost", "raise", "increase", "enhance", "buff", "up", "rise", "grow", "lower", "reduce", "decrease", "weaken", "debuff", "down", "heal", "recover", "restore", "cure", "remedy", "medicine", "potion", "damage", "hurt", "harm", "pain", "wound", "injure", "destroy", "demolish", "status", "condition", "effect", "state", "mode", "form", "change", "paralyze", "confuse", "attract", "super", "hyper", "ultra", "mega", "giga", "tera", "max", "extreme", "double", "triple", "multi", "twin", "dual", "combo", "chain", "link", "cross", "plus", "minus", "zero", "one", "two", "three", "four", "five", "first", "second", "third", "last", "final", "ultimate", "supreme", "solar", "lunar", "sun", "moon", "star", "cosmic", "space", "galaxy", "light", "bright", "shine", "glow", "flash", "gleam", "sparkle", "glitter", "head", "body", "tail", "arm", "leg", "wing", "fin", "tentacle", "eye", "ear", "nose", "mouth", "tongue", "tooth", "teeth", "jaw", "roar", "growl", "howl", "screech", "scream", "cry", "yell", "shout", "sing", "song", "melody", "tune", "music", "sound", "noise", "echo", "dance", "sway", "groove", "rhythm", "beat", "tempo", "move", "motion", "ball", "bomb", "canon", "cannon", "shot", "arrow", "spear", "sword", "axe", "hammer", "mallet", "club", "staff", "wand", "rod", "stick", "tail", "wing", "claw", "fang", "bite", "sting", "horn", "tusk", "flare", "nova", "comet", "meteor", "asteroid", "orbit", "void", "scald", "steam", "mist", "fog", "haze", "cloud", "sky", "heaven", "hell", "abyss", "void", "null", "empty", "full", "half", "part", "whole", "complete", "total", "partial", "minor", "major", "critical", "secret", "hidden", "stealth", "sneak", "ambush", "surprise", "trap", "toxic", "spit", "spray", "jet", "stream", "geyser", "fountain", "needle", "spine", "thorn", "barb", "spike", "point", "edge", "blade", "reversal", "revenge", "payback", "return", "retaliate", "counter", "bulk", "mass", "weight", "heavy", "light", "feather", "float", "sink", "anchor", "lock", "key", "door", "gate", "portal", "warp", "teleport", "psycho", "mind", "will", "spirit", "heart", "core", "center", "focus", "aurora", "veil", "screen", "reflect", "safeguard", "wish", "trick", "room", "tailwind", "weather", "terrain", "zone", "field", "arena", "court", "sword", "shield", "armor", "shell", "protect", "detect", "endure", "follow", "pursuit", "chase", "hunt", "track", "search", "find", "seek", "sucker", "fake", "feint", "bait", "lure", "decoy", "taunt", "encore", "disable", "imprison", "spite", "grudge", "destiny", "bond", "perish", "assist", "copy", "mimic", "sketch", "metronome", "transform", "ditto", "baton", "pass", "relay", "switch", "pivot", "uturn", "volt", "close", "mach", "bullet", "vacuum", "extreme", "priority", "aqua", "jet", "accel", "rock", "detect", "mat", "block", "wide", "breaking", "swipe", "surging", "strikes", "make", "it", "rain", "stomping", "tantrum", "plot", "smack"};
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < lower.length()) {
            String bestMatch = null;
            int bestLen = 0;
            for (String word : moveWords) {
                if (!lower.startsWith(word, i) || word.length() <= bestLen) continue;
                bestMatch = word;
                bestLen = word.length();
            }
            if (bestMatch != null) {
                if (result.length() > 0) {
                    result.append(" ");
                }
                result.append(this.capitalize(bestMatch));
                i += bestLen;
                continue;
            }
            char c = lower.charAt(i);
            if (result.length() == 0) {
                result.append(Character.toUpperCase(c));
            } else if (result.charAt(result.length() - 1) == ' ') {
                result.append(Character.toUpperCase(c));
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private String capitalizeWords(String str) {
        String[] words = str.split(" ");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(this.capitalize(words[i]));
        }
        return result.toString();
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1).toLowerCase();
    }

    private List<ElementalType> getCurrentFormTypes(ClientBattlePokemon battlePokemon) {
        Object methodUsed;
        ArrayList<ElementalType> types;
        long currentTime;
        String pokemonId;
        block59: {
            block58: {
                Method getTypes;
                Object typesObj;
                Object form;
                block57: {
                    pokemonId = null;
                    String formName = null;
                    String speciesName = null;
                    try {
                        Method getProperties = battlePokemon.getClass().getMethod("getProperties", new Class[0]);
                        Object properties = getProperties.invoke((Object)battlePokemon, new Object[0]);
                        if (properties != null) {
                            Method getFormMethod = properties.getClass().getMethod("getForm", new Class[0]);
                            formName = getFormMethod.invoke(properties, new Object[0]).toString();
                            Method getSpeciesMethod = battlePokemon.getClass().getMethod("getSpecies", new Class[0]);
                            Object species = getSpeciesMethod.invoke((Object)battlePokemon, new Object[0]);
                            if (species != null) {
                                speciesName = species.toString();
                            }
                        }
                        pokemonId = speciesName + "_" + formName;
                    }
                    catch (Throwable e) {
                        pokemonId = "unknown_" + System.identityHashCode(battlePokemon);
                    }
                    currentTime = System.currentTimeMillis();
                    if (pokemonId.equals(cachedOpponentId) && cachedFormTypes != null && currentTime - lastCacheTime < 1000L) {
                        return new ArrayList<ElementalType>(cachedFormTypes);
                    }
                    types = new ArrayList<ElementalType>();
                    methodUsed = "none";
                    try {
                        Method getEffectedPokemon = battlePokemon.getClass().getMethod("getEffectedPokemon", new Class[0]);
                        String[] effectedPokemon = getEffectedPokemon.invoke((Object)battlePokemon, new Object[0]);
                        if (effectedPokemon == null) break block57;
                        try {
                            Method getTypes2;
                            Object typesObj2;
                            Method getForm = effectedPokemon.getClass().getMethod("getForm", new Class[0]);
                            Object form2 = getForm.invoke((Object)effectedPokemon, new Object[0]);
                            if (form2 != null && (typesObj2 = (getTypes2 = form2.getClass().getMethod("getTypes", new Class[0])).invoke(form2, new Object[0])) instanceof Iterable) {
                                for (Object type : (Iterable)typesObj2) {
                                    if (!(type instanceof ElementalType)) continue;
                                    types.add((ElementalType)type);
                                }
                                if (!types.isEmpty()) {
                                    methodUsed = "effectedPokemon.getForm()";
                                }
                            }
                        }
                        catch (Throwable getForm) {
                            // empty catch block
                        }
                        if (!types.isEmpty()) break block57;
                        try {
                            Method getPrimaryType = effectedPokemon.getClass().getMethod("getPrimaryType", new Class[0]);
                            Method getSecondaryType = effectedPokemon.getClass().getMethod("getSecondaryType", new Class[0]);
                            ElementalType type1 = (ElementalType)getPrimaryType.invoke((Object)effectedPokemon, new Object[0]);
                            ElementalType type2 = (ElementalType)getSecondaryType.invoke((Object)effectedPokemon, new Object[0]);
                            if (type1 != null) {
                                types.add(type1);
                            }
                            if (type2 != null) {
                                types.add(type2);
                            }
                            if (!types.isEmpty()) {
                                methodUsed = "effectedPokemon types";
                            }
                        }
                        catch (Throwable getPrimaryType) {}
                    }
                    catch (Throwable getEffectedPokemon) {
                        // empty catch block
                    }
                }
                if (types.isEmpty()) {
                    String[] pokemonGetterMethods;
                    for (String methodName : pokemonGetterMethods = new String[]{"getPokemon", "pokemon", "getOriginalPokemon"}) {
                        try {
                            Method method = battlePokemon.getClass().getMethod(methodName, new Class[0]);
                            Object pokemon = method.invoke((Object)battlePokemon, new Object[0]);
                            if (pokemon == null) continue;
                            try {
                                Method getForm = pokemon.getClass().getMethod("getForm", new Class[0]);
                                form = getForm.invoke(pokemon, new Object[0]);
                                if (form == null || !((typesObj = (getTypes = form.getClass().getMethod("getTypes", new Class[0])).invoke(form, new Object[0])) instanceof Iterable)) continue;
                                for (Object type : (Iterable)typesObj) {
                                    if (!(type instanceof ElementalType)) continue;
                                    types.add((ElementalType)type);
                                }
                                if (types.isEmpty()) continue;
                                methodUsed = (String)methodName + ".getForm()";
                                break;
                            }
                            catch (Throwable getForm) {
                            }
                        }
                        catch (Throwable method) {
                            // empty catch block
                        }
                    }
                }
                if (types.isEmpty()) {
                    try {
                        Method getTypes3;
                        Object typesObj3;
                        Method getForm = battlePokemon.getClass().getMethod("getForm", new Class[0]);
                        Object form3 = getForm.invoke((Object)battlePokemon, new Object[0]);
                        if (form3 != null && (typesObj3 = (getTypes3 = form3.getClass().getMethod("getTypes", new Class[0])).invoke(form3, new Object[0])) instanceof Iterable) {
                            for (Object type : (Iterable)typesObj3) {
                                if (!(type instanceof ElementalType)) continue;
                                types.add((ElementalType)type);
                            }
                            if (!types.isEmpty()) {
                                methodUsed = "battlePokemon.getForm()";
                            }
                        }
                    }
                    catch (Throwable getForm) {
                        // empty catch block
                    }
                }
                if (types.isEmpty()) {
                    try {
                        Method getProperties = battlePokemon.getClass().getMethod("getProperties", new Class[0]);
                        Object properties = getProperties.invoke((Object)battlePokemon, new Object[0]);
                        if (properties == null) break block58;
                        Method getFormMethod = properties.getClass().getMethod("getForm", new Class[0]);
                        Object formNameObj = getFormMethod.invoke(properties, new Object[0]);
                        Method getSpeciesMethod = battlePokemon.getClass().getMethod("getSpecies", new Class[0]);
                        Object species = getSpeciesMethod.invoke((Object)battlePokemon, new Object[0]);
                        if (formNameObj == null || species == null) break block58;
                        String formNameStr = formNameObj.toString();
                        try {
                            Method getFormByName = species.getClass().getMethod("getForm", String.class);
                            form = getFormByName.invoke(species, formNameStr);
                            if (form != null && (typesObj = (getTypes = form.getClass().getMethod("getTypes", new Class[0])).invoke(form, new Object[0])) instanceof Iterable) {
                                for (Object type : (Iterable)typesObj) {
                                    if (!(type instanceof ElementalType)) continue;
                                    types.add((ElementalType)type);
                                }
                                if (!types.isEmpty()) {
                                    methodUsed = "species.getForm(name)";
                                }
                            }
                        }
                        catch (NoSuchMethodException e) {
                            try {
                                Method getForms = species.getClass().getMethod("getForms", new Class[0]);
                                Object forms = getForms.invoke(species, new Object[0]);
                                if (!(forms instanceof Iterable)) break block58;
                                int formCount = 0;
                                for (Object form4 : (Iterable)forms) {
                                    String normalizedFormName;
                                    ++formCount;
                                    Method getName = form4.getClass().getMethod("getName", new Class[0]);
                                    String name = getName.invoke(form4, new Object[0]).toString();
                                    String normalizedName = name.replaceAll("[''`\u00b4-]", "").toLowerCase();
                                    if (!normalizedName.equals(normalizedFormName = formNameStr.replaceAll("[''`\u00b4-]", "").toLowerCase())) continue;
                                    Method getTypes4 = form4.getClass().getMethod("getTypes", new Class[0]);
                                    Object typesObj4 = getTypes4.invoke(form4, new Object[0]);
                                    if (typesObj4 instanceof Iterable) {
                                        for (Object type : (Iterable)typesObj4) {
                                            if (!(type instanceof ElementalType)) continue;
                                            types.add((ElementalType)type);
                                        }
                                        if (!types.isEmpty()) {
                                            methodUsed = "species.getForms() iteration";
                                        }
                                    }
                                    break;
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Throwable getProperties) {
                        // empty catch block
                    }
                }
            }
            if (types.isEmpty()) {
                try {
                    Pokemon pokemon = battlePokemon.getProperties().create();
                    if (pokemon == null) break block59;
                    try {
                        Method getTypes;
                        Object typesObj;
                        Method getForm = pokemon.getClass().getMethod("getForm", new Class[0]);
                        Object form = getForm.invoke((Object)pokemon, new Object[0]);
                        if (form != null && (typesObj = (getTypes = form.getClass().getMethod("getTypes", new Class[0])).invoke(form, new Object[0])) instanceof Iterable) {
                            for (Object type : (Iterable)typesObj) {
                                if (!(type instanceof ElementalType)) continue;
                                types.add((ElementalType)type);
                            }
                            if (!types.isEmpty()) {
                                methodUsed = "create().getForm() fallback";
                            }
                        }
                    }
                    catch (Throwable e) {
                        ElementalType type1 = pokemon.getPrimaryType();
                        ElementalType type2 = pokemon.getSecondaryType();
                        if (type1 != null) {
                            types.add(type1);
                        }
                        if (type2 != null) {
                            types.add(type2);
                        }
                        if (!types.isEmpty()) {
                            methodUsed = "create() primary/secondary fallback";
                        }
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("[getCurrentFormTypes] All methods failed for Pokemon ID: {}", (Object)pokemonId, (Object)e);
                }
            }
        }
        if (types.isEmpty()) {
            methodUsed = "FAILED - no types found";
            LOGGER.warn("[getCurrentFormTypes] Failed to get types for Pokemon ID: {}", (Object)pokemonId);
        } else {
            String typeNames = types.stream().map(t -> t.getName()).reduce((a, b) -> a + "/" + b).orElse("none");
            CobblemonBattleInfoClient.debug("[getCurrentFormTypes] Pokemon ID: {}, Types: {}, Method: {}", pokemonId, typeNames, methodUsed);
        }
        cachedOpponentId = pokemonId;
        cachedFormTypes = new ArrayList<ElementalType>(types);
        lastCacheTime = currentTime;
        return types;
    }

    private String getPlayerPokemonName(ClientBattlePokemon battlePokemon) {
        if (battlePokemon == null) {
            return null;
        }
        try {
            Pokemon pokemon = battlePokemon.getProperties().create();
            return pokemon.getSpecies().getName().toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    private ClientBattlePokemon getPlayerActivePokemon(ClientBattle battle) {
        if (battle == null) {
            return null;
        }
        try {
            ClientBattleActor firstActor;
            List activePokemon;
            ClientBattleSide playerSide;
            List actors;
            SingleActionRequest request = battle.getFirstUnansweredRequest();
            boolean side1IsPlayer = false;
            if (request != null) {
                ClientBattleActor requestActor = request.getActivePokemon().getActor();
                for (ClientBattleActor actor : battle.getSide1().getActors()) {
                    if (actor != requestActor) continue;
                    side1IsPlayer = true;
                    break;
                }
            } else {
                side1IsPlayer = true;
            }
            if (!(actors = (playerSide = side1IsPlayer ? battle.getSide1() : battle.getSide2()).getActors()).isEmpty() && !(activePokemon = (firstActor = (ClientBattleActor)actors.get(0)).getActivePokemon()).isEmpty()) {
                ActiveClientBattlePokemon active = (ActiveClientBattlePokemon)activePokemon.get(0);
                return active.getBattlePokemon();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private float calculateStabMultiplier(MoveTemplate move, ClientBattlePokemon playerPokemon, String pokemonName) {
        if (move == null || playerPokemon == null || pokemonName == null) {
            return 1.0f;
        }
        try {
            String moveType = move.getElementalType().getName().toLowerCase();
            CobblemonBattleInfoClient.debug("[STAB] Checking STAB for {} using {} move (type: {})", pokemonName, move.getName(), moveType);
            String transformedType = BattleMessageSubscriber.getTransformedType(pokemonName);
            if (transformedType != null && !transformedType.isEmpty()) {
                boolean hasStab = transformedType.equalsIgnoreCase(moveType);
                CobblemonBattleInfoClient.debug("[STAB] {} has transformed type: {}, move type: {}, STAB: {}", pokemonName, transformedType, moveType, hasStab);
                return hasStab ? 1.5f : 1.0f;
            }
            List<String> megaTypes = BattleMessageSubscriber.getMegaTypes(pokemonName);
            if (megaTypes != null && !megaTypes.isEmpty()) {
                for (String megaType : megaTypes) {
                    if (megaType == null || !megaType.equalsIgnoreCase(moveType)) continue;
                    CobblemonBattleInfoClient.debug("[STAB] {} has mega type {} matching move type {}, STAB: true", pokemonName, megaType, moveType);
                    return 1.5f;
                }
                CobblemonBattleInfoClient.debug("[STAB] {} has mega types {} but none match move type {}", pokemonName, megaTypes, moveType);
                return 1.0f;
            }
            try {
                String pokemonUUID = playerPokemon.getUuid().toString();
                List<ElementalType> displayTypes = TypeIconRenderer.getDisplayTypes(playerPokemon, pokemonName, "player", pokemonUUID);
                if (displayTypes != null && !displayTypes.isEmpty()) {
                    Iterator<ElementalType> iterator = displayTypes.iterator();
                    while (iterator.hasNext()) {
                        ElementalType type = iterator.next();
                        if (type == null || !type.getName().equalsIgnoreCase(moveType)) continue;
                        CobblemonBattleInfoClient.debug("[STAB] {} has type {} (from getDisplayTypes) matching move type {}, STAB: true", pokemonName, type.getName(), moveType);
                        return 1.5f;
                    }
                    CobblemonBattleInfoClient.debug("[STAB] {} has types {} but none match move type {}", pokemonName, displayTypes.stream().map(t -> t.getName()).reduce((a, b) -> a + "/" + b).orElse("NONE"), moveType);
                    return 1.0f;
                }
            }
            catch (Throwable e) {
                CobblemonBattleInfoClient.debug("[STAB] Error using getDisplayTypes: {}", e.getMessage());
            }
            List<ElementalType> baseTypes = this.getCurrentFormTypes(playerPokemon);
            CobblemonBattleInfoClient.debug("[STAB] {} base types from getCurrentFormTypes: {}", pokemonName, baseTypes.isEmpty() ? "EMPTY" : baseTypes.stream().map(t -> t.getName()).reduce((a, b) -> a + "/" + b).orElse("NONE"));
            for (ElementalType type : baseTypes) {
                if (type == null || !type.getName().equalsIgnoreCase(moveType)) continue;
                CobblemonBattleInfoClient.debug("[STAB] {} base type {} matches move type {}, STAB: true", pokemonName, type.getName(), moveType);
                return 1.5f;
            }
            String teraType = BattleMessageSubscriber.getTeraType(pokemonName);
            if (teraType != null && !teraType.isEmpty() && teraType.equalsIgnoreCase(moveType)) {
                CobblemonBattleInfoClient.debug("[STAB] {} tera type {} matches move type {}, STAB: true", pokemonName, teraType, moveType);
                return 1.5f;
            }
            String addedType = BattleMessageSubscriber.getAddedType(pokemonName);
            if (addedType != null && !addedType.isEmpty() && addedType.equalsIgnoreCase(moveType)) {
                CobblemonBattleInfoClient.debug("[STAB] {} added type {} matches move type {}, STAB: true", pokemonName, addedType, moveType);
                return 1.5f;
            }
            CobblemonBattleInfoClient.debug("[STAB] No STAB match found for {} with move type {}", pokemonName, moveType);
        }
        catch (Exception e) {
            LOGGER.error("[STAB] Error calculating STAB for {}: {}", (Object)pokemonName, (Object)e.getMessage());
        }
        return 1.0f;
    }

    private String getCachedPlayerAbility(String pokemonName, Pokemon pokemon, ClientBattlePokemon battlePokemon) {
        String lowerAbility;
        String abilityName;
        boolean currentIsMega;
        long currentTime;
        block17: {
            Method getNameMethod2;
            Object ability;
            Method getAbilityMethod2;
            if (pokemonName == null || pokemon == null) {
                return null;
            }
            currentTime = System.currentTimeMillis();
            currentIsMega = BattleMessageSubscriber.isMegaEvolved(pokemonName);
            if (CritChanceCache.shouldClearAndReset()) {
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Clearing ability cache due to Mega Evolution flag", new Object[0]);
                MoveTileMixin.clearPlayerAbilityCache();
            }
            if (cachedPlayerPokemonId != null && cachedPlayerPokemonId.equals(pokemonName) && cachedPlayerAbility != null && currentTime - lastAbilityCacheTime < 1000L && cachedPlayerIsMega == currentIsMega) {
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Using cached ability for {}: {} (isMega: {})", pokemonName, cachedPlayerAbility, currentIsMega);
                return cachedPlayerAbility;
            }
            if (cachedPlayerPokemonId != null && cachedPlayerPokemonId.equals(pokemonName) && cachedPlayerIsMega != currentIsMega) {
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Mega Evolution state changed for {}: {} -> {}, refreshing ability", pokemonName, cachedPlayerIsMega, currentIsMega);
            }
            abilityName = null;
            try {
                getAbilityMethod2 = pokemon.getClass().getMethod("getAbility", new Class[0]);
                ability = getAbilityMethod2.invoke((Object)pokemon, new Object[0]);
                if (ability != null) {
                    try {
                        getNameMethod2 = ability.getClass().getMethod("getName", new Class[0]);
                        abilityName = (String)getNameMethod2.invoke(ability, new Object[0]);
                    }
                    catch (Exception getNameMethod2) {}
                }
            }
            catch (Exception getAbilityMethod2) {
                // empty catch block
            }
            if (abilityName == null || "pressure".equals(abilityName.toLowerCase())) {
                try {
                    getAbilityMethod2 = battlePokemon.getClass().getMethod("getAbility", new Class[0]);
                    ability = getAbilityMethod2.invoke((Object)battlePokemon, new Object[0]);
                    if (ability == null) break block17;
                    try {
                        getNameMethod2 = ability.getClass().getMethod("getName", new Class[0]);
                        String battleAbilityName = (String)getNameMethod2.invoke(ability, new Object[0]);
                        if (battleAbilityName != null && !"pressure".equals(battleAbilityName.toLowerCase())) {
                            abilityName = battleAbilityName;
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception getAbilityMethod3) {
                    // empty catch block
                }
            }
        }
        if ("absol".equals(pokemonName) && (abilityName == null || "pressure".equals(abilityName.toLowerCase()))) {
            abilityName = "superluck";
        }
        if ("absol".equals(pokemonName) && abilityName != null && (!"superluck".equals(lowerAbility = abilityName.toLowerCase()) || !"pressure".equals(cachedPlayerAbility)) && "pressure".equals(lowerAbility) && "superluck".equals(cachedPlayerAbility)) {
            return cachedPlayerAbility;
        }
        cachedPlayerPokemonId = pokemonName;
        cachedPlayerAbility = abilityName;
        cachedPlayerIsMega = currentIsMega;
        lastAbilityCacheTime = currentTime;
        CobblemonBattleInfoClient.debug("[MoveTileMixin] Cached ability for {}: {} (isMega: {})", pokemonName, abilityName, currentIsMega);
        return abilityName;
    }

    private static void clearPlayerAbilityCache() {
        cachedPlayerPokemonId = null;
        cachedPlayerAbility = null;
        cachedPlayerIsMega = false;
        lastAbilityCacheTime = 0L;
    }

    private boolean isMegaEvolved(Pokemon pokemon) {
        if (pokemon == null) {
            return false;
        }
        try {
            Method getAspectsMethod = pokemon.getClass().getMethod("getAspects", new Class[0]);
            Object aspectsSet = getAspectsMethod.invoke((Object)pokemon, new Object[0]);
            if (aspectsSet != null) {
                String aspectsString = aspectsSet.toString().toLowerCase();
                return aspectsString.contains("mega_evolution=mega") || aspectsString.contains("mega_evolution=mega_x") || aspectsString.contains("mega_evolution=mega_y");
            }
        }
        catch (Exception e) {
            try {
                String speciesName = pokemon.getSpecies().getName().toLowerCase();
                return speciesName.contains("mega");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean checkPokemonHeldItemForCrit(Pokemon pokemon) {
        String[] fieldNames;
        String[] methodNames;
        if (pokemon == null) {
            return false;
        }
        for (String methodName : methodNames = new String[]{"heldItem", "getHeldItem"}) {
            try {
                Method method = pokemon.getClass().getMethod(methodName, new Class[0]);
                Object heldItem = method.invoke((Object)pokemon, new Object[0]);
                if (heldItem == null || !this.isCritItem(heldItem)) continue;
                return true;
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        for (String fieldName : fieldNames = new String[]{"heldItemNoCopy", "heldItem"}) {
            try {
                Field field = pokemon.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                Object heldItem = field.get(pokemon);
                if (heldItem == null || !this.isCritItem(heldItem)) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isCritItem(Object item) {
        if (item == null) {
            return false;
        }
        try {
            String itemString = item.toString().toLowerCase();
            CobblemonBattleInfoClient.debug("[MoveTileMixin] Checking item: {}", itemString);
            if (itemString.contains("minecraft:air")) {
                return false;
            }
            if (itemString.contains("razor_claw") || itemString.contains("razorclaw") || itemString.contains("scope_lens") || itemString.contains("scopelens")) {
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Found crit-boosting item: {}", itemString);
                return true;
            }
            try {
                String resultStr;
                Method getIdMethod = item.getClass().getMethod("getId", new Class[0]);
                Object result = getIdMethod.invoke(item, new Object[0]);
                if (result != null && ((resultStr = result.toString().toLowerCase()).contains("razor_claw") || resultStr.contains("scope_lens"))) {
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Found crit-boosting item via getId: {}", resultStr);
                    return true;
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[MoveTileMixin] Error checking if item is crit item: {}", e.getMessage());
        }
        return false;
    }

    private boolean checkBattlePokemonHeldItemForCrit(ClientBattlePokemon battlePokemon) {
        String[] fieldNames;
        String[] methodNames;
        if (battlePokemon == null) {
            return false;
        }
        for (String methodName : methodNames = new String[]{"getHeldItem", "heldItem"}) {
            try {
                Method method = battlePokemon.getClass().getMethod(methodName, new Class[0]);
                Object heldItem = method.invoke((Object)battlePokemon, new Object[0]);
                if (heldItem == null || !this.isCritItem(heldItem)) continue;
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Found crit item via BattlePokemon.{}: {}", methodName, heldItem);
                return true;
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        for (String fieldName : fieldNames = new String[]{"heldItem", "item"}) {
            try {
                Field field = battlePokemon.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                Object heldItem = field.get(battlePokemon);
                if (heldItem == null || !this.isCritItem(heldItem)) continue;
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Found crit item via BattlePokemon field {}: {}", fieldName, heldItem);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private double getCritChancePercentage(String pokemonName, ClientBattlePokemon battlePokemon, MoveTemplate move) {
        if (pokemonName == null) {
            return 4.17;
        }
        int critStage = 0;
        CobblemonBattleInfoClient.debug("[MoveTileMixin] ========================================", new Object[0]);
        CobblemonBattleInfoClient.debug("[MoveTileMixin] Calculating crit chance for: {}", pokemonName);
        CobblemonBattleInfoClient.debug("[MoveTileMixin] Move: {}", move != null ? move.getName() : "null");
        try {
            Map<String, Integer> statStages;
            if (move != null) {
                try {
                    Method getCritRatioMethod = move.getClass().getMethod("getCritRatio", new Class[0]);
                    Object critRatioObj = getCritRatioMethod.invoke((Object)move, new Object[0]);
                    if (critRatioObj != null) {
                        int critRatio = 0;
                        if (critRatioObj instanceof Integer) {
                            critRatio = (Integer)critRatioObj;
                        } else if (critRatioObj instanceof Double) {
                            critRatio = ((Double)critRatioObj).intValue();
                        }
                        CobblemonBattleInfoClient.debug("[MoveTileMixin] Move crit ratio: {}", critRatio);
                        if (critRatio > 1) {
                            int stageBonus = critRatio - 1;
                            CobblemonBattleInfoClient.debug("[MoveTileMixin] \u2713\u2713\u2713 High-crit move! Added {} stage(s) (critStage now: {})", stageBonus, critStage += stageBonus);
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] getCritRatio method not found, move likely has normal crit ratio", new Object[0]);
                }
                catch (Exception e) {
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Error checking move crit ratio: {}", e.getMessage());
                }
            }
            if ((statStages = BattleMessageSubscriber.getStatStagesForPokemon("player", pokemonName)) != null && statStages.containsKey("Crit")) {
                int statCritStage = statStages.get("Crit");
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Added {} crit stage(s) from stat stages (critStage now: {})", statCritStage, critStage += statCritStage);
            } else {
                CobblemonBattleInfoClient.debug("[MoveTileMixin] No base crit stages found", new Object[0]);
            }
            CobblemonBattleInfoClient.debug("[MoveTileMixin] Checking for held items...", new Object[0]);
            String heldItem = BattleMessageSubscriber.getHeldItem(pokemonName);
            if (heldItem != null) {
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Held item: {}", heldItem);
                String lowerItem = heldItem.toLowerCase();
                if (lowerItem.contains("razor_claw") || lowerItem.contains("razorclaw") || lowerItem.contains("scope_lens") || lowerItem.contains("scopelens")) {
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] \u2713\u2713\u2713 Held item boosts crit! (critStage now: {})", ++critStage);
                } else if (lowerItem.contains("lucky_punch") || lowerItem.contains("luckypunch")) {
                    if (pokemonName.equalsIgnoreCase("chansey")) {
                        CobblemonBattleInfoClient.debug("[MoveTileMixin] \u2713\u2713\u2713 Lucky Punch detected for Chansey! (critStage now: {})", critStage += 2);
                    }
                } else if ((lowerItem.contains("leek") || lowerItem.contains("stick")) && (pokemonName.equalsIgnoreCase("farfetchd") || pokemonName.equalsIgnoreCase("farfetch'd") || pokemonName.equalsIgnoreCase("sirfetchd") || pokemonName.equalsIgnoreCase("sirfetch'd"))) {
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] \u2713\u2713\u2713 Leek detected for Farfetch'd/Sirfetch'd! (critStage now: {})", critStage += 2);
                }
            } else {
                CobblemonBattleInfoClient.debug("[MoveTileMixin] No held item", new Object[0]);
            }
            CobblemonBattleInfoClient.debug("[MoveTileMixin] Checking for ability bonuses...", new Object[0]);
            if (battlePokemon != null) {
                try {
                    Pokemon pokemon = battlePokemon.getProperties().create();
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Pokemon object: {}", pokemon);
                    if (pokemon != null) {
                        boolean isMega = BattleMessageSubscriber.isMegaEvolved(pokemonName);
                        CobblemonBattleInfoClient.debug("[MoveTileMixin] Is Mega Evolved: {}", isMega);
                        if (!isMega) {
                            String currentAbility = this.getCachedPlayerAbility(pokemonName, pokemon, battlePokemon);
                            CobblemonBattleInfoClient.debug("[MoveTileMixin] Current ability: {}", currentAbility);
                            if (currentAbility != null) {
                                String lowerAbilityName = currentAbility.toLowerCase();
                                if (lowerAbilityName.contains("super_luck") || lowerAbilityName.contains("superluck") || lowerAbilityName.contains("super luck") || lowerAbilityName.equals("superluck")) {
                                    CobblemonBattleInfoClient.debug("[MoveTileMixin] \u2713\u2713\u2713 Super Luck detected! (critStage now: {})", ++critStage);
                                } else {
                                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Ability does not boost crit: {}", currentAbility);
                                }
                            } else {
                                CobblemonBattleInfoClient.debug("[MoveTileMixin] No ability found (null)", new Object[0]);
                            }
                        } else {
                            CobblemonBattleInfoClient.debug("[MoveTileMixin] Skipping ability check because Pokemon is Mega Evolved", new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Ability check failed: {}", e.getMessage());
                    e.printStackTrace();
                }
            }
            CobblemonBattleInfoClient.debug("[MoveTileMixin] Final crit stage: {}", critStage);
            double result = critStage <= 0 ? 4.17 : (critStage == 1 ? 12.5 : (critStage == 2 ? 50.0 : 100.0));
            CobblemonBattleInfoClient.debug("[MoveTileMixin] Final crit chance: {}%", result);
            CobblemonBattleInfoClient.debug("[MoveTileMixin] ========================================", new Object[0]);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("[MoveTileMixin] Critical error in getCritChancePercentage", (Throwable)e);
            CobblemonBattleInfoClient.debug("[MoveTileMixin] Returning default 4.17%", new Object[0]);
            return 4.17;
        }
    }

    private double calculateAdjustedAccuracy(double baseAccuracy, String pokemonName, ClientBattlePokemon battlePokemon, MoveTemplate move) {
        if (baseAccuracy <= 0.0) {
            return baseAccuracy;
        }
        double adjustedAccuracy = baseAccuracy;
        if (move != null) {
            String moveName = move.getName().toLowerCase();
            String currentWeather = BattleMessageSubscriber.getCurrentWeather().toLowerCase();
            if (moveName.equals("thunder") || moveName.equals("hurricane")) {
                if (currentWeather.contains("rain")) {
                    adjustedAccuracy = 100.0;
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] {} in rain - 100% accuracy!", move.getName());
                    return adjustedAccuracy;
                }
                if (currentWeather.contains("sun") || currentWeather.contains("harsh")) {
                    adjustedAccuracy = 50.0;
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] {} in harsh sunlight - 50% accuracy!", move.getName());
                    return adjustedAccuracy;
                }
            }
            if (moveName.equals("blizzard") && (currentWeather.contains("snow") || currentWeather.contains("hail"))) {
                adjustedAccuracy = 100.0;
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Blizzard in snow/hail - 100% accuracy!", new Object[0]);
                return adjustedAccuracy;
            }
        }
        try {
            String heldItem;
            String abilityName;
            if (battlePokemon != null && (abilityName = this.getAbilityNameForAccuracy(battlePokemon)) != null) {
                String lowerAbility = abilityName.toLowerCase().replace(" ", "").replace("_", "");
                if (lowerAbility.equals("compoundeyes") || lowerAbility.equals("compoundlens")) {
                    adjustedAccuracy *= 1.3;
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Compound Eyes detected! Accuracy boosted by 30%", new Object[0]);
                } else if (lowerAbility.equals("victorystar")) {
                    adjustedAccuracy *= 1.1;
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Victory Star detected! Accuracy boosted by 10%", new Object[0]);
                } else if (lowerAbility.equals("hustle") && move != null && move.getDamageCategory() == DamageCategories.INSTANCE.getPHYSICAL()) {
                    adjustedAccuracy *= 0.8;
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Hustle detected! Physical move accuracy reduced by 20%", new Object[0]);
                }
            }
            Map<String, Integer> statStages = this.findStatsForPokemon(pokemonName);
            CobblemonBattleInfoClient.debug("[MoveTileMixin] calculateAdjustedAccuracy: pokemonName='{}', statStages={}", pokemonName, statStages);
            int accuracyStage = 0;
            if (statStages != null) {
                if (statStages.containsKey("accuracy")) {
                    accuracyStage = statStages.get("accuracy");
                } else if (statStages.containsKey("ACC")) {
                    accuracyStage = statStages.get("ACC");
                }
            }
            if (accuracyStage != 0) {
                double stageMultiplier = 1.0;
                if (accuracyStage > 0) {
                    stageMultiplier = (3.0 + (double)accuracyStage) / 3.0;
                } else if (accuracyStage < 0) {
                    stageMultiplier = 3.0 / (3.0 - (double)accuracyStage);
                }
                adjustedAccuracy *= stageMultiplier;
                CobblemonBattleInfoClient.debug("[MoveTileMixin] Accuracy stage: {}, multiplier: {}", accuracyStage, stageMultiplier);
            }
            if ((heldItem = BattleMessageSubscriber.getHeldItem(pokemonName)) != null) {
                String lowerItem = heldItem.toLowerCase();
                if (lowerItem.contains("wide_lens") || lowerItem.contains("widelens")) {
                    adjustedAccuracy *= 1.099853515625;
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Wide Lens detected! Accuracy boosted by ~10%", new Object[0]);
                } else if (lowerItem.contains("zoom_lens") || lowerItem.contains("zoomlens")) {
                    adjustedAccuracy *= 1.199951171875;
                    CobblemonBattleInfoClient.debug("[MoveTileMixin] Zoom Lens detected! Accuracy boosted by ~20%", new Object[0]);
                }
            }
            if (adjustedAccuracy > 100.0) {
                adjustedAccuracy = 100.0;
            }
            CobblemonBattleInfoClient.debug("[MoveTileMixin] Base accuracy: {}%, Adjusted accuracy: {}%", baseAccuracy, adjustedAccuracy);
        }
        catch (Exception e) {
            LOGGER.error("[MoveTileMixin] Error calculating adjusted accuracy", (Throwable)e);
        }
        return adjustedAccuracy;
    }

    private String getAbilityNameForAccuracy(ClientBattlePokemon battlePokemon) {
        return null;
    }

    private String extractAbilityName(Object ability) {
        String result;
        block23: {
            block22: {
                if (ability == null) {
                    return null;
                }
                try {
                    Method getDisplayName = ability.getClass().getMethod("getDisplayName", new Class[0]);
                    Object displayName = getDisplayName.invoke(ability, new Object[0]);
                    if (displayName == null) break block22;
                    try {
                        Method getString = displayName.getClass().getMethod("getString", new Class[0]);
                        Object str = getString.invoke(displayName, new Object[0]);
                        if (str != null && !str.toString().isEmpty()) {
                            return str.toString();
                        }
                    }
                    catch (Exception e) {
                        String result2 = displayName.toString();
                        if (result2 != null && !result2.isEmpty()) {
                            return result2;
                        }
                    }
                }
                catch (Exception getDisplayName) {
                    // empty catch block
                }
            }
            try {
                Method getNameMethod = ability.getClass().getMethod("getName", new Class[0]);
                Object name = getNameMethod.invoke(ability, new Object[0]);
                if (name != null && !name.toString().isEmpty()) {
                    return name.toString();
                }
            }
            catch (Exception getNameMethod) {
                // empty catch block
            }
            try {
                Object template;
                block24: {
                    Method getTemplate = ability.getClass().getMethod("getTemplate", new Class[0]);
                    template = getTemplate.invoke(ability, new Object[0]);
                    if (template == null) break block23;
                    try {
                        Method getDisplayName = template.getClass().getMethod("getDisplayName", new Class[0]);
                        Object displayName = getDisplayName.invoke(template, new Object[0]);
                        if (displayName == null) break block24;
                        try {
                            Method getString = displayName.getClass().getMethod("getString", new Class[0]);
                            Object str = getString.invoke(displayName, new Object[0]);
                            if (str != null && !str.toString().isEmpty()) {
                                return str.toString();
                            }
                        }
                        catch (Exception e) {
                            String result3 = displayName.toString();
                            if (result3 != null && !result3.isEmpty()) {
                                return result3;
                            }
                        }
                    }
                    catch (Exception getDisplayName) {
                        // empty catch block
                    }
                }
                try {
                    Method getNameMethod = template.getClass().getMethod("getName", new Class[0]);
                    Object name = getNameMethod.invoke(template, new Object[0]);
                    if (name != null && !name.toString().isEmpty()) {
                        return name.toString();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception getTemplate) {
                // empty catch block
            }
        }
        if ((result = ability.toString()) != null && !result.isEmpty() && !result.contains("@")) {
            return result;
        }
        return null;
    }

    private Map<String, Integer> findStatsForPokemon(String searchName) {
        String keyLower;
        if (searchName == null || searchName.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Integer> stats = BattleMessageSubscriber.getStatStagesForPokemon("player", searchName);
        if (stats != null && !stats.isEmpty()) {
            return stats;
        }
        stats = BattleMessageSubscriber.getStatStagesForPokemon(searchName);
        if (stats != null && !stats.isEmpty()) {
            return stats;
        }
        Map<String, Map<String, Integer>> allStats = BattleMessageSubscriber.getAllStatStages();
        String searchLower = searchName.toLowerCase();
        for (Map.Entry<String, Map<String, Integer>> entry : allStats.entrySet()) {
            keyLower = entry.getKey().toLowerCase();
            if (!keyLower.equals(searchLower)) continue;
            return entry.getValue();
        }
        if (searchName.length() >= 3) {
            for (Map.Entry<String, Map<String, Integer>> entry : allStats.entrySet()) {
                keyLower = entry.getKey().toLowerCase();
                if (entry.getKey().length() < 3 || !keyLower.contains(searchLower) && !searchLower.contains(keyLower)) continue;
                return entry.getValue();
            }
        }
        return Collections.emptyMap();
    }
}

