/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.battlelog.EnhancedBattleLogWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Screen.class})
public abstract class BattleGUIKeyboardMixin {
    @Unique
    private static int selectedButton = 0;
    @Unique
    private static boolean wasInBattle = false;
    @Unique
    private static final int BUTTON_WIDTH = 71;
    @Unique
    private static final int BUTTON_HEIGHT = 23;

    @Inject(method={"keyPressed(III)Z", "method_25404"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        Screen self = (Screen)this;
        if (!self.getClass().getName().contains("BattleGUI")) {
            return;
        }
        if (keyCode == 265 || keyCode == 264 || keyCode == 263 || keyCode == 262 || keyCode == 258) {
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"mouseScrolled"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, CallbackInfoReturnable<Boolean> cir) {
        Screen self = (Screen)this;
        if (!self.getClass().getName().contains("BattleGUI")) {
            return;
        }
        boolean handled = EnhancedBattleLogWidget.onScrollScreen(mouseX, mouseY, scrollY);
        if (handled) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private static void navigateUp() {
        if (selectedButton == 2) {
            selectedButton = 0;
        } else if (selectedButton == 3) {
            selectedButton = 1;
        }
        CobblemonBattleInfoClient.debug("[Controller] UP -> {}", BattleGUIKeyboardMixin.getButtonName(selectedButton));
    }

    @Unique
    private static void navigateDown() {
        if (selectedButton == 0) {
            selectedButton = 2;
        } else if (selectedButton == 1) {
            selectedButton = 3;
        }
        CobblemonBattleInfoClient.debug("[Controller] DOWN -> {}", BattleGUIKeyboardMixin.getButtonName(selectedButton));
    }

    @Unique
    private static void navigateLeft() {
        if (selectedButton == 1) {
            selectedButton = 0;
        } else if (selectedButton == 3) {
            selectedButton = 2;
        }
        CobblemonBattleInfoClient.debug("[Controller] LEFT -> {}", BattleGUIKeyboardMixin.getButtonName(selectedButton));
    }

    @Unique
    private static void navigateRight() {
        if (selectedButton == 0) {
            selectedButton = 1;
        } else if (selectedButton == 2) {
            selectedButton = 3;
        }
        CobblemonBattleInfoClient.debug("[Controller] RIGHT -> {}", BattleGUIKeyboardMixin.getButtonName(selectedButton));
    }

    @Unique
    private static void moveMouseToButton(Screen gui) {
        try {
            int rootX = BattleGUIKeyboardMixin.getFieldInt(gui, "OPTION_ROOT_X", 32);
            int verticalOffset = BattleGUIKeyboardMixin.getFieldInt(gui, "OPTION_VERTICAL_OFFSET", 19);
            int horizontalSpacing = BattleGUIKeyboardMixin.getFieldInt(gui, "OPTION_HORIZONTAL_SPACING", 4);
            int verticalSpacing = BattleGUIKeyboardMixin.getFieldInt(gui, "OPTION_VERTICAL_SPACING", 4);
            int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            int row = selectedButton / 2;
            int col = selectedButton % 2;
            int x = rootX + col * (71 + horizontalSpacing) + 35;
            int y = screenHeight - verticalOffset - (1 - row) * (23 + verticalSpacing) - 11;
            gui.mouseMoved((double)x, (double)y);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private static void activateButton(Screen gui) {
        try {
            int rootX = BattleGUIKeyboardMixin.getFieldInt(gui, "OPTION_ROOT_X", 32);
            int verticalOffset = BattleGUIKeyboardMixin.getFieldInt(gui, "OPTION_VERTICAL_OFFSET", 19);
            int horizontalSpacing = BattleGUIKeyboardMixin.getFieldInt(gui, "OPTION_HORIZONTAL_SPACING", 4);
            int verticalSpacing = BattleGUIKeyboardMixin.getFieldInt(gui, "OPTION_VERTICAL_SPACING", 4);
            int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            int row = selectedButton / 2;
            int col = selectedButton % 2;
            int x = rootX + col * (71 + horizontalSpacing) + 35;
            int y = screenHeight - verticalOffset - (1 - row) * (23 + verticalSpacing) - 11;
            CobblemonBattleInfoClient.debug("[Controller] ACTIVATE {} at ({}, {})", BattleGUIKeyboardMixin.getButtonName(selectedButton), x, y);
            gui.mouseClicked((double)x, (double)y, 0);
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.error("[Controller] Failed to activate button", t);
        }
    }

    @Unique
    private static String getButtonName(int index) {
        switch (index) {
            case 0: {
                return "Fight";
            }
            case 1: {
                return "Bag";
            }
            case 2: {
                return "Switch";
            }
            case 3: {
                return "Run";
            }
        }
        return "Unknown";
    }

    @Unique
    private static int getFieldInt(Object obj, String fieldName, int defaultValue) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(obj);
            if (value instanceof Integer) {
                return (Integer)value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultValue;
    }

    @Unique
    private static boolean isControllerButtonPressed(String buttonName) {
        try {
            Class<?> inputManager = Class.forName("eu.midnightdust.midnightcontrols.client.controller.InputManager");
            Class<?> controllerButton = Class.forName("eu.midnightdust.midnightcontrols.client.enums.ControllerButton");
            Method valueOf = controllerButton.getMethod("valueOf", String.class);
            Object button = valueOf.invoke(null, buttonName);
            Method method = inputManager.getMethod("isButtonPressed", controllerButton);
            return (Boolean)method.invoke(null, button);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        try {
            CobblemonBattleInfoClient.debug("[ControllerMixin] BattleGUIKeyboardMixin loaded", new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

