/*
 * Decompiled with CFR 0.152.
 */
package name.modid.mixin;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.interpreter.instructions.InitializeInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import name.modid.CobblemonBattleInfo;
import name.modid.CobblemonBattleInfoClient;
import name.modid.net.NetworkRegistration;
import name.modid.net.ServerHolder;
import name.modid.net.payload.PokemonTeamData;
import name.modid.net.payload.TeamBallPayload;
import name.modid.net.payload.TeraTypeSyncPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InitializeInstruction.class})
public class BattleInitializeMixin {
    @Inject(method={"invoke*"}, at={@At(value="TAIL")}, remap=false)
    void invoke(PokemonBattle battle, CallbackInfo ci) {
        MinecraftServer server = ServerHolder.CURRENT_SERVER;
        if (server == null) {
            return;
        }
        HashMap<UUID, List> allActors = new HashMap<UUID, List>();
        HashMap teraTypes = new HashMap();
        battle.getActors().forEach(actor -> {
            allActors.put(actor.getUuid(), actor.getPokemonList());
            HashMap<UUID, Integer> originalIndices = new HashMap<UUID, Integer>();
            List team = actor.getPokemonList();
            for (int i = 0; i < team.size(); ++i) {
                BattlePokemon mon = (BattlePokemon)team.get(i);
                if (mon == null) continue;
                originalIndices.put(mon.getUuid(), i);
                try {
                    Method showdownIdMethod;
                    String teraTypeName;
                    Pokemon originalPokemon = mon.getOriginalPokemon();
                    Method getTeraTypeMethod = originalPokemon.getClass().getMethod("getTeraType", new Class[0]);
                    Object teraType = getTeraTypeMethod.invoke((Object)originalPokemon, new Object[0]);
                    if (teraType == null || (teraTypeName = (String)(showdownIdMethod = teraType.getClass().getMethod("showdownId", new Class[0])).invoke(teraType, new Object[0])) == null || teraTypeName.isEmpty()) continue;
                    teraTypes.put(mon.getUuid().toString(), teraTypeName);
                    CobblemonBattleInfoClient.debug("[BattleExtras SERVER] Pokemon " + String.valueOf(mon.getUuid()) + " has tera type: " + teraTypeName, new Object[0]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CobblemonBattleInfo.storeOriginalIndices(actor.getUuid(), originalIndices);
            CobblemonBattleInfoClient.debug("[BattleExtras SERVER] Found actor: " + String.valueOf(actor.getUuid()) + " type=" + actor.getClass().getSimpleName() + " pokemon=" + actor.getPokemonList().size(), new Object[0]);
        });
        allActors.forEach((uuid, battlePokemons) -> {
            ServerPlayer p = server.getPlayerList().getPlayer(uuid);
            if (p == null) {
                CobblemonBattleInfoClient.debug("[BattleExtras SERVER] Skipping UUID " + String.valueOf(uuid) + " (NPC, no player found)", new Object[0]);
                return;
            }
            CobblemonBattleInfoClient.debug("[BattleExtras SERVER] Sending data to player: " + p.getName().getString(), new Object[0]);
            allActors.forEach((actorUuid, actorPokemon) -> {
                ArrayList<PokemonTeamData> team = new ArrayList<PokemonTeamData>();
                for (int i = 0; i < actorPokemon.size(); ++i) {
                    BattlePokemon mon = (BattlePokemon)actorPokemon.get(i);
                    if (mon == null) continue;
                    Pokemon _mon = mon.getOriginalPokemon();
                    String ball_to_send = _mon.getCaughtBall().getModel2d().getPath();
                    team.add(new PokemonTeamData(i, _mon.getSpecies().toString(), _mon.getForm().toString(), ball_to_send, mon.getHealth() <= 0));
                }
                CobblemonBattleInfoClient.debug("[BattleExtras SERVER] Sending team for actor " + String.valueOf(actorUuid) + ": " + team.size() + " pokemon", new Object[0]);
                NetworkRegistration.sendToPlayer(p, new TeamBallPayload(actorUuid.toString(), team));
            });
            teraTypes.forEach((pokemonUuid, teraTypeName) -> {
                CobblemonBattleInfoClient.debug("[BattleExtras SERVER] Sending tera type to player: " + pokemonUuid + " = " + teraTypeName, new Object[0]);
                NetworkRegistration.sendToPlayer(p, new TeraTypeSyncPayload((String)pokemonUuid, (String)teraTypeName));
            });
        });
    }
}

