/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client.battlelog;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.battlelog.BattleLogEntry;
import name.modid.client.battlelog.BattleLogManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BattleLogWidget {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BattleLogWidget");
    private static final ResourceLocation FRAME_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"textures/gui/battle/battle_log.png");
    private static final ResourceLocation FRAME_EXPANDED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"textures/gui/battle/battle_log_expanded.png");
    private static final int HEADER_HEIGHT = 6;
    private static final int COLLAPSED_HEIGHT = 70;
    private static final int PADDING = 6;
    private static final int LOG_TEXT_INDENT = 4;
    private static final int BASE_LINE_HEIGHT = 11;
    private static final int RESIZE_HANDLE_SIZE = 5;
    private static final int SCROLLBAR_WIDTH = 3;
    private static final int MIN_LOG_WIDTH = 100;
    private static final int MAX_LOG_WIDTH = 400;
    private static final int MIN_LOG_HEIGHT = 50;
    private static final int MAX_LOG_HEIGHT = 400;
    private static final int SLICE_SIZE = 6;
    private static final int TEXT_DIM = BattleLogWidget.rgb(150, 160, 175);
    private static final int COLOR_MOVE = BattleLogWidget.rgb(255, 255, 255);
    private static final int COLOR_HP = BattleLogWidget.rgb(120, 195, 255);
    private static final int COLOR_HEALING = BattleLogWidget.rgb(100, 220, 100);
    private static final int COLOR_EFFECT = BattleLogWidget.rgb(255, 215, 90);
    private static final int COLOR_FIELD = BattleLogWidget.rgb(160, 255, 160);
    private static final int TURN_TEXT_COLOR = BattleLogWidget.rgb(160, 150, 130);
    private static int x = 10;
    private static int y = 10;
    private static int width = 200;
    private static int height = 100;
    private static boolean expanded = true;
    private static float fontScale = 0.8f;
    private static boolean dragging = false;
    private static boolean resizing = false;
    private static int dragOffsetX = 0;
    private static int dragOffsetY = 0;
    private static ResizeZone resizeZone = ResizeZone.NONE;
    private static float scrollOffset = 0.0f;
    private static boolean autoScroll = true;
    private static boolean scrollbarDragging = false;
    private static float scrollbarDragOffset = 0.0f;
    private static boolean visible = true;
    private static boolean wasMouseDown = false;
    private static int lastMouseX = 0;
    private static int lastMouseY = 0;

    public static void init() {
        if (BattleExtrasConfig.isBattleLogCustomPosition()) {
            int savedX = BattleExtrasConfig.getBattleLogX();
            int savedY = BattleExtrasConfig.getBattleLogY();
            if (savedX >= 0) {
                x = savedX;
            }
            if (savedY >= 0) {
                y = savedY;
            }
        }
        fontScale = BattleExtrasConfig.getBattleLogScale();
        CobblemonBattleInfoClient.debug("[BattleLogWidget] Initialized at ({}, {}) size {}x{}", x, y, width, height);
    }

    public static void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!visible || !BattleLogManager.isInBattle()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        BattleLogWidget.handleInput(mc, mouseX, mouseY);
        int currentHeight = expanded ? height : 70;
        BattleLogWidget.render9Slice(graphics, x, y, width, currentHeight, expanded);
        BattleLogWidget.enableScissor(graphics, x + 6, y + 6, width - 12, currentHeight - 6 - 6);
        if (expanded) {
            BattleLogWidget.renderLogEntries(graphics, font);
            BattleLogWidget.renderScrollbar(graphics);
        }
        BattleLogWidget.disableScissor();
        BattleLogWidget.renderToggleButton(graphics, mouseX, mouseY);
    }

    private static void render9Slice(GuiGraphics graphics, int x, int y, int width, int height, boolean expanded) {
        ResourceLocation texture = expanded ? FRAME_EXPANDED_TEXTURE : FRAME_TEXTURE;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int s = 6;
        BattleLogWidget.blit(graphics, x, y, 0, 0, s, s);
        BattleLogWidget.blit(graphics, x + width - s, y, 256 - s, 0, s, s);
        BattleLogWidget.blit(graphics, x, y + height - s, 0, 256 - s, s, s);
        BattleLogWidget.blit(graphics, x + width - s, y + height - s, 256 - s, 256 - s, s, s);
        BattleLogWidget.blitStretched(graphics, x + s, y, width - s * 2, s, s, 0, 256 - s * 2, s);
        BattleLogWidget.blitStretched(graphics, x + s, y + height - s, width - s * 2, s, s, 256 - s, 256 - s * 2, s);
        BattleLogWidget.blitStretched(graphics, x, y + s, s, height - s * 2, 0, s, s, 256 - s * 2);
        BattleLogWidget.blitStretched(graphics, x + width - s, y + s, s, height - s * 2, 256 - s, s, s, 256 - s * 2);
        BattleLogWidget.blitStretched(graphics, x + s, y + s, width - s * 2, height - s * 2, s, s, 256 - s * 2, 256 - s * 2);
    }

    private static void blit(GuiGraphics graphics, int x, int y, int u, int v, int width, int height) {
        graphics.blit(FRAME_TEXTURE, x, y, u, v, width, height);
    }

    private static void blitStretched(GuiGraphics graphics, int x, int y, int width, int height, int u, int v, int texWidth, int texHeight) {
        graphics.blit(FRAME_TEXTURE, x, y, width, height, (float)u, (float)v, texWidth, texHeight, 256, 256);
    }

    private static void renderLogEntries(GuiGraphics graphics, Font font) {
        List<BattleLogEntry> entries = BattleLogManager.getEntries();
        if (entries.isEmpty()) {
            return;
        }
        int contentWidth = (int)((float)(width - 12 - 4 - 3) / fontScale);
        int yPos = 6;
        int lineHeight = (int)(11.0f * fontScale);
        for (BattleLogEntry entry : entries) {
            List wrappedLines = font.split((FormattedText)entry.getMessage(), contentWidth);
            for (FormattedCharSequence line : wrappedLines) {
                int absoluteY = yPos - (int)scrollOffset;
                if (absoluteY > -lineHeight && absoluteY < height - 6 - 6) {
                    BattleLogWidget.renderScaledFormattedText(graphics, font, line, x + 6 + 4, y + 6 + absoluteY, fontScale);
                }
                yPos += lineHeight;
            }
        }
        if (autoScroll) {
            float maxScroll;
            int totalContentHeight = BattleLogWidget.calculateTotalContentHeight();
            int visibleHeight = height - 6 - 12;
            scrollOffset = maxScroll = (float)Math.max(0, totalContentHeight - visibleHeight);
        }
    }

    private static void renderScaledText(GuiGraphics graphics, Font font, String text, int x, int y, int color, float scale) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        graphics.drawString(font, text, 0, 0, color, false);
        poseStack.popPose();
    }

    private static void renderScaledFormattedText(GuiGraphics graphics, Font font, FormattedCharSequence text, int x, int y, float scale) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        graphics.drawString(font, text, 0, 0, 0xFFFFFF, false);
        poseStack.popPose();
    }

    private static int calculateTotalContentHeight() {
        List<BattleLogEntry> entries = BattleLogManager.getEntries();
        int contentWidth = (int)((float)(width - 12 - 4 - 3) / fontScale);
        int totalHeight = 0;
        int lineHeight = (int)(11.0f * fontScale);
        Font font = Minecraft.getInstance().font;
        for (BattleLogEntry entry : entries) {
            List wrappedLines = font.split((FormattedText)entry.getMessage(), contentWidth);
            totalHeight += wrappedLines.size() * lineHeight;
        }
        return totalHeight;
    }

    private static void renderScrollbar(GuiGraphics graphics) {
        int visibleHeight;
        int totalContentHeight = BattleLogWidget.calculateTotalContentHeight();
        if (totalContentHeight <= (visibleHeight = height - 6 - 6)) {
            return;
        }
        int trackX = x + width - 6 - 3;
        int trackY = y + 6;
        int trackHeight = visibleHeight;
        float scrollRatio = scrollOffset / (float)(totalContentHeight - visibleHeight);
        float thumbHeightRatio = (float)visibleHeight / (float)totalContentHeight;
        int thumbHeight = Math.max(20, (int)((float)trackHeight * thumbHeightRatio));
        int thumbY = trackY + (int)(scrollRatio * (float)(trackHeight - thumbHeight));
        graphics.fill(trackX, thumbY, trackX + 3, thumbY + thumbHeight, BattleLogWidget.rgb(255, 255, 255, 180));
    }

    private static void renderToggleButton(GuiGraphics graphics, int mouseX, int mouseY) {
        int buttonSize = 10;
        int buttonX = x + width - buttonSize - 4;
        int buttonY = y + (expanded ? height : 70) - buttonSize - 4;
        boolean hovered = mouseX >= buttonX && mouseX <= buttonX + buttonSize && mouseY >= buttonY && mouseY <= buttonY + buttonSize;
        int color = hovered ? BattleLogWidget.rgb(255, 255, 255) : BattleLogWidget.rgb(180, 180, 180);
        String symbol = expanded ? "\u25bc" : "\u25b2";
        graphics.drawString(Minecraft.getInstance().font, symbol, buttonX, buttonY, color, false);
    }

    private static void handleInput(Minecraft mc, int mouseX, int mouseY) {
        int currentHeight;
        long windowHandle = mc.getWindow().getWindow();
        boolean isMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
        int n = currentHeight = expanded ? height : 70;
        if (isMouseDown && !wasMouseDown) {
            BattleLogWidget.mouseClicked(mouseX, mouseY, 0);
        }
        if (!isMouseDown && wasMouseDown) {
            BattleLogWidget.mouseReleased(mouseX, mouseY, 0);
        }
        if (isMouseDown && (mouseX != lastMouseX || mouseY != lastMouseY)) {
            double deltaX = mouseX - lastMouseX;
            double deltaY = mouseY - lastMouseY;
            BattleLogWidget.mouseDragged(mouseX, mouseY, 0, deltaX, deltaY);
        }
        wasMouseDown = isMouseDown;
        lastMouseX = mouseX;
        lastMouseY = mouseY;
    }

    private static boolean mouseClicked(double mouseX, double mouseY, int button) {
        int trackX;
        int currentHeight;
        if (!visible || !BattleLogManager.isInBattle()) {
            return false;
        }
        int n = currentHeight = expanded ? height : 70;
        if (mouseX < (double)x || mouseX > (double)(x + width) || mouseY < (double)y || mouseY > (double)(y + currentHeight)) {
            return false;
        }
        int buttonSize = 10;
        int buttonX = x + width - buttonSize - 4;
        int buttonY = y + currentHeight - buttonSize - 4;
        if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + buttonSize) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonSize)) {
            expanded = !expanded;
            return true;
        }
        resizeZone = BattleLogWidget.getResizeZone((int)mouseX, (int)mouseY);
        if (resizeZone != ResizeZone.NONE) {
            resizing = true;
            dragOffsetX = (int)mouseX;
            dragOffsetY = (int)mouseY;
            return true;
        }
        if (mouseY >= (double)y && mouseY <= (double)(y + 6)) {
            dragging = true;
            dragOffsetX = (int)(mouseX - (double)x);
            dragOffsetY = (int)(mouseY - (double)y);
            return true;
        }
        if (expanded && mouseX >= (double)(trackX = x + width - 6 - 3) && mouseX <= (double)(trackX + 3)) {
            scrollbarDragging = true;
            return true;
        }
        return false;
    }

    public static boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (dragging || resizing || scrollbarDragging) {
            dragging = false;
            resizing = false;
            scrollbarDragging = false;
            resizeZone = ResizeZone.NONE;
            BattleExtrasConfig.setBattleLogPosition(x, y);
            return true;
        }
        return false;
    }

    public static boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (dragging) {
            x = (int)(mouseX - (double)dragOffsetX);
            y = (int)(mouseY - (double)dragOffsetY);
            Minecraft mc = Minecraft.getInstance();
            x = Mth.clamp((int)x, (int)0, (int)(mc.getWindow().getGuiScaledWidth() - width));
            y = Mth.clamp((int)y, (int)0, (int)(mc.getWindow().getGuiScaledHeight() - height));
            return true;
        }
        if (resizing) {
            BattleLogWidget.handleResize((int)mouseX, (int)mouseY);
            return true;
        }
        if (scrollbarDragging) {
            BattleLogWidget.handleScrollbarDrag((int)mouseY);
            autoScroll = false;
            return true;
        }
        return false;
    }

    public static boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int currentHeight;
        if (!visible || !BattleLogManager.isInBattle()) {
            return false;
        }
        int n = currentHeight = expanded ? height : 70;
        if (mouseX < (double)x || mouseX > (double)(x + width) || mouseY < (double)y || mouseY > (double)(y + currentHeight)) {
            return false;
        }
        if (GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)341) == 1 || GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)345) == 1) {
            fontScale = Mth.clamp((float)(fontScale + (float)scrollY * 0.1f), (float)0.5f, (float)2.0f);
            BattleExtrasConfig.setBattleLogScale(fontScale);
            for (BattleLogEntry entry : BattleLogManager.getEntries()) {
                entry.clearCache();
            }
            return true;
        }
        int lineHeight = (int)(11.0f * fontScale);
        scrollOffset -= (float)scrollY * (float)lineHeight * 3.0f;
        int totalContentHeight = BattleLogWidget.calculateTotalContentHeight();
        int visibleHeight = height - 6 - 6;
        float maxScroll = Math.max(0, totalContentHeight - visibleHeight);
        scrollOffset = Mth.clamp((float)scrollOffset, (float)0.0f, (float)maxScroll);
        autoScroll = false;
        return true;
    }

    private static ResizeZone getResizeZone(int mouseX, int mouseY) {
        boolean nearBottom;
        int currentHeight = expanded ? height : 70;
        boolean nearLeft = Math.abs(mouseX - x) <= 5;
        boolean nearRight = Math.abs(mouseX - (x + width)) <= 5;
        boolean nearTop = Math.abs(mouseY - y) <= 5;
        boolean bl = nearBottom = Math.abs(mouseY - (y + currentHeight)) <= 5;
        if (nearTop && nearLeft) {
            return ResizeZone.TOP_LEFT;
        }
        if (nearTop && nearRight) {
            return ResizeZone.TOP_RIGHT;
        }
        if (nearBottom && nearLeft) {
            return ResizeZone.BOTTOM_LEFT;
        }
        if (nearBottom && nearRight) {
            return ResizeZone.BOTTOM_RIGHT;
        }
        if (nearTop) {
            return ResizeZone.TOP;
        }
        if (nearBottom) {
            return ResizeZone.BOTTOM;
        }
        if (nearLeft) {
            return ResizeZone.LEFT;
        }
        if (nearRight) {
            return ResizeZone.RIGHT;
        }
        return ResizeZone.NONE;
    }

    private static void handleResize(int mouseX, int mouseY) {
        int oldX = x;
        int oldY = y;
        int oldWidth = width;
        int oldHeight = height;
        switch (resizeZone.ordinal()) {
            case 3: {
                int newLeft = mouseX;
                int deltaLeft = oldX - newLeft;
                width = Mth.clamp((int)(oldWidth + deltaLeft), (int)100, (int)400);
                x = oldX + oldWidth - width;
                break;
            }
            case 4: {
                width = Mth.clamp((int)(mouseX - x), (int)100, (int)400);
                break;
            }
            case 1: {
                int newTop = mouseY;
                int deltaTop = oldY - newTop;
                height = Mth.clamp((int)(oldHeight + deltaTop), (int)50, (int)400);
                y = oldY + oldHeight - height;
                break;
            }
            case 2: {
                height = Mth.clamp((int)(mouseY - y), (int)50, (int)400);
                break;
            }
            case 5: {
                BattleLogWidget.handleResize(mouseX, oldY + oldHeight);
                BattleLogWidget.handleResize(oldX + oldWidth, mouseY);
                break;
            }
            case 6: {
                BattleLogWidget.handleResize(mouseX, oldY + oldHeight);
                BattleLogWidget.handleResize(oldX, mouseY);
                break;
            }
            case 7: {
                BattleLogWidget.handleResize(mouseX, mouseY);
                break;
            }
            case 8: {
                BattleLogWidget.handleResize(mouseX, mouseY);
            }
        }
    }

    private static void handleScrollbarDrag(int mouseY) {
        int visibleHeight = height - 6 - 6;
        int trackY = y + 6;
        int trackHeight = visibleHeight;
        int totalContentHeight = BattleLogWidget.calculateTotalContentHeight();
        float maxScroll = Math.max(0, totalContentHeight - visibleHeight);
        float thumbHeightRatio = (float)visibleHeight / (float)totalContentHeight;
        int thumbHeight = Math.max(20, (int)((float)trackHeight * thumbHeightRatio));
        int relativeY = mouseY - trackY;
        float scrollRatio = (float)relativeY / (float)(trackHeight - thumbHeight);
        scrollOffset = Mth.clamp((float)(scrollRatio * maxScroll), (float)0.0f, (float)maxScroll);
    }

    private static void enableScissor(GuiGraphics graphics, int x, int y, int width, int height) {
        Minecraft mc = Minecraft.getInstance();
        double scale = mc.getWindow().getGuiScale();
        int scissorX = (int)((double)x * scale);
        int scissorY = (int)((double)mc.getWindow().getHeight() - (double)(y + height) * scale);
        int scissorWidth = (int)((double)width * scale);
        int scissorHeight = (int)((double)height * scale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
    }

    private static void disableScissor() {
        RenderSystem.disableScissor();
    }

    private static int getColorForType(BattleLogEntry.EntryType type) {
        return switch (type) {
            case BattleLogEntry.EntryType.TURN -> TURN_TEXT_COLOR;
            case BattleLogEntry.EntryType.MOVE -> COLOR_MOVE;
            case BattleLogEntry.EntryType.HP -> COLOR_HP;
            case BattleLogEntry.EntryType.HEALING -> COLOR_HEALING;
            case BattleLogEntry.EntryType.EFFECT -> COLOR_EFFECT;
            case BattleLogEntry.EntryType.FIELD -> COLOR_FIELD;
            default -> TEXT_DIM;
        };
    }

    private static int rgb(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int rgb(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void toggleVisibility() {
        visible = !visible;
    }

    public static boolean isVisible() {
        return visible;
    }

    static enum ResizeZone {
        NONE,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

