/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client.battlelog;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleMessageColorizer;
import name.modid.client.battlelog.BattleLogEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BattleLogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BattleLogManager");
    private static final int MAX_ENTRIES = 500;
    private static final String TURN_KEY = "cobblemon.battle.turn";
    private static final Pattern TURN_PATTERN = Pattern.compile("Turn\\s+(\\d+)", 2);
    private static final List<BattleLogEntry> entries = new CopyOnWriteArrayList<BattleLogEntry>();
    private static int currentTurn = 0;
    private static boolean inBattle = false;

    public static void addMessage(Component message, String translationKey) {
        Integer turnNum;
        if (!inBattle) {
            return;
        }
        String messageText = message.getString();
        if (TURN_KEY.equals(translationKey) && (turnNum = BattleLogManager.extractTurnNumber(message, translationKey)) != null) {
            currentTurn = turnNum;
            return;
        }
        Component colorizedMessage = BattleMessageColorizer.colorizeLineByParts(messageText);
        if (colorizedMessage == null) {
            LOGGER.info("[BattleLog] Colorizer returned null for: '{}', using plain text", (Object)messageText);
            colorizedMessage = message;
        }
        BattleLogEntry.EntryType type = BattleLogManager.categorizeMessage(translationKey, messageText);
        BattleLogEntry entry = new BattleLogEntry(currentTurn, type, colorizedMessage, translationKey);
        entries.add(entry);
        while (entries.size() > 500) {
            entries.remove(0);
        }
    }

    private static Integer extractTurnNumber(Component message, String translationKey) {
        String text;
        Matcher matcher;
        TranslatableContents tc;
        Object[] args;
        ComponentContents componentContents = message.getContents();
        if (componentContents instanceof TranslatableContents && (args = (tc = (TranslatableContents)componentContents).getArgs()) != null && args.length > 0) {
            Object arg = args[0];
            if (arg instanceof Number) {
                return ((Number)arg).intValue();
            }
            if (arg instanceof Component) {
                Component c = (Component)arg;
                try {
                    return Integer.parseInt(c.getString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (arg != null) {
                try {
                    return Integer.parseInt(arg.toString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((matcher = TURN_PATTERN.matcher(text = message.getString())).find()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void addTurnMarker(int turn) {
        currentTurn = turn;
        MutableComponent turnMsg = Component.literal((String)("\u2500\u2500\u2500 Turn " + turn + " \u2500\u2500\u2500"));
        BattleLogEntry entry = new BattleLogEntry(turn, BattleLogEntry.EntryType.TURN, (Component)turnMsg, "battle.turn");
        entries.add(entry);
    }

    public static void addXPMessage(Component message) {
        if (!inBattle) {
            // empty if block
        }
        BattleLogEntry entry = new BattleLogEntry(currentTurn, BattleLogEntry.EntryType.OTHER, message, "battle.xp_gained");
        entries.add(entry);
        while (entries.size() > 500) {
            entries.remove(0);
        }
    }

    public static void addHpChangeEntry(String pokemonName, float percentChange, boolean isHealing) {
        String arrow = isHealing ? "\u2191" : "\u2193";
        String sign = isHealing ? "+" : "-";
        String formattedPercent = BattleLogManager.formatPercent(Math.abs(percentChange));
        MutableComponent msg = Component.literal((String)(arrow + " " + sign + formattedPercent + "% \u2192 " + pokemonName));
        BattleLogEntry.EntryType type = isHealing ? BattleLogEntry.EntryType.HEALING : BattleLogEntry.EntryType.HP;
        BattleLogEntry entry = new BattleLogEntry(currentTurn, type, (Component)msg, "battle.hp_change");
        entries.add(entry);
    }

    private static BattleLogEntry.EntryType categorizeMessage(String translationKey, String messageText) {
        if (translationKey == null) {
            return BattleLogEntry.EntryType.OTHER;
        }
        String key = translationKey.toLowerCase();
        String text = messageText.toLowerCase();
        if (key.equals(TURN_KEY) || text.startsWith("turn ")) {
            return BattleLogEntry.EntryType.TURN;
        }
        if (key.contains("move.") || key.contains("used") || key.contains("effectiveness") || key.contains("critical") || key.contains("missed") || key.contains("failed")) {
            return BattleLogEntry.EntryType.MOVE;
        }
        if (key.contains("faint") || key.contains("damage") || key.contains("switch") || key.contains("sentout") || text.contains("fainted")) {
            return BattleLogEntry.EntryType.HP;
        }
        if (key.contains("heal") || key.contains("restore") || key.contains("drain") || text.contains("restored") || text.contains("regained")) {
            return BattleLogEntry.EntryType.HEALING;
        }
        if (key.contains("stat") || key.contains("status") || key.contains("ability") || key.contains("boost") || key.contains("lower") || key.contains("raise") || key.contains("cure") || key.contains("inflict") || key.contains("volatile")) {
            return BattleLogEntry.EntryType.EFFECT;
        }
        if (key.contains("weather") || key.contains("terrain") || key.contains("screen") || key.contains("hazard") || key.contains("trick") || key.contains("tailwind") || key.contains("rain") || key.contains("sun") || key.contains("sand") || key.contains("hail") || key.contains("snow") || key.contains("electric") || key.contains("grassy") || key.contains("misty") || key.contains("psychic")) {
            return BattleLogEntry.EntryType.FIELD;
        }
        return BattleLogEntry.EntryType.OTHER;
    }

    private static String formatPercent(float percent) {
        if (percent == (float)((int)percent)) {
            return String.valueOf((int)percent);
        }
        return String.format("%.1f", Float.valueOf(percent));
    }

    public static List<BattleLogEntry> getEntries() {
        return new ArrayList<BattleLogEntry>(entries);
    }

    public static List<BattleLogEntry> getEntriesByType(BattleLogEntry.EntryType type) {
        ArrayList<BattleLogEntry> filtered = new ArrayList<BattleLogEntry>();
        for (BattleLogEntry entry : entries) {
            if (entry.getType() != type) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    public static void onBattleStart() {
        CobblemonBattleInfoClient.debug("[BattleLogManager] Battle started", new Object[0]);
        inBattle = true;
        currentTurn = 0;
        entries.clear();
    }

    public static void onBattleEnd() {
        CobblemonBattleInfoClient.debug("[BattleLogManager] Battle ended, {} entries recorded", entries.size());
        inBattle = false;
    }

    public static void clear() {
        entries.clear();
        currentTurn = 0;
    }

    public static boolean isInBattle() {
        return inBattle;
    }

    public static int getCurrentTurn() {
        return currentTurn;
    }

    public static int getEntryCount() {
        return entries.size();
    }
}

