/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.types.ElementalType;
import java.util.HashMap;
import java.util.Map;

public class TypeChart {
    private static final Map<String, Map<String, Float>> TYPE_CHART = new HashMap<String, Map<String, Float>>();

    private static void addMatchup(String attacker, String defender, float multiplier) {
        TYPE_CHART.computeIfAbsent(attacker.toLowerCase(), k -> new HashMap()).put(defender.toLowerCase(), Float.valueOf(multiplier));
    }

    public static float getEffectiveness(MoveTemplate move, ElementalType defenderType1, ElementalType defenderType2) {
        if (move == null) {
            return 1.0f;
        }
        String moveType = move.getElementalType().getName().toLowerCase();
        float multiplier = 1.0f;
        if (defenderType1 != null) {
            multiplier *= TypeChart.getTypeMultiplier(moveType, defenderType1.getName().toLowerCase());
        }
        if (defenderType2 != null) {
            multiplier *= TypeChart.getTypeMultiplier(moveType, defenderType2.getName().toLowerCase());
        }
        return multiplier;
    }

    public static float getEffectivenessAgainstTypes(String moveType, String defenderType1, String defenderType2) {
        if (moveType == null) {
            return 1.0f;
        }
        float multiplier = 1.0f;
        if (defenderType1 != null && !defenderType1.isEmpty()) {
            multiplier *= TypeChart.getTypeMultiplier(moveType.toLowerCase(), defenderType1.toLowerCase());
        }
        if (defenderType2 != null && !defenderType2.isEmpty()) {
            multiplier *= TypeChart.getTypeMultiplier(moveType.toLowerCase(), defenderType2.toLowerCase());
        }
        return multiplier;
    }

    private static float getTypeMultiplier(String attackType, String defendType) {
        Map<String, Float> matchups = TYPE_CHART.get(attackType);
        if (matchups == null) {
            return 1.0f;
        }
        return matchups.getOrDefault(defendType, Float.valueOf(1.0f)).floatValue();
    }

    public static String getEffectivenessText(float multiplier) {
        if (multiplier == 0.0f) {
            return "No Effect";
        }
        if (multiplier == 0.25f) {
            return "x0.25 (Very Weak)";
        }
        if (multiplier == 0.5f) {
            return "x0.5 (Not Effective)";
        }
        if (multiplier == 1.0f) {
            return null;
        }
        if (multiplier == 2.0f) {
            return "x2 Super Effective!";
        }
        if (multiplier == 4.0f) {
            return "x4 Super Effective!!";
        }
        return "x" + multiplier;
    }

    static {
        TypeChart.addMatchup("normal", "rock", 0.5f);
        TypeChart.addMatchup("normal", "ghost", 0.0f);
        TypeChart.addMatchup("normal", "steel", 0.5f);
        TypeChart.addMatchup("fire", "fire", 0.5f);
        TypeChart.addMatchup("fire", "water", 0.5f);
        TypeChart.addMatchup("fire", "grass", 2.0f);
        TypeChart.addMatchup("fire", "ice", 2.0f);
        TypeChart.addMatchup("fire", "bug", 2.0f);
        TypeChart.addMatchup("fire", "rock", 0.5f);
        TypeChart.addMatchup("fire", "dragon", 0.5f);
        TypeChart.addMatchup("fire", "steel", 2.0f);
        TypeChart.addMatchup("water", "fire", 2.0f);
        TypeChart.addMatchup("water", "water", 0.5f);
        TypeChart.addMatchup("water", "grass", 0.5f);
        TypeChart.addMatchup("water", "ground", 2.0f);
        TypeChart.addMatchup("water", "rock", 2.0f);
        TypeChart.addMatchup("water", "dragon", 0.5f);
        TypeChart.addMatchup("electric", "water", 2.0f);
        TypeChart.addMatchup("electric", "electric", 0.5f);
        TypeChart.addMatchup("electric", "grass", 0.5f);
        TypeChart.addMatchup("electric", "ground", 0.0f);
        TypeChart.addMatchup("electric", "flying", 2.0f);
        TypeChart.addMatchup("electric", "dragon", 0.5f);
        TypeChart.addMatchup("grass", "fire", 0.5f);
        TypeChart.addMatchup("grass", "water", 2.0f);
        TypeChart.addMatchup("grass", "grass", 0.5f);
        TypeChart.addMatchup("grass", "poison", 0.5f);
        TypeChart.addMatchup("grass", "ground", 2.0f);
        TypeChart.addMatchup("grass", "flying", 0.5f);
        TypeChart.addMatchup("grass", "bug", 0.5f);
        TypeChart.addMatchup("grass", "rock", 2.0f);
        TypeChart.addMatchup("grass", "dragon", 0.5f);
        TypeChart.addMatchup("grass", "steel", 0.5f);
        TypeChart.addMatchup("ice", "fire", 0.5f);
        TypeChart.addMatchup("ice", "water", 0.5f);
        TypeChart.addMatchup("ice", "grass", 2.0f);
        TypeChart.addMatchup("ice", "ice", 0.5f);
        TypeChart.addMatchup("ice", "ground", 2.0f);
        TypeChart.addMatchup("ice", "flying", 2.0f);
        TypeChart.addMatchup("ice", "dragon", 2.0f);
        TypeChart.addMatchup("ice", "steel", 0.5f);
        TypeChart.addMatchup("fighting", "normal", 2.0f);
        TypeChart.addMatchup("fighting", "ice", 2.0f);
        TypeChart.addMatchup("fighting", "poison", 0.5f);
        TypeChart.addMatchup("fighting", "flying", 0.5f);
        TypeChart.addMatchup("fighting", "psychic", 0.5f);
        TypeChart.addMatchup("fighting", "bug", 0.5f);
        TypeChart.addMatchup("fighting", "rock", 2.0f);
        TypeChart.addMatchup("fighting", "ghost", 0.0f);
        TypeChart.addMatchup("fighting", "dark", 2.0f);
        TypeChart.addMatchup("fighting", "steel", 2.0f);
        TypeChart.addMatchup("fighting", "fairy", 0.5f);
        TypeChart.addMatchup("poison", "grass", 2.0f);
        TypeChart.addMatchup("poison", "poison", 0.5f);
        TypeChart.addMatchup("poison", "ground", 0.5f);
        TypeChart.addMatchup("poison", "rock", 0.5f);
        TypeChart.addMatchup("poison", "ghost", 0.5f);
        TypeChart.addMatchup("poison", "steel", 0.0f);
        TypeChart.addMatchup("poison", "fairy", 2.0f);
        TypeChart.addMatchup("ground", "fire", 2.0f);
        TypeChart.addMatchup("ground", "electric", 2.0f);
        TypeChart.addMatchup("ground", "grass", 0.5f);
        TypeChart.addMatchup("ground", "poison", 2.0f);
        TypeChart.addMatchup("ground", "flying", 0.0f);
        TypeChart.addMatchup("ground", "bug", 0.5f);
        TypeChart.addMatchup("ground", "rock", 2.0f);
        TypeChart.addMatchup("ground", "steel", 2.0f);
        TypeChart.addMatchup("flying", "electric", 0.5f);
        TypeChart.addMatchup("flying", "grass", 2.0f);
        TypeChart.addMatchup("flying", "fighting", 2.0f);
        TypeChart.addMatchup("flying", "bug", 2.0f);
        TypeChart.addMatchup("flying", "rock", 0.5f);
        TypeChart.addMatchup("flying", "steel", 0.5f);
        TypeChart.addMatchup("psychic", "fighting", 2.0f);
        TypeChart.addMatchup("psychic", "poison", 2.0f);
        TypeChart.addMatchup("psychic", "psychic", 0.5f);
        TypeChart.addMatchup("psychic", "dark", 0.0f);
        TypeChart.addMatchup("psychic", "steel", 0.5f);
        TypeChart.addMatchup("bug", "fire", 0.5f);
        TypeChart.addMatchup("bug", "grass", 2.0f);
        TypeChart.addMatchup("bug", "fighting", 0.5f);
        TypeChart.addMatchup("bug", "poison", 0.5f);
        TypeChart.addMatchup("bug", "flying", 0.5f);
        TypeChart.addMatchup("bug", "psychic", 2.0f);
        TypeChart.addMatchup("bug", "ghost", 0.5f);
        TypeChart.addMatchup("bug", "dark", 2.0f);
        TypeChart.addMatchup("bug", "steel", 0.5f);
        TypeChart.addMatchup("bug", "fairy", 0.5f);
        TypeChart.addMatchup("rock", "fire", 2.0f);
        TypeChart.addMatchup("rock", "ice", 2.0f);
        TypeChart.addMatchup("rock", "fighting", 0.5f);
        TypeChart.addMatchup("rock", "ground", 0.5f);
        TypeChart.addMatchup("rock", "flying", 2.0f);
        TypeChart.addMatchup("rock", "bug", 2.0f);
        TypeChart.addMatchup("rock", "steel", 0.5f);
        TypeChart.addMatchup("ghost", "normal", 0.0f);
        TypeChart.addMatchup("ghost", "psychic", 2.0f);
        TypeChart.addMatchup("ghost", "ghost", 2.0f);
        TypeChart.addMatchup("ghost", "dark", 0.5f);
        TypeChart.addMatchup("dragon", "dragon", 2.0f);
        TypeChart.addMatchup("dragon", "steel", 0.5f);
        TypeChart.addMatchup("dragon", "fairy", 0.0f);
        TypeChart.addMatchup("dark", "fighting", 0.5f);
        TypeChart.addMatchup("dark", "psychic", 2.0f);
        TypeChart.addMatchup("dark", "ghost", 2.0f);
        TypeChart.addMatchup("dark", "dark", 0.5f);
        TypeChart.addMatchup("dark", "fairy", 0.5f);
        TypeChart.addMatchup("steel", "fire", 0.5f);
        TypeChart.addMatchup("steel", "water", 0.5f);
        TypeChart.addMatchup("steel", "electric", 0.5f);
        TypeChart.addMatchup("steel", "ice", 2.0f);
        TypeChart.addMatchup("steel", "rock", 2.0f);
        TypeChart.addMatchup("steel", "steel", 0.5f);
        TypeChart.addMatchup("steel", "fairy", 2.0f);
        TypeChart.addMatchup("fairy", "fire", 0.5f);
        TypeChart.addMatchup("fairy", "fighting", 2.0f);
        TypeChart.addMatchup("fairy", "poison", 0.5f);
        TypeChart.addMatchup("fairy", "dragon", 2.0f);
        TypeChart.addMatchup("fairy", "dark", 2.0f);
        TypeChart.addMatchup("fairy", "steel", 0.5f);
    }
}

