/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.BattleOpacityHelper;
import name.modid.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class EntryHazardRenderer {
    private static final ResourceLocation TEXTURE_STEALTH_ROCK = ResourceLocation.parse((String)"cobblemon-battle-extras:textures/gui/stealth_rock.png");
    private static final ResourceLocation TEXTURE_SPIKES = ResourceLocation.parse((String)"cobblemon-battle-extras:textures/gui/spikes.png");
    private static final ResourceLocation TEXTURE_TOXIC_SPIKES = ResourceLocation.parse((String)"cobblemon-battle-extras:textures/gui/toxic_spikes.png");
    private static final int COLOR_STICKY_WEB = -128;
    private static final String SYMBOL_STICKY_WEB = "\u25ce";
    private static final int ICON_SIZE = 16;
    private static final int ICON_SPACING = 2;

    public static void init() {
        Services.EVENTS.registerHudRender((gui, tickDelta) -> {
            try {
                EntryHazardRenderer.render(gui);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("EntryHazardRenderer initialized", new Object[0]);
    }

    private static void render(GuiGraphics gui) {
        if (!BattleExtrasConfig.isEntryHazardsEnabled()) {
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        float opacity = BattleOpacityHelper.getBattleOpacity();
        Map<String, Integer> playerHazards = BattleMessageSubscriber.getHazardsForSide("player");
        Map<String, Integer> opponentHazards = BattleMessageSubscriber.getHazardsForSide("opponent");
        int playerX = 70;
        int playerY = 45;
        EntryHazardRenderer.renderHazards(gui, mc, playerHazards, playerX, playerY, false, opacity);
        int opponentX = screenWidth - 70;
        int opponentY = 45;
        EntryHazardRenderer.renderHazards(gui, mc, opponentHazards, opponentX, opponentY, true, opacity);
    }

    private static void renderHazards(GuiGraphics gui, Minecraft mc, Map<String, Integer> hazards, int x, int y, boolean alignRight, float opacity) {
        Integer stickyWeb;
        Integer toxicSpikes;
        Integer spikes;
        if (hazards == null || hazards.isEmpty()) {
            return;
        }
        int offsetY = 0;
        Integer stealthRock = hazards.get("Stealth Rock");
        if (stealthRock != null && stealthRock > 0) {
            int drawX = alignRight ? x - 16 : x;
            EntryHazardRenderer.renderIcon(gui, TEXTURE_STEALTH_ROCK, drawX, y + offsetY, opacity);
            offsetY += 18;
        }
        if ((spikes = hazards.get("Spikes")) != null && spikes > 0) {
            int iconCount = Math.min(spikes, 3);
            int totalWidth = iconCount * 16 + (iconCount - 1) * 2;
            int startX = alignRight ? x - totalWidth : x;
            for (int i = 0; i < iconCount; ++i) {
                int iconX = startX + i * 18;
                EntryHazardRenderer.renderIcon(gui, TEXTURE_SPIKES, iconX, y + offsetY, opacity);
            }
            offsetY += 18;
        }
        if ((toxicSpikes = hazards.get("Toxic Spikes")) != null && toxicSpikes > 0) {
            int iconCount = Math.min(toxicSpikes, 2);
            int totalWidth = iconCount * 16 + (iconCount - 1) * 2;
            int startX = alignRight ? x - totalWidth : x;
            for (int i = 0; i < iconCount; ++i) {
                int iconX = startX + i * 18;
                EntryHazardRenderer.renderIcon(gui, TEXTURE_TOXIC_SPIKES, iconX, y + offsetY, opacity);
            }
            offsetY += 18;
        }
        if ((stickyWeb = hazards.get("Sticky Web")) != null && stickyWeb > 0) {
            String text = "\u25ce Web";
            int color = BattleOpacityHelper.applyOpacity(-128, opacity);
            int drawX = alignRight ? x - mc.font.width(text) : x;
            gui.drawString(mc.font, text, drawX, y + offsetY + 4, color, true);
            offsetY += 18;
        }
    }

    private static void renderIcon(GuiGraphics gui, ResourceLocation texture, int x, int y, float opacity) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float alpha = opacity;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        gui.blit(texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

