/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.List;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.platform.Services;

public class ControllerIntegration {
    private static boolean midnightControlsPresent = false;
    private static boolean controllifyPresent = false;

    public static void init() {
        midnightControlsPresent = Services.PLATFORM.isModLoaded("midnightcontrols");
        controllifyPresent = Services.PLATFORM.isModLoaded("controllify");
        if (midnightControlsPresent) {
            CobblemonBattleInfoClient.debug("MidnightControls detected - controller support available", new Object[0]);
            ControllerIntegration.initMidnightControls();
        }
        if (controllifyPresent) {
            CobblemonBattleInfoClient.debug("Controllify detected - controller support available", new Object[0]);
            ControllerIntegration.initControllify();
        }
        if (!midnightControlsPresent && !controllifyPresent) {
            CobblemonBattleInfoClient.debug("No controller mods detected. Install MidnightControls or Controllify for controller support.", new Object[0]);
        }
    }

    private static void initMidnightControls() {
        try {
            ControllerIntegration.registerMidnightControlsCompatHandler();
            CobblemonBattleInfoClient.debug("MidnightControls compat handler registered - BattleGUI will use custom controller navigation", new Object[0]);
        }
        catch (Throwable e) {
            CobblemonBattleInfoClient.LOGGER.warn("Failed to register MidnightControls compat handler: {}", (Object)e.getMessage());
        }
    }

    private static void registerMidnightControlsCompatHandler() throws Exception {
        Class<?> compatClass = Class.forName("eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat");
        Field handlersField = compatClass.getDeclaredField("HANDLERS");
        handlersField.setAccessible(true);
        List handlers = (List)handlersField.get(null);
        Class<?> compatHandlerInterface = Class.forName("eu.midnightdust.midnightcontrols.client.compat.CompatHandler");
        Object cobblemonCompatHandler = Proxy.newProxyInstance(compatHandlerInterface.getClassLoader(), new Class[]{compatHandlerInterface}, (proxy, method, args) -> {
            Object screen;
            String methodName = method.getName();
            if (methodName.equals("requireMouseOnScreen") && args != null && args.length > 0) {
                Object screen2 = args[0];
                if (screen2 != null && screen2.getClass().getName().contains("BattleGUI") && BattleExtrasConfig.isControllerNavigationEnabled()) {
                    CobblemonBattleInfoClient.debug("MidnightControls: Requiring mouse on BattleGUI", new Object[0]);
                    return true;
                }
                return false;
            }
            if (methodName.equals("handleMenuBack") && args != null && args.length > 1 && (screen = args[1]) != null && screen.getClass().getName().contains("BattleGUI") && BattleExtrasConfig.isControllerNavigationEnabled()) {
                return false;
            }
            if (method.getReturnType() == Boolean.TYPE) {
                return false;
            }
            if (method.getReturnType() == Void.TYPE) {
                return null;
            }
            return null;
        });
        handlers.add(cobblemonCompatHandler);
        CobblemonBattleInfoClient.debug("Registered Cobblemon BattleGUI compat handler with MidnightControls", new Object[0]);
    }

    private static void initControllify() {
        try {
            Class.forName("dev.isxander.controllify.Controllify");
            CobblemonBattleInfoClient.debug("Controllify API accessible", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            CobblemonBattleInfoClient.LOGGER.warn("Controllify detected but API not accessible");
        }
    }

    public static boolean isControllerActive() {
        if (midnightControlsPresent) {
            return ControllerIntegration.checkMidnightControlsActive();
        }
        if (controllifyPresent) {
            return ControllerIntegration.checkControllifyActive();
        }
        return false;
    }

    private static boolean checkMidnightControlsActive() {
        try {
            Class<?> configClass = Class.forName("eu.midnightdust.midnightcontrols.client.MidnightControlsConfig");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean checkControllifyActive() {
        try {
            Class<?> controllifyClass = Class.forName("dev.isxander.controllify.Controllify");
            Object instance = controllifyClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
            if (instance != null) {
                Object currentController = controllifyClass.getMethod("getCurrentController", new Class[0]).invoke(instance, new Object[0]);
                return currentController != null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isMidnightControlsPresent() {
        return midnightControlsPresent;
    }

    public static boolean isControllifyPresent() {
        return controllifyPresent;
    }
}

