/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.client.CobblemonClient;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleOpacityHelper;
import name.modid.client.ServerConfigHolder;
import name.modid.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import org.lwjgl.glfw.GLFW;

public class BattleSpeedButton {
    private static final int BUTTON_WIDTH = 32;
    private static final int BUTTON_HEIGHT = 14;
    private static final int OPTION_ROOT_X = 32;
    private static final int OPTION_VERTICAL_OFFSET = 19;
    private static final int OPTION_BUTTON_WIDTH = 71;
    private static final int OPTION_BUTTON_HEIGHT = 23;
    private static final int OPTION_VERTICAL_SPACING = 4;
    private static int buttonX = 0;
    private static int buttonY = 0;
    private static boolean isHovered = false;
    private static boolean wasMouseDown = false;

    public static void init() {
        Services.EVENTS.registerHudRender((graphics, tickDelta) -> {
            try {
                BattleSpeedButton.render(graphics);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        CobblemonBattleInfoClient.debug("Battle speed button renderer initialized", new Object[0]);
    }

    private static void render(GuiGraphics graphics) {
        if (CobblemonClient.INSTANCE.getBattle() == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.player == null) {
            return;
        }
        if (mc.screen == null || !mc.screen.getClass().getName().contains("BattleGUI")) {
            return;
        }
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        double mouseXd = mc.mouseHandler.xpos() * (double)screenWidth / (double)mc.getWindow().getWidth();
        double mouseYd = mc.mouseHandler.ypos() * (double)screenHeight / (double)mc.getWindow().getHeight();
        int mouseX = (int)mouseXd;
        int mouseY = (int)mouseYd;
        int fightButtonY = screenHeight - 19 - 54;
        buttonX = -6;
        buttonY = fightButtonY - 14 - 20;
        isHovered = mouseX >= buttonX && mouseX <= buttonX + 32 && mouseY >= buttonY && mouseY <= buttonY + 14;
        BattleSpeedButton.handleInput(mc, mouseX, mouseY);
        float opacity = BattleOpacityHelper.getBattleOpacity();
        int bgColor = isHovered ? -869059789 : -1440603614;
        bgColor = BattleOpacityHelper.applyOpacity(bgColor, opacity);
        graphics.fill(buttonX, buttonY, buttonX + 32, buttonY + 14, bgColor);
        int borderColor = isHovered ? -1 : -7829368;
        borderColor = BattleOpacityHelper.applyOpacity(borderColor, opacity);
        graphics.fill(buttonX, buttonY, buttonX + 32, buttonY + 1, borderColor);
        graphics.fill(buttonX, buttonY + 14 - 1, buttonX + 32, buttonY + 14, borderColor);
        graphics.fill(buttonX, buttonY, buttonX + 1, buttonY + 14, borderColor);
        graphics.fill(buttonX + 32 - 1, buttonY, buttonX + 32, buttonY + 14, borderColor);
        float speed = BattleExtrasConfig.getBattleAnimationSpeed();
        String speedText = BattleSpeedButton.getSpeedText(speed);
        Font font = mc.font;
        int textWidth = font.width(speedText);
        int textX = buttonX + (32 - textWidth) / 2;
        int textY = buttonY + 3;
        int textColor = BattleSpeedButton.getSpeedColor(speed);
        textColor = BattleOpacityHelper.applyOpacity(textColor, opacity);
        graphics.drawString(font, speedText, textX, textY, textColor, false);
        if (isHovered) {
            BattleSpeedButton.renderTooltip(graphics, font, mouseX, mouseY);
        }
    }

    private static void renderTooltip(GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        float serverSpeed = ServerConfigHolder.getBattleSpeedMultiplier();
        String serverSpeedText = BattleSpeedButton.getSpeedText(serverSpeed);
        String line1 = "Animation Speed (client-side)";
        String line2 = "Server Battle Speed: " + serverSpeedText;
        int tooltipWidth = Math.max(font.width(line1), font.width(line2)) + 8;
        int tooltipHeight = 24;
        int tooltipX = buttonX + 32 + 4;
        int tooltipY = buttonY - tooltipHeight / 2 + 7;
        if (tooltipX + tooltipWidth > graphics.guiWidth()) {
            tooltipX = buttonX;
            tooltipY = buttonY - tooltipHeight - 4;
        }
        if (tooltipX < 0) {
            tooltipX = 4;
        }
        if (tooltipY < 0) {
            tooltipY = buttonY + 14 + 4;
        }
        graphics.fill(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -267386864);
        graphics.fill(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + 1, -11513776);
        graphics.fill(tooltipX, tooltipY + tooltipHeight - 1, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -11513776);
        graphics.fill(tooltipX, tooltipY, tooltipX + 1, tooltipY + tooltipHeight, -11513776);
        graphics.fill(tooltipX + tooltipWidth - 1, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -11513776);
        graphics.drawString(font, line1, tooltipX + 4, tooltipY + 4, -5592406, false);
        graphics.drawString(font, line2, tooltipX + 4, tooltipY + 14, -171, false);
    }

    private static void handleInput(Minecraft mc, int mouseX, int mouseY) {
        boolean isMouseDown;
        long windowHandle = mc.getWindow().getWindow();
        boolean bl = isMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
        if (isMouseDown && !wasMouseDown && isHovered) {
            BattleSpeedButton.onClick();
        }
        wasMouseDown = isMouseDown;
    }

    private static void onClick() {
        BattleSpeedButton.cycleSpeed();
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        CobblemonBattleInfoClient.debug("Battle speed changed to {}x", Float.valueOf(BattleExtrasConfig.getBattleAnimationSpeed()));
    }

    private static void cycleSpeed() {
        float currentSpeed = BattleExtrasConfig.getBattleAnimationSpeed();
        float newSpeed = currentSpeed < 1.5f ? 2.0f : (currentSpeed < 2.5f ? 3.0f : (currentSpeed < 3.5f ? 4.0f : 1.0f));
        BattleExtrasConfig.get().battleAnimationSpeed = newSpeed;
        BattleExtrasConfig.save();
    }

    private static String getSpeedText(float speed) {
        if (speed < 1.5f) {
            return "1x";
        }
        if (speed < 2.5f) {
            return "2x";
        }
        if (speed < 3.5f) {
            return "3x";
        }
        return "4x";
    }

    private static int getSpeedColor(float speed) {
        if (speed < 1.5f) {
            return -1;
        }
        if (speed < 2.5f) {
            return -11141291;
        }
        if (speed < 3.5f) {
            return -171;
        }
        return -43691;
    }
}

