/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import name.modid.CobblemonBattleInfoClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class BattleOpacityHelper {
    private static Field opacityField = null;
    private static Method getOpacityMethod = null;
    private static boolean initialized = false;
    private static boolean reflectionFailed = false;
    private static Class<?> battleGUIClass = null;
    private static Object lastBattleGUI = null;
    private static final String BATTLE_GUI_CLASS = "com.cobblemon.mod.common.client.gui.battle.BattleGUI";
    private static float capturedOpacity = 1.0f;
    private static long lastOpacityUpdate = 0L;

    public static void setCurrentOpacity(float opacity) {
        capturedOpacity = opacity;
        lastOpacityUpdate = System.currentTimeMillis();
    }

    public static float getBattleOpacity() {
        try {
            if (!initialized && !reflectionFailed) {
                BattleOpacityHelper.initializeReflection();
            }
            if (reflectionFailed) {
                return 1.0f;
            }
            Minecraft mc = Minecraft.getInstance();
            Screen currentScreen = mc.screen;
            if (currentScreen != null && battleGUIClass != null && battleGUIClass.isInstance(currentScreen)) {
                lastBattleGUI = currentScreen;
                float opacity = BattleOpacityHelper.getOpacityFromObject(currentScreen);
                return opacity;
            }
            if (lastBattleGUI != null && battleGUIClass.isInstance(lastBattleGUI)) {
                float opacity = BattleOpacityHelper.getOpacityFromObject(lastBattleGUI);
                return opacity;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1.0f;
    }

    private static float getOpacityFromObject(Object obj) {
        try {
            Object value;
            Object result;
            if (getOpacityMethod != null && (result = getOpacityMethod.invoke(obj, new Object[0])) instanceof Number) {
                float opacity = ((Number)result).floatValue();
                return opacity;
            }
            if (opacityField != null && (value = opacityField.get(obj)) instanceof Number) {
                float opacity = ((Number)value).floatValue();
                return opacity;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1.0f;
    }

    private static void initializeReflection() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            battleGUIClass = Class.forName(BATTLE_GUI_CLASS);
            CobblemonBattleInfoClient.debug("[BattleOpacity] Found BattleGUI class", new Object[0]);
            try {
                getOpacityMethod = battleGUIClass.getMethod("getOpacity", new Class[0]);
                getOpacityMethod.setAccessible(true);
                CobblemonBattleInfoClient.debug("[BattleOpacity] Found getOpacity() method", new Object[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    getOpacityMethod = battleGUIClass.getDeclaredMethod("getOpacity", new Class[0]);
                    getOpacityMethod.setAccessible(true);
                    CobblemonBattleInfoClient.debug("[BattleOpacity] Found declared getOpacity() method", new Object[0]);
                }
                catch (NoSuchMethodException e2) {
                    CobblemonBattleInfoClient.debug("[BattleOpacity] getOpacity() method not found", new Object[0]);
                }
            }
            try {
                opacityField = battleGUIClass.getDeclaredField("opacity");
                opacityField.setAccessible(true);
                CobblemonBattleInfoClient.debug("[BattleOpacity] Found opacity field", new Object[0]);
            }
            catch (NoSuchFieldException e) {
                for (Field field : battleGUIClass.getDeclaredFields()) {
                    if (!field.getName().toLowerCase().contains("opacity")) continue;
                    field.setAccessible(true);
                    opacityField = field;
                    CobblemonBattleInfoClient.debug("[BattleOpacity] Found opacity field by search: {}", field.getName());
                    break;
                }
            }
            if (getOpacityMethod == null && opacityField == null) {
                CobblemonBattleInfoClient.LOGGER.warn("[BattleOpacity] Could not find opacity getter or field");
            }
        }
        catch (ClassNotFoundException e) {
            CobblemonBattleInfoClient.LOGGER.warn("[BattleOpacity] BattleGUI class not found");
            reflectionFailed = true;
        }
        catch (Throwable t) {
            CobblemonBattleInfoClient.LOGGER.warn("[BattleOpacity] Reflection failed", t);
            reflectionFailed = true;
        }
    }

    public static int applyOpacity(int color, float opacity) {
        int alpha = color >> 24 & 0xFF;
        int newAlpha = (int)((float)alpha * opacity);
        return newAlpha << 24 | color & 0xFFFFFF;
    }

    public static int withOpacity(int color, float opacity) {
        int rgb = color & 0xFFFFFF;
        int alpha = (int)(255.0f * opacity);
        return alpha << 24 | rgb;
    }
}

