/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import java.util.ArrayList;
import java.util.List;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.ServerConfigHolder;
import name.modid.net.payload.UpdateServerConfigPayload;
import name.modid.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.lwjgl.glfw.GLFW;

public class BattleExtrasConfigScreen
extends Screen {
    private final Screen parent;
    private OptionsList optionsList;
    private static final int BUTTON_HEIGHT = 20;
    private static final int ITEM_HEIGHT = 25;
    private static final int HEADER_HEIGHT = 32;
    private static final int FOOTER_HEIGHT = 32;
    private static Object editingKeybindEntry = null;
    private static long editStartTime = 0L;

    public BattleExtrasConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"config.cobblemon-battle-extras.title"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.optionsList = new OptionsList(this, this.minecraft, this.width, this.height, 32, this.height - 32, 25);
        BattleExtrasConfig config = BattleExtrasConfig.get();
        this.optionsList.addOption("config.cobblemon-battle-extras.type_icons", "config.cobblemon-battle-extras.type_icons.tooltip", () -> config.enableTypeIcons, val -> {
            config.enableTypeIcons = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.stat_stages", "config.cobblemon-battle-extras.stat_stages.tooltip", () -> config.enableStatStages, val -> {
            config.enableStatStages = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.ability_popups", "config.cobblemon-battle-extras.ability_popups.tooltip", () -> config.enableAbilityPopups, val -> {
            config.enableAbilityPopups = val;
        });
        this.optionsList.addSecondsSliderOption("config.cobblemon-battle-extras.ability_popup_duration", "config.cobblemon-battle-extras.ability_popup_duration.tooltip", () -> config.abilityPopupDuration, val -> {
            config.abilityPopupDuration = val;
        }, 1.0f, 15.0f, 0.5f);
        this.optionsList.addOption("config.cobblemon-battle-extras.ability_popup_centered", "config.cobblemon-battle-extras.ability_popup_centered.tooltip", () -> config.abilityPopupCentered, val -> {
            config.abilityPopupCentered = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.weather_terrain", "config.cobblemon-battle-extras.weather_terrain.tooltip", () -> config.enableWeatherTerrain, val -> {
            config.enableWeatherTerrain = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.entry_hazards", "config.cobblemon-battle-extras.entry_hazards.tooltip", () -> config.enableEntryHazards, val -> {
            config.enableEntryHazards = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.screens_display", "config.cobblemon-battle-extras.screens_display.tooltip", () -> config.enableScreensDisplay, val -> {
            config.enableScreensDisplay = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.volatile_status_icons", "config.cobblemon-battle-extras.volatile_status_icons.tooltip", () -> config.enableVolatileStatusIcons, val -> {
            config.enableVolatileStatusIcons = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.move_tooltips", "config.cobblemon-battle-extras.move_tooltips.tooltip", () -> config.enableMoveTooltips, val -> {
            config.enableMoveTooltips = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.switch_tooltips", "config.cobblemon-battle-extras.switch_tooltips.tooltip", () -> config.enableSwitchTooltips, val -> {
            config.enableSwitchTooltips = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.battle_nameplates", "config.cobblemon-battle-extras.battle_nameplates.tooltip", () -> config.enableBattleNameplates, val -> {
            config.enableBattleNameplates = val;
        });
        this.optionsList.addCycleOption("config.cobblemon-battle-extras.nameplate_style", "config.cobblemon-battle-extras.nameplate_style.tooltip", () -> config.nameplateStyle, val -> {
            config.nameplateStyle = val;
        }, 3, new String[]{"config.cobblemon-battle-extras.nameplate_style.default", "config.cobblemon-battle-extras.nameplate_style.alternative", "config.cobblemon-battle-extras.nameplate_style.simplified"});
        this.optionsList.addSliderOption("config.cobblemon-battle-extras.nameplate_brightness", "config.cobblemon-battle-extras.nameplate_brightness.tooltip", () -> config.battleNameplateBrightness, val -> {
            config.battleNameplateBrightness = val;
        }, 0.0f, 1.0f, 0.1f);
        this.optionsList.addOption("config.cobblemon-battle-extras.controller_navigation", "config.cobblemon-battle-extras.controller_navigation.tooltip", () -> config.enableControllerNavigation, val -> {
            config.enableControllerNavigation = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.auto_expand_log", "config.cobblemon-battle-extras.auto_expand_log.tooltip", () -> config.enableAutoExpandLog, val -> {
            config.enableAutoExpandLog = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.instant_npc_forfeit", "config.cobblemon-battle-extras.instant_npc_forfeit.tooltip", () -> config.enableInstantNPCForfeit, val -> {
            config.enableInstantNPCForfeit = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.battle_log_chat", "config.cobblemon-battle-extras.battle_log_chat.tooltip", () -> config.enableBattleLogChatMessages, val -> {
            config.enableBattleLogChatMessages = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.instant_wild_run", "config.cobblemon-battle-extras.instant_wild_run.tooltip", () -> config.enableInstantWildRun, val -> {
            config.enableInstantWildRun = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.turn_counter", "config.cobblemon-battle-extras.turn_counter.tooltip", () -> config.enableTurnCounter, val -> {
            config.enableTurnCounter = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.pokemon_count", "config.cobblemon-battle-extras.pokemon_count.tooltip", () -> config.enablePokemonCount, val -> {
            config.enablePokemonCount = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.b_button_reenter", "config.cobblemon-battle-extras.b_button_reenter.tooltip", () -> config.enableBButtonReenterBattle, val -> {
            config.enableBButtonReenterBattle = val;
        });
        this.optionsList.addKeybindOption("config.cobblemon-battle-extras.battle_back_key", "config.cobblemon-battle-extras.battle_back_key.tooltip", () -> config.battleBackKey, val -> {
            config.battleBackKey = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.weakness_tooltip", "config.cobblemon-battle-extras.weakness_tooltip.tooltip", () -> config.enableWeaknessTooltip, val -> {
            config.enableWeaknessTooltip = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.battle_log_coloring", "config.cobblemon-battle-extras.battle_log_coloring.tooltip", () -> config.enableBattleLogColoring, val -> {
            config.enableBattleLogColoring = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.battle_log_recording", "config.cobblemon-battle-extras.battle_log_recording.tooltip", () -> config.enableBattleLogRecording, val -> {
            config.enableBattleLogRecording = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.enhanced_battle_log_style", "config.cobblemon-battle-extras.enhanced_battle_log_style.tooltip", () -> config.useEnhancedBattleLogStyle, val -> {
            config.useEnhancedBattleLogStyle = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.speed_range", "config.cobblemon-battle-extras.speed_range.tooltip", () -> config.enableSpeedRange, val -> {
            config.enableSpeedRange = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.hide_battle_tiles", "config.cobblemon-battle-extras.hide_battle_tiles.tooltip", () -> config.hideBattleTiles, val -> {
            config.hideBattleTiles = val;
        });
        this.optionsList.addOption("config.cobblemon-battle-extras.xp_gained_display", "config.cobblemon-battle-extras.xp_gained_display.tooltip", () -> config.enableXPGainedDisplay, val -> {
            config.enableXPGainedDisplay = val;
        });
        this.optionsList.addServerOption("config.cobblemon-battle-extras.hide_opponent_pokeball_types", "config.cobblemon-battle-extras.hide_opponent_pokeball_types.tooltip", () -> ServerConfigHolder.hideOpponentPokeballTypes(), val -> Services.NETWORK.sendToServer(new UpdateServerConfigPayload(val, ServerConfigHolder.getBattleSpeedMultiplier())), () -> ServerConfigHolder.canEditServerConfig());
        this.optionsList.addServerCycleOption("config.cobblemon-battle-extras.battle_speed_multiplier", "config.cobblemon-battle-extras.battle_speed_multiplier.tooltip", () -> {
            float speed = ServerConfigHolder.getBattleSpeedMultiplier();
            if (speed < 1.5f) {
                return 0;
            }
            if (speed < 2.5f) {
                return 1;
            }
            if (speed < 3.5f) {
                return 2;
            }
            return 3;
        }, val -> {
            float newSpeed = val == 0 ? 1.0f : (val == 1 ? 2.0f : (val == 2 ? 3.0f : 4.0f));
            Services.NETWORK.sendToServer(new UpdateServerConfigPayload(ServerConfigHolder.hideOpponentPokeballTypes(), newSpeed));
        }, 4, new String[]{"1x", "2x", "3x", "4x"}, () -> ServerConfigHolder.canEditServerConfig());
        this.addWidget((GuiEventListener)this.optionsList);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            BattleExtrasConfig.save();
            this.minecraft.setScreen(this.parent);
        }).bounds(this.width / 2 - 100, this.height - 27, 200, 20).build());
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(0, 0, this.width, this.height, -804253680);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.optionsList.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
        this.optionsList.renderTooltip(graphics, this.font, mouseX, mouseY);
        if (editingKeybindEntry != null) {
            graphics.drawCenteredString(this.font, "Press any key...", this.width / 2, this.height - 48, 0xFFFF00);
            if (System.currentTimeMillis() - editStartTime > 5000L) {
                editingKeybindEntry = null;
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (editingKeybindEntry != null) {
            if (keyCode == 256) {
                editingKeybindEntry = null;
                return true;
            }
            if (editingKeybindEntry instanceof KeybindSetter) {
                ((KeybindSetter)editingKeybindEntry).setKey(keyCode);
            }
            editingKeybindEntry = null;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    static void startEditingKeybind(Object entry) {
        editingKeybindEntry = entry;
        editStartTime = System.currentTimeMillis();
    }

    static boolean isEditingKeybind(Object entry) {
        return editingKeybindEntry == entry;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.optionsList.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.optionsList.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.optionsList.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.optionsList.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void onClose() {
        BattleExtrasConfig.save();
        this.minecraft.setScreen(this.parent);
    }

    private class OptionsList
    extends ContainerObjectSelectionList<OptionEntry> {
        private final List<OptionEntry> entries = new ArrayList<OptionEntry>();

        public OptionsList(BattleExtrasConfigScreen battleExtrasConfigScreen, Minecraft mc, int width, int height, int top, int bottom, int itemHeight) {
            super(mc, width, bottom - top, top, itemHeight);
        }

        public void addOption(String name, String tooltip, BooleanSupplier getter, BooleanConsumer setter) {
            OptionEntry entry = new OptionEntry(this, name, tooltip, getter, setter);
            this.entries.add(entry);
            this.addEntry((AbstractSelectionList.Entry)entry);
        }

        public void addCycleOption(String name, String tooltip, IntSupplier getter, IntConsumer setter, int maxValues, String[] valueNames) {
            CycleOptionEntry entry = new CycleOptionEntry(this, name, tooltip, getter, setter, maxValues, valueNames);
            this.entries.add(entry);
            this.addEntry((AbstractSelectionList.Entry)entry);
        }

        public void addSliderOption(String name, String tooltip, FloatSupplier getter, FloatConsumer setter, float min, float max, float step) {
            SliderOptionEntry entry = new SliderOptionEntry(this, name, tooltip, getter, setter, min, max, step);
            this.entries.add(entry);
            this.addEntry((AbstractSelectionList.Entry)entry);
        }

        public void addSecondsSliderOption(String name, String tooltip, FloatSupplier getter, FloatConsumer setter, float min, float max, float step) {
            SecondsSliderOptionEntry entry = new SecondsSliderOptionEntry(this, name, tooltip, getter, setter, min, max, step);
            this.entries.add(entry);
            this.addEntry((AbstractSelectionList.Entry)entry);
        }

        public void addIntSliderOption(String name, String tooltip, IntSupplier getter, IntConsumer setter, int min, int max, int step) {
            IntSliderOptionEntry entry = new IntSliderOptionEntry(this, name, tooltip, getter, setter, min, max, step);
            this.entries.add(entry);
            this.addEntry((AbstractSelectionList.Entry)entry);
        }

        public void addServerOption(String name, String tooltip, BooleanSupplier getter, BooleanConsumer setter, BooleanSupplier canEdit) {
            ServerOptionEntry entry = new ServerOptionEntry(this, name, tooltip, getter, setter, canEdit);
            this.entries.add(entry);
            this.addEntry((AbstractSelectionList.Entry)entry);
        }

        public void addServerCycleOption(String name, String tooltip, IntSupplier getter, IntConsumer setter, int maxValues, String[] valueNames, BooleanSupplier canEdit) {
            ServerCycleOptionEntry entry = new ServerCycleOptionEntry(this, name, tooltip, getter, setter, maxValues, valueNames, canEdit);
            this.entries.add(entry);
            this.addEntry((AbstractSelectionList.Entry)entry);
        }

        public void addKeybindOption(String name, String tooltip, IntSupplier getter, IntConsumer setter) {
            KeybindOptionEntry entry = new KeybindOptionEntry(this, name, tooltip, getter, setter);
            this.entries.add(entry);
            this.addEntry((AbstractSelectionList.Entry)entry);
        }

        public int getRowWidth() {
            return Math.min(310, this.width - 40);
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + this.getRowWidth() / 2 + 4;
        }

        public void renderTooltip(GuiGraphics graphics, Font font, int mouseX, int mouseY) {
            for (OptionEntry entry : this.entries) {
                if (entry.button == null || !entry.button.isHovered()) continue;
                graphics.renderTooltip(font, (Component)Component.translatable((String)entry.tooltip), mouseX, mouseY);
                break;
            }
        }

        private class OptionEntry
        extends ContainerObjectSelectionList.Entry<OptionEntry> {
            protected final String name;
            protected final String tooltip;
            private final BooleanSupplier getter;
            private final BooleanConsumer setter;
            protected Button button;

            public OptionEntry(OptionsList optionsList, String name, String tooltip, BooleanSupplier getter, BooleanConsumer setter) {
                this.name = name;
                this.tooltip = tooltip;
                this.getter = getter;
                this.setter = setter;
            }

            private Component getButtonText() {
                boolean enabled = this.getter.get();
                MutableComponent status = enabled ? Component.translatable((String)"config.cobblemon-battle-extras.option.on") : Component.translatable((String)"config.cobblemon-battle-extras.option.off");
                return Component.translatable((String)this.name).append(": ").append((Component)status);
            }

            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                if (this.button == null) {
                    this.button = Button.builder((Component)this.getButtonText(), btn -> {
                        boolean newValue = !this.getter.get();
                        this.setter.accept(newValue);
                        btn.setMessage(this.getButtonText());
                    }).bounds(left, top, width, 20).build();
                } else {
                    this.button.setX(left);
                    this.button.setY(top);
                    this.button.setWidth(width);
                }
                this.button.render(graphics, mouseX, mouseY, partialTick);
            }

            public List<? extends GuiEventListener> children() {
                return this.button != null ? List.of(this.button) : List.of();
            }

            public List<? extends NarratableEntry> narratables() {
                return this.button != null ? List.of(this.button) : List.of();
            }

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                if (this.button != null && this.button.isMouseOver(mouseX, mouseY)) {
                    return this.button.mouseClicked(mouseX, mouseY, mouseButton);
                }
                return false;
            }
        }

        private class CycleOptionEntry
        extends OptionEntry {
            private final IntSupplier intGetter;
            private final IntConsumer intSetter;
            private final int maxValues;
            private final String[] valueNames;

            public CycleOptionEntry(OptionsList optionsList, String name, String tooltip, IntSupplier getter, IntConsumer setter, int maxValues, String[] valueNames) {
                super(optionsList, name, tooltip, null, null);
                this.intGetter = getter;
                this.intSetter = setter;
                this.maxValues = maxValues;
                this.valueNames = valueNames;
            }

            private Component getCycleButtonText() {
                int value = this.intGetter.get();
                String valueName = value >= 0 && value < this.valueNames.length ? this.valueNames[value] : "Unknown";
                return Component.translatable((String)this.name).append(": ").append((Component)Component.translatable((String)valueName));
            }

            @Override
            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                if (this.button == null) {
                    this.button = Button.builder((Component)this.getCycleButtonText(), btn -> {
                        int newValue = (this.intGetter.get() + 1) % this.maxValues;
                        this.intSetter.accept(newValue);
                        btn.setMessage(this.getCycleButtonText());
                    }).bounds(left, top, width, 20).build();
                } else {
                    this.button.setX(left);
                    this.button.setY(top);
                    this.button.setWidth(width);
                }
                this.button.render(graphics, mouseX, mouseY, partialTick);
            }
        }

        private class SliderOptionEntry
        extends OptionEntry {
            private final FloatSupplier floatGetter;
            private final FloatConsumer floatSetter;
            private final float min;
            private final float max;
            private final float step;
            private Button minusButton;
            private Button plusButton;
            private Button valueButton;

            public SliderOptionEntry(OptionsList optionsList, String name, String tooltip, FloatSupplier getter, FloatConsumer setter, float min, float max, float step) {
                super(optionsList, name, tooltip, null, null);
                this.floatGetter = getter;
                this.floatSetter = setter;
                this.min = min;
                this.max = max;
                this.step = step;
            }

            private Component getValueText() {
                int percent = Math.round(this.floatGetter.get() * 100.0f);
                return Component.translatable((String)this.name).append(": \u00a7e" + percent + "%");
            }

            @Override
            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                int buttonWidth = 20;
                int valueWidth = width - buttonWidth * 2 - 4;
                if (this.minusButton == null) {
                    this.minusButton = Button.builder((Component)Component.literal((String)"-"), btn -> {
                        float newValue = Math.max(this.min, this.floatGetter.get() - this.step);
                        this.floatSetter.accept(newValue);
                        this.valueButton.setMessage(this.getValueText());
                    }).bounds(left, top, buttonWidth, 20).build();
                    this.valueButton = Button.builder((Component)this.getValueText(), btn -> {
                        this.floatSetter.accept(0.5f);
                        btn.setMessage(this.getValueText());
                    }).bounds(left + buttonWidth + 2, top, valueWidth, 20).build();
                    this.plusButton = Button.builder((Component)Component.literal((String)"+"), btn -> {
                        float newValue = Math.min(this.max, this.floatGetter.get() + this.step);
                        this.floatSetter.accept(newValue);
                        this.valueButton.setMessage(this.getValueText());
                    }).bounds(left + buttonWidth + valueWidth + 4, top, buttonWidth, 20).build();
                    this.button = this.valueButton;
                } else {
                    this.minusButton.setX(left);
                    this.minusButton.setY(top);
                    this.valueButton.setX(left + buttonWidth + 2);
                    this.valueButton.setY(top);
                    this.valueButton.setWidth(valueWidth);
                    this.valueButton.setMessage(this.getValueText());
                    this.plusButton.setX(left + buttonWidth + valueWidth + 4);
                    this.plusButton.setY(top);
                }
                this.minusButton.render(graphics, mouseX, mouseY, partialTick);
                this.valueButton.render(graphics, mouseX, mouseY, partialTick);
                this.plusButton.render(graphics, mouseX, mouseY, partialTick);
            }

            @Override
            public List<? extends GuiEventListener> children() {
                if (this.minusButton != null && this.valueButton != null && this.plusButton != null) {
                    return List.of(this.minusButton, this.valueButton, this.plusButton);
                }
                return List.of();
            }

            @Override
            public List<? extends NarratableEntry> narratables() {
                if (this.minusButton != null && this.valueButton != null && this.plusButton != null) {
                    return List.of(this.minusButton, this.valueButton, this.plusButton);
                }
                return List.of();
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                if (this.minusButton != null && this.minusButton.isMouseOver(mouseX, mouseY)) {
                    return this.minusButton.mouseClicked(mouseX, mouseY, mouseButton);
                }
                if (this.valueButton != null && this.valueButton.isMouseOver(mouseX, mouseY)) {
                    return this.valueButton.mouseClicked(mouseX, mouseY, mouseButton);
                }
                if (this.plusButton != null && this.plusButton.isMouseOver(mouseX, mouseY)) {
                    return this.plusButton.mouseClicked(mouseX, mouseY, mouseButton);
                }
                return false;
            }
        }

        private class SecondsSliderOptionEntry
        extends OptionEntry {
            private final FloatSupplier floatGetter;
            private final FloatConsumer floatSetter;
            private final float min;
            private final float max;
            private final float step;
            private final float defaultValue;
            private Button minusButton;
            private Button plusButton;
            private Button valueButton;

            public SecondsSliderOptionEntry(OptionsList optionsList, String name, String tooltip, FloatSupplier getter, FloatConsumer setter, float min, float max, float step) {
                super(optionsList, name, tooltip, null, null);
                this.floatGetter = getter;
                this.floatSetter = setter;
                this.min = min;
                this.max = max;
                this.step = step;
                this.defaultValue = 3.0f;
            }

            private Component getValueText() {
                float value = this.floatGetter.get();
                String formatted = String.format("%.1f", Float.valueOf(value));
                return Component.translatable((String)this.name).append(": \u00a7e" + formatted + "s");
            }

            @Override
            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                int buttonWidth = 20;
                int valueWidth = width - buttonWidth * 2 - 4;
                if (this.minusButton == null) {
                    this.minusButton = Button.builder((Component)Component.literal((String)"-"), btn -> {
                        float newValue = Math.max(this.min, this.floatGetter.get() - this.step);
                        this.floatSetter.accept(newValue);
                        this.valueButton.setMessage(this.getValueText());
                    }).bounds(left, top, buttonWidth, 20).build();
                    this.valueButton = Button.builder((Component)this.getValueText(), btn -> {
                        this.floatSetter.accept(this.defaultValue);
                        btn.setMessage(this.getValueText());
                    }).bounds(left + buttonWidth + 2, top, valueWidth, 20).build();
                    this.plusButton = Button.builder((Component)Component.literal((String)"+"), btn -> {
                        float newValue = Math.min(this.max, this.floatGetter.get() + this.step);
                        this.floatSetter.accept(newValue);
                        this.valueButton.setMessage(this.getValueText());
                    }).bounds(left + buttonWidth + valueWidth + 4, top, buttonWidth, 20).build();
                    this.button = this.valueButton;
                } else {
                    this.minusButton.setX(left);
                    this.minusButton.setY(top);
                    this.valueButton.setX(left + buttonWidth + 2);
                    this.valueButton.setY(top);
                    this.valueButton.setWidth(valueWidth);
                    this.valueButton.setMessage(this.getValueText());
                    this.plusButton.setX(left + buttonWidth + valueWidth + 4);
                    this.plusButton.setY(top);
                }
                this.minusButton.render(graphics, mouseX, mouseY, partialTick);
                this.valueButton.render(graphics, mouseX, mouseY, partialTick);
                this.plusButton.render(graphics, mouseX, mouseY, partialTick);
            }

            @Override
            public List<? extends GuiEventListener> children() {
                if (this.minusButton != null && this.valueButton != null && this.plusButton != null) {
                    return List.of(this.minusButton, this.valueButton, this.plusButton);
                }
                return List.of();
            }

            @Override
            public List<? extends NarratableEntry> narratables() {
                if (this.minusButton != null && this.valueButton != null && this.plusButton != null) {
                    return List.of(this.minusButton, this.valueButton, this.plusButton);
                }
                return List.of();
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                if (this.minusButton != null && this.minusButton.isMouseOver(mouseX, mouseY)) {
                    return this.minusButton.mouseClicked(mouseX, mouseY, mouseButton);
                }
                if (this.valueButton != null && this.valueButton.isMouseOver(mouseX, mouseY)) {
                    return this.valueButton.mouseClicked(mouseX, mouseY, mouseButton);
                }
                if (this.plusButton != null && this.plusButton.isMouseOver(mouseX, mouseY)) {
                    return this.plusButton.mouseClicked(mouseX, mouseY, mouseButton);
                }
                return false;
            }
        }

        private class IntSliderOptionEntry
        extends OptionEntry {
            private final IntSupplier intGetter;
            private final IntConsumer intSetter;
            private final int min;
            private final int max;
            private final int step;
            private Button minusButton;
            private Button plusButton;
            private Button valueButton;

            public IntSliderOptionEntry(OptionsList optionsList, String name, String tooltip, IntSupplier getter, IntConsumer setter, int min, int max, int step) {
                super(optionsList, name, tooltip, null, null);
                this.intGetter = getter;
                this.intSetter = setter;
                this.min = min;
                this.max = max;
                this.step = step;
            }

            private Component getValueText() {
                int value = this.intGetter.get();
                return Component.translatable((String)this.name).append(": \u00a7e" + value);
            }

            @Override
            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                int buttonWidth = 20;
                int valueWidth = width - buttonWidth * 2 - 4;
                if (this.minusButton == null) {
                    this.minusButton = Button.builder((Component)Component.literal((String)"-"), btn -> {
                        int newValue = Math.max(this.min, this.intGetter.get() - this.step);
                        this.intSetter.accept(newValue);
                        this.valueButton.setMessage(this.getValueText());
                    }).bounds(left, top, buttonWidth, 20).build();
                    this.valueButton = Button.builder((Component)this.getValueText(), btn -> {
                        this.intSetter.accept(2);
                        btn.setMessage(this.getValueText());
                    }).bounds(left + buttonWidth + 2, top, valueWidth, 20).build();
                    this.plusButton = Button.builder((Component)Component.literal((String)"+"), btn -> {
                        int newValue = Math.min(this.max, this.intGetter.get() + this.step);
                        this.intSetter.accept(newValue);
                        this.valueButton.setMessage(this.getValueText());
                    }).bounds(left + buttonWidth + valueWidth + 4, top, buttonWidth, 20).build();
                    this.button = this.valueButton;
                } else {
                    this.minusButton.setX(left);
                    this.minusButton.setY(top);
                    this.valueButton.setX(left + buttonWidth + 2);
                    this.valueButton.setY(top);
                    this.valueButton.setWidth(valueWidth);
                    this.valueButton.setMessage(this.getValueText());
                    this.plusButton.setX(left + buttonWidth + valueWidth + 4);
                    this.plusButton.setY(top);
                }
                this.minusButton.render(graphics, mouseX, mouseY, partialTick);
                this.valueButton.render(graphics, mouseX, mouseY, partialTick);
                this.plusButton.render(graphics, mouseX, mouseY, partialTick);
            }

            @Override
            public List<? extends GuiEventListener> children() {
                if (this.minusButton != null && this.valueButton != null && this.plusButton != null) {
                    return List.of(this.minusButton, this.valueButton, this.plusButton);
                }
                return List.of();
            }

            @Override
            public List<? extends NarratableEntry> narratables() {
                if (this.minusButton != null && this.valueButton != null && this.plusButton != null) {
                    return List.of(this.minusButton, this.valueButton, this.plusButton);
                }
                return List.of();
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                if (this.minusButton != null && this.minusButton.isMouseOver(mouseX, mouseY)) {
                    return this.minusButton.mouseClicked(mouseX, mouseY, mouseButton);
                }
                if (this.valueButton != null && this.valueButton.isMouseOver(mouseX, mouseY)) {
                    return this.valueButton.mouseClicked(mouseX, mouseY, mouseButton);
                }
                if (this.plusButton != null && this.plusButton.isMouseOver(mouseX, mouseY)) {
                    return this.plusButton.mouseClicked(mouseX, mouseY, mouseButton);
                }
                return false;
            }
        }

        private class ServerOptionEntry
        extends OptionEntry {
            private final BooleanSupplier serverGetter;
            private final BooleanConsumer serverSetter;
            private final BooleanSupplier canEditSupplier;

            public ServerOptionEntry(OptionsList optionsList, String name, String tooltip, BooleanSupplier getter, BooleanConsumer setter, BooleanSupplier canEdit) {
                super(optionsList, name, tooltip, null, null);
                this.serverGetter = getter;
                this.serverSetter = setter;
                this.canEditSupplier = canEdit;
            }

            private Component getServerButtonText() {
                MutableComponent status;
                boolean enabled = this.serverGetter.get();
                boolean canEdit = this.canEditSupplier.get();
                MutableComponent mutableComponent = status = enabled ? Component.translatable((String)"config.cobblemon-battle-extras.option.on") : Component.translatable((String)"config.cobblemon-battle-extras.option.off");
                if (!canEdit) {
                    return Component.translatable((String)this.name).append(": ").append((Component)status).append(" \u00a77(Server)");
                }
                return Component.translatable((String)this.name).append(": ").append((Component)status);
            }

            @Override
            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                boolean canEdit = this.canEditSupplier.get();
                if (this.button == null) {
                    this.button = Button.builder((Component)this.getServerButtonText(), btn -> {
                        if (this.canEditSupplier.get()) {
                            boolean newValue = !this.serverGetter.get();
                            this.serverSetter.accept(newValue);
                        }
                    }).bounds(left, top, width, 20).build();
                } else {
                    this.button.setX(left);
                    this.button.setY(top);
                    this.button.setWidth(width);
                    this.button.setMessage(this.getServerButtonText());
                }
                this.button.active = canEdit;
                this.button.render(graphics, mouseX, mouseY, partialTick);
            }
        }

        private class ServerCycleOptionEntry
        extends OptionEntry {
            private final IntSupplier serverGetter;
            private final IntConsumer serverSetter;
            private final BooleanSupplier canEditSupplier;
            private final int maxValues;
            private final String[] valueNames;

            public ServerCycleOptionEntry(OptionsList optionsList, String name, String tooltip, IntSupplier getter, IntConsumer setter, int maxValues, String[] valueNames, BooleanSupplier canEdit) {
                super(optionsList, name, tooltip, null, null);
                this.serverGetter = getter;
                this.serverSetter = setter;
                this.maxValues = maxValues;
                this.valueNames = valueNames;
                this.canEditSupplier = canEdit;
            }

            private Component getServerCycleButtonText() {
                int value = this.serverGetter.get();
                String valueName = value >= 0 && value < this.valueNames.length ? this.valueNames[value] : "Unknown";
                boolean canEdit = this.canEditSupplier.get();
                if (!canEdit) {
                    return Component.translatable((String)this.name).append(": \u00a7e" + valueName + " \u00a77(Server)");
                }
                return Component.translatable((String)this.name).append(": \u00a7e" + valueName);
            }

            @Override
            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                boolean canEdit = this.canEditSupplier.get();
                if (this.button == null) {
                    this.button = Button.builder((Component)this.getServerCycleButtonText(), btn -> {
                        if (this.canEditSupplier.get()) {
                            int newValue = (this.serverGetter.get() + 1) % this.maxValues;
                            this.serverSetter.accept(newValue);
                        }
                    }).bounds(left, top, width, 20).build();
                } else {
                    this.button.setX(left);
                    this.button.setY(top);
                    this.button.setWidth(width);
                    this.button.setMessage(this.getServerCycleButtonText());
                }
                this.button.active = canEdit;
                this.button.render(graphics, mouseX, mouseY, partialTick);
            }
        }

        private class KeybindOptionEntry
        extends OptionEntry
        implements KeybindSetter {
            private final IntSupplier keyGetter;
            private final IntConsumer keySetter;

            public KeybindOptionEntry(OptionsList optionsList, String name, String tooltip, IntSupplier getter, IntConsumer setter) {
                super(optionsList, name, tooltip, null, null);
                this.keyGetter = getter;
                this.keySetter = setter;
            }

            @Override
            public void setKey(int keyCode) {
                this.keySetter.accept(keyCode);
                BattleExtrasConfig.save();
                if (this.button != null) {
                    this.button.setMessage(this.getKeybindButtonText());
                }
            }

            private Component getKeybindButtonText() {
                if (BattleExtrasConfigScreen.isEditingKeybind(this)) {
                    return Component.translatable((String)this.name).append(": \u00a7e> Press Key <");
                }
                int keyCode = this.keyGetter.get();
                String keyName = this.getKeyName(keyCode);
                return Component.translatable((String)this.name).append(": \u00a7e" + keyName);
            }

            private String getKeyName(int keyCode) {
                switch (keyCode) {
                    case 259: {
                        return "Backspace";
                    }
                    case 256: {
                        return "Escape";
                    }
                    case 257: {
                        return "Enter";
                    }
                    case 258: {
                        return "Tab";
                    }
                    case 32: {
                        return "Space";
                    }
                    case 340: {
                        return "Left Shift";
                    }
                    case 344: {
                        return "Right Shift";
                    }
                    case 341: {
                        return "Left Ctrl";
                    }
                    case 345: {
                        return "Right Ctrl";
                    }
                    case 342: {
                        return "Left Alt";
                    }
                    case 346: {
                        return "Right Alt";
                    }
                    case 261: {
                        return "Delete";
                    }
                    case 260: {
                        return "Insert";
                    }
                    case 268: {
                        return "Home";
                    }
                    case 269: {
                        return "End";
                    }
                    case 266: {
                        return "Page Up";
                    }
                    case 267: {
                        return "Page Down";
                    }
                    case 265: {
                        return "Up Arrow";
                    }
                    case 264: {
                        return "Down Arrow";
                    }
                    case 263: {
                        return "Left Arrow";
                    }
                    case 262: {
                        return "Right Arrow";
                    }
                    case 290: {
                        return "F1";
                    }
                    case 291: {
                        return "F2";
                    }
                    case 292: {
                        return "F3";
                    }
                    case 293: {
                        return "F4";
                    }
                    case 294: {
                        return "F5";
                    }
                    case 295: {
                        return "F6";
                    }
                    case 296: {
                        return "F7";
                    }
                    case 297: {
                        return "F8";
                    }
                    case 298: {
                        return "F9";
                    }
                    case 299: {
                        return "F10";
                    }
                    case 300: {
                        return "F11";
                    }
                    case 301: {
                        return "F12";
                    }
                }
                String glfwName = GLFW.glfwGetKeyName((int)keyCode, (int)0);
                if (glfwName != null && !glfwName.isEmpty()) {
                    return glfwName.toUpperCase();
                }
                return "Key " + keyCode;
            }

            @Override
            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                if (this.button == null) {
                    this.button = Button.builder((Component)this.getKeybindButtonText(), btn -> BattleExtrasConfigScreen.startEditingKeybind(this)).bounds(left, top, width, 20).build();
                } else {
                    this.button.setX(left);
                    this.button.setY(top);
                    this.button.setWidth(width);
                    this.button.setMessage(this.getKeybindButtonText());
                }
                this.button.render(graphics, mouseX, mouseY, partialTick);
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                if (this.button != null && this.button.isMouseOver(mouseX, mouseY)) {
                    if (mouseButton == 1) {
                        this.setKey(340);
                        return true;
                    }
                    return this.button.mouseClicked(mouseX, mouseY, mouseButton);
                }
                return false;
            }
        }
    }

    @FunctionalInterface
    static interface BooleanSupplier {
        public boolean get();
    }

    @FunctionalInterface
    static interface BooleanConsumer {
        public void accept(boolean var1);
    }

    @FunctionalInterface
    static interface FloatSupplier {
        public float get();
    }

    @FunctionalInterface
    static interface FloatConsumer {
        public void accept(float var1);
    }

    @FunctionalInterface
    static interface IntSupplier {
        public int get();
    }

    @FunctionalInterface
    static interface IntConsumer {
        public void accept(int var1);
    }

    static interface KeybindSetter {
        public void setKey(int var1);
    }
}

