/*
 * Decompiled with CFR 0.152.
 */
package name.modid.client;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattleActor;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import name.modid.CobblemonBattleInfoClient;
import name.modid.client.BattleExtrasConfig;
import name.modid.client.BattleMessageSubscriber;
import name.modid.client.BattleSideHelper;
import name.modid.client.TypeIconRenderer;
import name.modid.platform.Services;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;

public class BattleEntityOverlayRenderer {
    private static final ResourceLocation BATTLE_INFO_BASE = ResourceLocation.parse((String)"cobblemon:textures/gui/battle/battle_info_base.png");
    private static final ResourceLocation BATTLE_INFO_BASE_FLIPPED = ResourceLocation.parse((String)"cobblemon:textures/gui/battle/battle_info_base_flipped.png");
    private static final ResourceLocation ALTERNATIVE_BATTLE_INFO_BASE = ResourceLocation.parse((String)"cobblemon-battle-extras:textures/gui/battle_info_base_alternative.png");
    private static final ResourceLocation ALTERNATIVE_BATTLE_INFO_BASE_FLIPPED = ResourceLocation.parse((String)"cobblemon-battle-extras:textures/gui/battle_info_base_alternative_flipped.png");
    private static final ResourceLocation SIMPLIFIED_BATTLE_INFO_BASE = ResourceLocation.parse((String)"cobblemon-battle-extras:textures/gui/battle_info_healthbar.png");
    private static final ResourceLocation SIMPLIFIED_BATTLE_INFO_BASE_FLIPPED = ResourceLocation.parse((String)"cobblemon-battle-extras:textures/gui/battle_info_healthbar_flipped.png");
    private static final ResourceLocation TYPE_SPRITE_SHEET = ResourceLocation.parse((String)"cobblemon:textures/gui/types.png");
    private static final String MEGA_SHOWDOWN_TERA_PATH = "mega_showdown:textures/gui/summary/tera_types/";
    private static final int TERA_ICON_SIZE = 32;
    private static final boolean MEGA_SHOWDOWN_LOADED = Services.PLATFORM.isModLoaded("mega_showdown");
    private static final ResourceLocation MEGA_ICON = ResourceLocation.parse((String)"cobblemon-battle-extras:textures/gui/mega_icon.png");
    private static final int MEGA_ICON_SIZE = 64;
    private static final int MEGA_ICON_DISPLAY_SIZE = 6;
    private static float MEGA_ICON_OFFSET_X_PLAYER_OVERLAY = -27.0f;
    private static float MEGA_ICON_OFFSET_Y_PLAYER_OVERLAY = -16.0f;
    private static float MEGA_ICON_OFFSET_X_OPPONENT_OVERLAY = 27.0f;
    private static float MEGA_ICON_OFFSET_Y_OPPONENT_OVERLAY = -16.0f;
    private static float MEGA_ICON_OFFSET_X_PLAYER_OVERLAY_SINGLE = -12.0f;
    private static float MEGA_ICON_OFFSET_Y_PLAYER_OVERLAY_SINGLE = -17.0f;
    private static float MEGA_ICON_OFFSET_X_OPPONENT_OVERLAY_SINGLE = 98.0f;
    private static float MEGA_ICON_OFFSET_Y_OPPONENT_OVERLAY_SINGLE = -17.0f;
    private static float MEGA_ICON_OFFSET_X_PLAYER_ALT = -32.0f;
    private static float MEGA_ICON_OFFSET_Y_PLAYER_ALT = -21.0f;
    private static float MEGA_ICON_OFFSET_X_OPPONENT_ALT = -100.0f;
    private static float MEGA_ICON_OFFSET_Y_OPPONENT_ALT = -21.0f;
    private static float MEGA_ICON_OFFSET_X_OPPONENT_ALT_SINGLE = -114.0f;
    private static float MEGA_ICON_OFFSET_Y_OPPONENT_ALT_SINGLE = -21.0f;
    private static final int TEXTURE_WIDTH = 140;
    private static final int TEXTURE_HEIGHT = 40;
    private static final int TYPE_ICON_SIZE = 36;
    private static final int TYPE_SHEET_WIDTH = 648;
    private static final int TYPE_DISPLAY_SIZE = 12;
    private static final float SCALE = 0.012f;
    private static final float HEIGHT_ABOVE_BASE = 0.5f;
    private static final float HEIGHT_SCALE_MULTIPLIER = 0.15f;
    private static final int LIGHT = 0xF000F0;
    private static final float HP_BAR_X_START_PLAYER = 38.0f;
    private static final float HP_BAR_X_START_OPPONENT = 3.0f;
    private static final float HP_BAR_MAX_WIDTH_PLAYER = 99.0f;
    private static final float HP_BAR_MAX_WIDTH_OPPONENT = 99.0f;
    private static final float HP_BAR_Y = 24.0f;
    private static final float HP_BAR_HEIGHT = 4.0f;
    private static final float ALT_HP_BAR_X_START_PLAYER = 2.0f;
    private static final float ALT_HP_BAR_X_START_OPPONENT = 6.0f;
    private static final float ALT_HP_BAR_MAX_WIDTH_PLAYER = 132.0f;
    private static final float ALT_HP_BAR_MAX_WIDTH_OPPONENT = 132.0f;
    private static final float SIMPLIFIED_HP_BAR_X_START_PLAYER = 2.0f;
    private static final float SIMPLIFIED_HP_BAR_X_START_OPPONENT = 6.0f;
    private static final float SIMPLIFIED_HP_BAR_MAX_WIDTH_PLAYER = 132.0f;
    private static final float SIMPLIFIED_HP_BAR_MAX_WIDTH_OPPONENT = 132.0f;
    private static final float SIMPLIFIED_HP_BAR_Y = 24.0f;
    private static final float SIMPLIFIED_HP_BAR_HEIGHT = 4.0f;
    private static final float PORTRAIT_X = 3.0f;
    private static final float PORTRAIT_Y = 3.0f;
    private static final float PORTRAIT_SIZE = 32.0f;
    private static final float ALT_NAME_X_PLAYER = 6.0f;
    private static final float ALT_NAME_X_OPPONENT = 10.0f;
    private static final float ALT_NAME_Y = 12.0f;
    private static final float ALT_LEVEL_RIGHT_PADDING_PLAYER = 10.0f;
    private static final float ALT_LEVEL_RIGHT_PADDING_OPPONENT = 6.0f;
    private static final float ALT_GENDER_SPACING = 2.0f;
    private static final float ALT_TYPE_ICON_PADDING_X = 3.0f;
    private static final float ALT_TYPE_ICON_Y = -10.0f;

    public static void renderBattleOverlay(Entity entity, PoseStack poseStack, MultiBufferSource buffers, Camera camera, float partialTicks, double x, double y, double z) {
        if (entity == null || !entity.getClass().getName().contains("PokemonEntity")) {
            return;
        }
        if (!BattleExtrasConfig.isBattleNameplatesEnabled()) {
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            return;
        }
        try {
            boolean useAltPositioning;
            String pokemonName;
            double dz;
            double dy;
            Method getBattleIdMethod = entity.getClass().getMethod("getBattleId", new Class[0]);
            UUID pokemonBattleId = (UUID)getBattleIdMethod.invoke((Object)entity, new Object[0]);
            UUID battleId = battle.getBattleId();
            if (battleId == null || pokemonBattleId == null || !battleId.equals(pokemonBattleId)) {
                return;
            }
            Entity cameraEntity = camera.getEntity();
            if (cameraEntity == null) {
                return;
            }
            double dx = entity.getX() - cameraEntity.getX();
            double distSq = dx * dx + (dy = entity.getY() - cameraEntity.getY()) * dy + (dz = entity.getZ() - cameraEntity.getZ()) * dz;
            if (distSq > 4096.0) {
                return;
            }
            Method getPokemonMethod = entity.getClass().getMethod("getPokemon", new Class[0]);
            Object pokemonData = getPokemonMethod.invoke((Object)entity, new Object[0]);
            Method getSpeciesMethod = pokemonData.getClass().getMethod("getSpecies", new Class[0]);
            Object species = getSpeciesMethod.invoke(pokemonData, new Object[0]);
            Method getNameMethod = species.getClass().getMethod("getName", new Class[0]);
            String displayName = pokemonName = (String)getNameMethod.invoke(species, new Object[0]);
            try {
                Method getTranslatedNameMethod = species.getClass().getMethod("getTranslatedName", new Class[0]);
                Object nameComponent = getTranslatedNameMethod.invoke(species, new Object[0]);
                if (nameComponent != null) {
                    displayName = nameComponent.getClass().getMethod("getString", new Class[0]).invoke(nameComponent, new Object[0]).toString();
                }
            }
            catch (Exception getTranslatedNameMethod) {
                // empty catch block
            }
            Method getLevelMethod = pokemonData.getClass().getMethod("getLevel", new Class[0]);
            int level = (Integer)getLevelMethod.invoke(pokemonData, new Object[0]);
            Minecraft mc = Minecraft.getInstance();
            UUID playerUUID = mc.player != null ? mc.player.getUUID() : null;
            UUID entityUUID = entity.getUUID();
            UUID pokemonUUID = null;
            try {
                Method getUuidMethod = pokemonData.getClass().getMethod("getUuid", new Class[0]);
                pokemonUUID = (UUID)getUuidMethod.invoke(pokemonData, new Object[0]);
            }
            catch (Exception getUuidMethod) {
                // empty catch block
            }
            boolean isPlayerPokemon = BattleEntityOverlayRenderer.isPlayerPokemonByPokemonUUID(battle, pokemonUUID, pokemonName);
            String side = isPlayerPokemon ? "player" : "opponent";
            List<ElementalType> types = TypeIconRenderer.getDisplayTypes(pokemonData, pokemonName, side, pokemonUUID != null ? pokemonUUID.toString() : null);
            if (types == null || types.isEmpty()) {
                types = BattleEntityOverlayRenderer.getTypesFromPokemon(pokemonData);
            }
            if (types == null || types.isEmpty()) {
                types = BattleEntityOverlayRenderer.getTypesFromSpecies(species);
            }
            float healthPercent = BattleEntityOverlayRenderer.getHealthPercentFromBattle(battle, pokemonName, isPlayerPokemon);
            String gender = BattleEntityOverlayRenderer.getGenderFromBattle(battle, pokemonName, isPlayerPokemon);
            float entityHeight = (float)entity.getBoundingBox().getYsize();
            float heightOffset = 0.5f + entityHeight * 0.15f;
            poseStack.pushPose();
            poseStack.translate(x, y + (double)entityHeight + (double)heightOffset, z);
            poseStack.mulPose(camera.rotation());
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.scale(-0.012f, -0.012f, 0.012f);
            BattleEntityOverlayRenderer.renderBattleInfoPlate(poseStack, isPlayerPokemon);
            int nameplateStyle = BattleExtrasConfig.getNameplateStyle();
            boolean bl = useAltPositioning = nameplateStyle != 0;
            if (nameplateStyle == 0) {
                BattleEntityOverlayRenderer.renderPortrait(poseStack, buffers, entity, isPlayerPokemon, partialTicks, camera);
            }
            BattleEntityOverlayRenderer.renderHPBar(poseStack, healthPercent, isPlayerPokemon, nameplateStyle);
            BattleEntityOverlayRenderer.renderNameAndLevel(poseStack, buffers, mc.font, displayName, level, isPlayerPokemon, gender, nameplateStyle);
            BattleEntityOverlayRenderer.renderSpeedRange(poseStack, buffers, mc.font, species, level, isPlayerPokemon, pokemonName, nameplateStyle);
            String status = BattleEntityOverlayRenderer.getStatusFromBattle(battle, pokemonName, isPlayerPokemon);
            if (status != null) {
                BattleEntityOverlayRenderer.renderStatus(poseStack, buffers, mc.font, status, isPlayerPokemon, nameplateStyle);
            }
            BattleEntityOverlayRenderer.renderTypeIcons(poseStack, types, isPlayerPokemon, pokemonName, nameplateStyle);
            String lowerPokemonName = pokemonName != null ? pokemonName.toLowerCase() : null;
            boolean isMegaEvolved = BattleMessageSubscriber.isMegaEvolved(lowerPokemonName);
            String currentFormName = null;
            try {
                Method getFormMethod = pokemonData.getClass().getMethod("getForm", new Class[0]);
                Object form = getFormMethod.invoke(pokemonData, new Object[0]);
                if (form != null) {
                    Method formNameMethod = form.getClass().getMethod("getName", new Class[0]);
                    currentFormName = (String)formNameMethod.invoke(form, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isMegaEvolved && currentFormName != null && currentFormName.toLowerCase().contains("mega")) {
                isMegaEvolved = true;
            }
            if (isMegaEvolved && types != null && !types.isEmpty()) {
                BattleEntityOverlayRenderer.renderMegaIcon(poseStack, isPlayerPokemon, types.size(), useAltPositioning);
            }
            poseStack.popPose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderBattleInfoPlate(PoseStack poseStack, boolean isPlayer) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float alpha = BattleExtrasConfig.getBattleNameplateOpacity();
        float brightness = BattleExtrasConfig.getBattleNameplateBrightness();
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        int nameplateStyle = BattleExtrasConfig.getNameplateStyle();
        ResourceLocation plateTexture = nameplateStyle == 2 ? (isPlayer ? SIMPLIFIED_BATTLE_INFO_BASE : SIMPLIFIED_BATTLE_INFO_BASE_FLIPPED) : (nameplateStyle == 1 ? (isPlayer ? ALTERNATIVE_BATTLE_INFO_BASE : ALTERNATIVE_BATTLE_INFO_BASE_FLIPPED) : (isPlayer ? BATTLE_INFO_BASE : BATTLE_INFO_BASE_FLIPPED));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)plateTexture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = poseStack.last().pose();
        float halfWidth = 70.0f;
        float halfHeight = 20.0f;
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, -halfWidth, -halfHeight, 0.0f).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, -halfWidth, halfHeight, 0.0f).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, halfWidth, halfHeight, 0.0f).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, halfWidth, -halfHeight, 0.0f).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    private static void renderPortrait(PoseStack poseStack, MultiBufferSource buffers, Entity entity, boolean isPlayer, float partialTicks, Camera camera) {
        LivingEntity living;
        Minecraft mc = Minecraft.getInstance();
        float portCenterX = isPlayer ? -51.0f : 51.0f;
        float portCenterY = -1.0f;
        float entityHeight = (float)entity.getBoundingBox().getYsize();
        float entityWidth = (float)entity.getBoundingBox().getXsize();
        float maxDimension = Math.max(entityHeight, entityWidth);
        float scale = 16.8f / maxDimension;
        float savedYRot = entity.getYRot();
        float savedYRotO = entity.yRotO;
        float savedXRot = entity.getXRot();
        float savedXRotO = entity.xRotO;
        float savedYHeadRot = 0.0f;
        float savedYHeadRotO = 0.0f;
        float savedYBodyRot = 0.0f;
        float savedYBodyRotO = 0.0f;
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            savedYHeadRot = living.yHeadRot;
            savedYHeadRotO = living.yHeadRotO;
            savedYBodyRot = living.yBodyRot;
            savedYBodyRotO = living.yBodyRotO;
        }
        entity.setYRot(0.0f);
        entity.yRotO = 0.0f;
        entity.setXRot(0.0f);
        entity.xRotO = 0.0f;
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            living.yHeadRot = 0.0f;
            living.yHeadRotO = 0.0f;
            living.yBodyRot = 0.0f;
            living.yBodyRotO = 0.0f;
        }
        poseStack.pushPose();
        poseStack.translate(portCenterX, portCenterY + 9.6f, 0.01f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.scale(scale, scale, scale);
        try {
            EntityRenderDispatcher dispatcher = mc.getEntityRenderDispatcher();
            dispatcher.setRenderShadow(false);
            dispatcher.render(entity, 0.0, 0.0, 0.0, 180.0f, 0.0f, poseStack, buffers, 0xF000F0);
            dispatcher.setRenderShadow(true);
        }
        catch (Exception dispatcher) {
            // empty catch block
        }
        poseStack.popPose();
        entity.setYRot(savedYRot);
        entity.yRotO = savedYRotO;
        entity.setXRot(savedXRot);
        entity.xRotO = savedXRotO;
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            living.yHeadRot = savedYHeadRot;
            living.yHeadRotO = savedYHeadRotO;
            living.yBodyRot = savedYBodyRot;
            living.yBodyRotO = savedYBodyRotO;
        }
    }

    private static void renderHPBar(PoseStack poseStack, float healthPercent, boolean isPlayer, int nameplateStyle) {
        int b;
        int g;
        int r;
        float barRight;
        float barTop;
        float barLeft;
        float hpBarY;
        float maxWidthOpponent;
        float maxWidthPlayer;
        float xStartOpponent;
        float xStartPlayer;
        healthPercent = Math.max(0.0f, Math.min(1.0f, healthPercent));
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = poseStack.last().pose();
        float hpBarHeight = 4.0f;
        if (nameplateStyle == 2) {
            xStartPlayer = 2.0f;
            xStartOpponent = 6.0f;
            maxWidthPlayer = 132.0f;
            maxWidthOpponent = 132.0f;
            hpBarY = 24.0f;
            hpBarHeight = 4.0f;
        } else if (nameplateStyle == 1) {
            xStartPlayer = 2.0f;
            xStartOpponent = 6.0f;
            maxWidthPlayer = 132.0f;
            maxWidthOpponent = 132.0f;
            hpBarY = 24.0f;
        } else {
            xStartPlayer = 38.0f;
            xStartOpponent = 3.0f;
            maxWidthPlayer = 99.0f;
            maxWidthOpponent = 99.0f;
            hpBarY = 24.0f;
        }
        if (isPlayer) {
            barLeft = -70.0f + xStartPlayer;
            barTop = -20.0f + hpBarY - 2.0f;
            float barMaxWidth = maxWidthPlayer;
            barRight = barLeft + barMaxWidth * healthPercent;
        } else {
            barRight = -70.0f + xStartOpponent + maxWidthOpponent;
            barTop = -20.0f + hpBarY - 2.0f;
            float barMaxWidth = maxWidthOpponent;
            barLeft = barRight - barMaxWidth * healthPercent;
        }
        if (healthPercent > 0.5f) {
            r = 100;
            g = 220;
            b = 100;
        } else if (healthPercent > 0.2f) {
            r = 255;
            g = 200;
            b = 50;
        } else {
            r = 230;
            g = 70;
            b = 70;
        }
        float brightness = BattleExtrasConfig.getBattleNameplateBrightness();
        r = (int)Math.min(255.0f, (float)r * brightness);
        g = (int)Math.min(255.0f, (float)g * brightness);
        b = (int)Math.min(255.0f, (float)b * brightness);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(matrix, barLeft, barTop, 0.01f).setColor(r, g, b, 255);
        buffer.addVertex(matrix, barLeft, barTop + hpBarHeight, 0.01f).setColor(r, g, b, 255);
        buffer.addVertex(matrix, barRight, barTop + hpBarHeight, 0.01f).setColor(r, g, b, 255);
        buffer.addVertex(matrix, barRight, barTop, 0.01f).setColor(r, g, b, 255);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private static void renderNameAndLevel(PoseStack poseStack, MultiBufferSource buffers, Font font, String name, int level, boolean isPlayer, String gender, int nameplateStyle) {
        float levelX;
        String levelText;
        float genderX;
        float nameX;
        float nameY;
        Minecraft mc = Minecraft.getInstance();
        float textZOffset = 0.1f;
        if (nameplateStyle == 2 || nameplateStyle == 1) {
            nameY = -8.0f;
            if (isPlayer) {
                nameX = -64.0f;
                nameWidth = font.width(name);
                genderX = nameX + (float)nameWidth * 0.8f + 2.0f;
                levelText = "Lv." + level;
                levelWidth = font.width(levelText);
                levelX = 60.0f - (float)levelWidth * 0.7f;
            } else {
                nameX = -60.0f;
                nameWidth = font.width(name);
                genderX = nameX + (float)nameWidth * 0.8f + 2.0f;
                levelText = "Lv." + level;
                levelWidth = font.width(levelText);
                levelX = 64.0f - (float)levelWidth * 0.7f;
            }
        } else {
            nameY = -8.0f;
            if (isPlayer) {
                nameX = -30.0f;
                nameWidth = font.width(name);
                genderX = nameX + (float)nameWidth * 0.8f + 2.0f;
                levelText = "Lv." + level;
                levelWidth = font.width(levelText);
                levelX = 60.0f - (float)levelWidth * 0.7f;
            } else {
                nameX = -60.0f;
                nameWidth = font.width(name);
                genderX = nameX + (float)nameWidth * 0.8f + 2.0f;
                levelText = "Lv." + level;
                levelWidth = font.width(levelText);
                levelX = 25.0f - (float)levelWidth * 0.7f;
            }
        }
        MultiBufferSource.BufferSource immediateBuffer = mc.renderBuffers().bufferSource();
        poseStack.pushPose();
        poseStack.translate(nameX, nameY, textZOffset);
        poseStack.scale(0.8f, 0.8f, 0.8f);
        font.drawInBatch(name, 0.0f, 0.0f, -1, false, poseStack.last().pose(), (MultiBufferSource)immediateBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        poseStack.popPose();
        if (gender != null && !gender.isEmpty()) {
            int genderColor;
            String genderSymbol;
            if (gender.equalsIgnoreCase("MALE")) {
                genderSymbol = "\u2642";
                genderColor = -9924368;
            } else if (gender.equalsIgnoreCase("FEMALE")) {
                genderSymbol = "\u2640";
                genderColor = -1140308;
            } else {
                genderSymbol = null;
                genderColor = 0;
            }
            if (genderSymbol != null) {
                poseStack.pushPose();
                poseStack.translate(genderX, nameY, textZOffset);
                poseStack.scale(0.8f, 0.8f, 0.8f);
                font.drawInBatch(genderSymbol, 0.0f, 0.0f, genderColor, false, poseStack.last().pose(), (MultiBufferSource)immediateBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                poseStack.popPose();
            }
        }
        levelText = "Lv." + level;
        float levelY = nameY;
        poseStack.pushPose();
        poseStack.translate(levelX, levelY, textZOffset);
        poseStack.scale(0.7f, 0.7f, 0.7f);
        font.drawInBatch(levelText, 0.0f, 0.0f, -11141291, false, poseStack.last().pose(), (MultiBufferSource)immediateBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        poseStack.popPose();
        immediateBuffer.endBatch();
    }

    private static void renderTypeIcons(PoseStack poseStack, List<ElementalType> types, boolean isPlayer, String pokemonName, int nameplateStyle) {
        float y;
        float paddingX;
        if (types == null || types.isEmpty()) {
            return;
        }
        boolean isTerastallized = BattleMessageSubscriber.isTerastallized(pokemonName);
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        float brightness = BattleExtrasConfig.getBattleNameplateBrightness();
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        Matrix4f matrix = poseStack.last().pose();
        float totalWidth = types.size() * 12 + (types.size() - 1) * 2;
        if (nameplateStyle == 2 || nameplateStyle == 1) {
            paddingX = 3.0f;
            y = 10.0f;
        } else {
            paddingX = 3.0f;
            y = 23.0f;
        }
        float startX = isPlayer ? -70.0f + paddingX : 70.0f - totalWidth - paddingX;
        float offsetX = 0.0f;
        for (ElementalType type : types) {
            float iconX = startX + offsetX;
            if (isTerastallized && MEGA_SHOWDOWN_LOADED) {
                String typeName = type.getName().toLowerCase();
                ResourceLocation teraIcon = ResourceLocation.parse((String)(MEGA_SHOWDOWN_TERA_PATH + typeName + ".png"));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)teraIcon);
                BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                buffer.addVertex(matrix, iconX, y, 0.001f).setUv(0.0f, 0.0f);
                buffer.addVertex(matrix, iconX, y + 12.0f, 0.001f).setUv(0.0f, 1.0f);
                buffer.addVertex(matrix, iconX + 12.0f, y + 12.0f, 0.001f).setUv(1.0f, 1.0f);
                buffer.addVertex(matrix, iconX + 12.0f, y, 0.001f).setUv(1.0f, 0.0f);
                BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            } else {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TYPE_SPRITE_SHEET);
                int textureX = type.getTextureXMultiplier() * 36;
                float u0 = (float)textureX / 648.0f;
                float u1 = (float)(textureX + 36) / 648.0f;
                BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                buffer.addVertex(matrix, iconX, y, 0.001f).setUv(u0, 0.0f);
                buffer.addVertex(matrix, iconX, y + 12.0f, 0.001f).setUv(u0, 1.0f);
                buffer.addVertex(matrix, iconX + 12.0f, y + 12.0f, 0.001f).setUv(u1, 1.0f);
                buffer.addVertex(matrix, iconX + 12.0f, y, 0.001f).setUv(u1, 0.0f);
                BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            }
            offsetX += 14.0f;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static List<ElementalType> getTypesFromSpecies(Object species) {
        ArrayList<ElementalType> types = new ArrayList<ElementalType>();
        try {
            Method getTypesMethod = species.getClass().getMethod("getTypes", new Class[0]);
            Iterable typeIterable = (Iterable)getTypesMethod.invoke(species, new Object[0]);
            for (ElementalType type : typeIterable) {
                types.add(type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return types;
    }

    private static List<ElementalType> getTypesFromPokemon(Object pokemonData) {
        ArrayList<ElementalType> types = new ArrayList<ElementalType>();
        try {
            Method getFormMethod = pokemonData.getClass().getMethod("getForm", new Class[0]);
            Object form = getFormMethod.invoke(pokemonData, new Object[0]);
            if (form != null) {
                Method getTypesMethod = form.getClass().getMethod("getTypes", new Class[0]);
                Object typesObj = getTypesMethod.invoke(form, new Object[0]);
                if (typesObj instanceof Iterable) {
                    for (Object type : (Iterable)typesObj) {
                        if (!(type instanceof ElementalType)) continue;
                        types.add((ElementalType)type);
                    }
                }
                if (!types.isEmpty()) {
                    CobblemonBattleInfoClient.debug("[BattleEntityOverlayRenderer] Got {} types from Pokemon.getForm().getTypes()", types.size());
                }
            }
        }
        catch (Exception e) {
            CobblemonBattleInfoClient.debug("[BattleEntityOverlayRenderer] Failed to get form types from Pokemon: {}", e.getMessage());
        }
        return types;
    }

    private static float getHealthPercentFromBattle(ClientBattle battle, String pokemonName, boolean isPlayerPokemon) {
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        ClientBattleSide targetSide = isPlayerPokemon ? playerSide : opponentSide;
        for (ClientBattleActor actor : targetSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                ClientBattlePokemon bp = active.getBattlePokemon();
                if (bp == null || !bp.getSpecies().getName().equalsIgnoreCase(pokemonName)) continue;
                float hpValue = bp.getHpValue();
                float maxHp = bp.getMaxHp();
                float ratio = !isPlayerPokemon && hpValue <= 1.0f && maxHp > 1.0f ? hpValue : (maxHp > 0.0f ? hpValue / maxHp : 1.0f);
                return ratio;
            }
        }
        return 1.0f;
    }

    private static String getGenderFromBattle(ClientBattle battle, String pokemonName, boolean isPlayerPokemon) {
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        ClientBattleSide targetSide = isPlayerPokemon ? playerSide : opponentSide;
        for (ClientBattleActor actor : targetSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                ClientBattlePokemon bp = active.getBattlePokemon();
                if (bp == null || !bp.getSpecies().getName().equalsIgnoreCase(pokemonName)) continue;
                try {
                    Method getGenderMethod = bp.getClass().getMethod("getGender", new Class[0]);
                    Object genderObj = getGenderMethod.invoke((Object)bp, new Object[0]);
                    if (genderObj == null) continue;
                    return genderObj.toString();
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private static String getStatusFromBattle(ClientBattle battle, String pokemonName, boolean isPlayerPokemon) {
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        ClientBattleSide targetSide = isPlayerPokemon ? playerSide : opponentSide;
        for (ClientBattleActor actor : targetSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                ClientBattlePokemon bp = active.getBattlePokemon();
                if (bp == null || !bp.getSpecies().getName().equalsIgnoreCase(pokemonName)) continue;
                try {
                    Method getShowdownNameMethod;
                    Object showdownName;
                    Method getStatusMethod = bp.getClass().getMethod("getStatus", new Class[0]);
                    Object statusObj = getStatusMethod.invoke((Object)bp, new Object[0]);
                    if (statusObj == null || (showdownName = (getShowdownNameMethod = statusObj.getClass().getMethod("getShowdownName", new Class[0])).invoke(statusObj, new Object[0])) == null) continue;
                    return showdownName.toString();
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private static boolean isPlayerPokemonByPokemonUUID(ClientBattle battle, UUID pokemonUUID, String pokemonName) {
        UUID battlePokemonUUID;
        ClientBattlePokemon bp;
        if (pokemonUUID == null) {
            return BattleEntityOverlayRenderer.isPlayerSidePokemon(battle, pokemonName);
        }
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        ClientBattleSide opponentSide = BattleSideHelper.getOpponentSide(battle);
        for (ClientBattleActor actor : playerSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                bp = active.getBattlePokemon();
                if (bp == null || (battlePokemonUUID = bp.getUuid()) == null || !battlePokemonUUID.equals(pokemonUUID)) continue;
                return true;
            }
        }
        for (ClientBattleActor actor : opponentSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                bp = active.getBattlePokemon();
                if (bp == null || (battlePokemonUUID = bp.getUuid()) == null || !battlePokemonUUID.equals(pokemonUUID)) continue;
                return false;
            }
        }
        return BattleEntityOverlayRenderer.isPlayerSidePokemon(battle, pokemonName);
    }

    private static boolean isPlayerSidePokemon(ClientBattle battle, String pokemonName) {
        ClientBattleSide playerSide = BattleSideHelper.getPlayerSide(battle);
        for (ClientBattleActor actor : playerSide.getActors()) {
            for (ActiveClientBattlePokemon active : actor.getActivePokemon()) {
                ClientBattlePokemon bp = active.getBattlePokemon();
                if (bp == null || !bp.getSpecies().getName().equalsIgnoreCase(pokemonName)) continue;
                CobblemonBattleInfoClient.debug("[BattleEntityOverlay] {} found on PLAYER side", pokemonName);
                return true;
            }
        }
        CobblemonBattleInfoClient.debug("[BattleEntityOverlay] {} NOT found on player side -> must be OPPONENT", pokemonName);
        return false;
    }

    private static void renderMegaIcon(PoseStack poseStack, boolean isPlayer, int typeCount, boolean useAlternativeStyle) {
        float iconX;
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MEGA_ICON);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        float brightness = BattleExtrasConfig.getBattleNameplateBrightness();
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        Matrix4f matrix = poseStack.last().pose();
        float typeIconsWidth = typeCount * 12 + (typeCount - 1) * 2;
        float paddingX = useAlternativeStyle ? 3.0f : 3.0f;
        float baseY = 20.0f + (useAlternativeStyle ? -10.0f : 3.0f);
        float iconY = baseY + 3.0f;
        if (isPlayer) {
            float typeStartX = -70.0f + paddingX;
            iconX = typeStartX + typeIconsWidth + 2.0f;
        } else {
            float typeEndX = 70.0f - paddingX - typeIconsWidth;
            iconX = typeEndX - 6.0f - 2.0f;
        }
        if (typeCount == 1) {
            if (useAlternativeStyle) {
                if (isPlayer) {
                    iconX -= 18.0f;
                    iconY -= 21.0f;
                } else {
                    iconX += MEGA_ICON_OFFSET_X_OPPONENT_ALT_SINGLE;
                    iconY += MEGA_ICON_OFFSET_Y_OPPONENT_ALT_SINGLE;
                }
            } else {
                iconX += isPlayer ? MEGA_ICON_OFFSET_X_PLAYER_OVERLAY_SINGLE : MEGA_ICON_OFFSET_X_OPPONENT_OVERLAY_SINGLE;
                iconY += isPlayer ? MEGA_ICON_OFFSET_Y_PLAYER_OVERLAY_SINGLE : MEGA_ICON_OFFSET_Y_OPPONENT_OVERLAY_SINGLE;
            }
        } else if (typeCount == 2) {
            if (useAlternativeStyle) {
                iconX += isPlayer ? MEGA_ICON_OFFSET_X_PLAYER_ALT : MEGA_ICON_OFFSET_X_OPPONENT_ALT;
                iconY += isPlayer ? MEGA_ICON_OFFSET_Y_PLAYER_ALT : MEGA_ICON_OFFSET_Y_OPPONENT_ALT;
            } else {
                iconX += isPlayer ? MEGA_ICON_OFFSET_X_PLAYER_OVERLAY : MEGA_ICON_OFFSET_X_OPPONENT_OVERLAY;
                iconY += isPlayer ? MEGA_ICON_OFFSET_Y_PLAYER_OVERLAY : MEGA_ICON_OFFSET_Y_OPPONENT_OVERLAY;
            }
        }
        float iconZ = -0.1f;
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, iconX, iconY, iconZ).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, iconX, iconY + 6.0f, iconZ).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, iconX + 6.0f, iconY + 6.0f, iconZ).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, iconX + 6.0f, iconY, iconZ).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderSpeedRange(PoseStack poseStack, MultiBufferSource buffers, Font font, Object species, int level, boolean isPlayer, String pokemonName, int nameplateStyle) {
        if (!BattleExtrasConfig.isSpeedRangeEnabled()) {
            return;
        }
        if (!BattleExtrasConfig.isHideBattleTilesEnabled()) {
            return;
        }
        try {
            String lowerName;
            Method getBaseStats;
            Object baseStats;
            int baseSpeed = 0;
            if (species != null && (baseStats = (getBaseStats = species.getClass().getMethod("getBaseStats", new Class[0])).invoke(species, new Object[0])) instanceof Map) {
                Map statsMap = (Map)baseStats;
                for (Map.Entry entry : statsMap.entrySet()) {
                    String statName = entry.getKey().toString().toLowerCase();
                    if (!statName.contains("speed") && !statName.equals("spe")) continue;
                    baseSpeed = (Integer)entry.getValue();
                    break;
                }
            }
            if (baseSpeed <= 0) {
                return;
            }
            int minSpeed = (int)Math.floor((double)((2 * baseSpeed + 0 + 0) * level / 100 + 5) * 0.9);
            int maxSpeed = (int)Math.floor((double)((2 * baseSpeed + 31 + 63) * level / 100 + 5) * 1.1);
            String side = isPlayer ? "player" : "opponent";
            int speedStage = BattleMessageSubscriber.getStatStage(side, lowerName = pokemonName != null ? pokemonName.toLowerCase() : "", "speed");
            if (speedStage != 0) {
                if (speedStage > 0) {
                    minSpeed = (int)((double)(minSpeed * (2 + speedStage)) / 2.0);
                    maxSpeed = (int)((double)(maxSpeed * (2 + speedStage)) / 2.0);
                } else {
                    minSpeed = (int)((double)minSpeed * 2.0 / (double)(2 - speedStage));
                    maxSpeed = (int)((double)maxSpeed * 2.0 / (double)(2 - speedStage));
                }
            }
            if (BattleMessageSubscriber.getTailwindTurns(side) > 0) {
                minSpeed *= 2;
                maxSpeed *= 2;
            }
            String speedText = "Spd: " + minSpeed + "-" + maxSpeed;
            int color = speedStage > 0 ? -11141291 : (speedStage < 0 ? -43691 : -5579265);
            Minecraft mc = Minecraft.getInstance();
            MultiBufferSource.BufferSource immediateBuffer = mc.renderBuffers().bufferSource();
            float textZOffset = 0.1f;
            float speedY = 14.0f;
            float textScale = 0.85f;
            int textWidth = font.width(speedText);
            float speedX = isPlayer ? (float)(-textWidth) * 0.4f + 35.0f : (float)(-textWidth) * 0.4f - 40.0f;
            poseStack.pushPose();
            poseStack.translate(speedX, speedY, textZOffset);
            poseStack.scale(textScale, textScale, textScale);
            font.drawInBatch(speedText, 0.0f, 0.0f, color, false, poseStack.last().pose(), (MultiBufferSource)immediateBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            poseStack.popPose();
            immediateBuffer.endBatch();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void renderStatus(PoseStack poseStack, MultiBufferSource buffers, Font font, String status, boolean isPlayer, int nameplateStyle) {
        int bgColor;
        if (status == null || status.isEmpty()) {
            return;
        }
        int textColor = -1;
        String displayText = status.toUpperCase();
        switch (status.toLowerCase()) {
            case "slp": {
                bgColor = -7303008;
                break;
            }
            case "brn": {
                bgColor = -2068432;
                break;
            }
            case "psn": 
            case "tox": {
                bgColor = -6274912;
                if (!status.equalsIgnoreCase("tox")) break;
                displayText = "TOX";
                break;
            }
            case "par": {
                bgColor = -3100640;
                break;
            }
            case "frz": {
                bgColor = -9385776;
                break;
            }
            default: {
                bgColor = -8355712;
            }
        }
        Minecraft mc = Minecraft.getInstance();
        MultiBufferSource.BufferSource immediateBuffer = mc.renderBuffers().bufferSource();
        float textZOffset = 0.1f;
        float statusY = 11.0f;
        int textWidth = font.width(displayText);
        float bgPadding = 2.0f;
        float bgWidth = (float)textWidth * 0.7f + bgPadding * 2.0f;
        float bgHeight = 8.0f;
        float typeIconsWidth = 26.0f;
        float statusX = isPlayer ? -67.0f + typeIconsWidth + 10.0f : 67.0f - typeIconsWidth - bgWidth - 10.0f;
        poseStack.pushPose();
        poseStack.translate(statusX, statusY, textZOffset - 0.01f);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = poseStack.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float r = (float)(bgColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(bgColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(bgColor & 0xFF) / 255.0f;
        float a = (float)(bgColor >> 24 & 0xFF) / 255.0f;
        buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, 0.0f, bgHeight, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, bgWidth, bgHeight, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, bgWidth, 0.0f, 0.0f).setColor(r, g, b, a);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(statusX + bgPadding, statusY + 1.0f, textZOffset);
        poseStack.scale(0.7f, 0.7f, 0.7f);
        font.drawInBatch(displayText, 0.0f, 0.0f, textColor, false, poseStack.last().pose(), (MultiBufferSource)immediateBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        poseStack.popPose();
        immediateBuffer.endBatch();
    }
}

