/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static void register(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
    }

    public static class ClientConfig {
        static final ClientConfig CONFIG;
        static final ModConfigSpec SPEC;
        final ModConfigSpec.ConfigValue<Boolean> sortingModule;
        final ModConfigSpec.ConfigValue<Boolean> wheelmoveModule;
        final ModConfigSpec.ConfigValue<Boolean> dodgeMousetweaks;

        private ClientConfig(ModConfigSpec.Builder builder) {
            builder.comment("Inventory sorter modules");
            builder.push("modules");
            this.sortingModule = builder.comment("Sorting module").translation("inventorysorter.config.sortingmodule").define("sortingmodule", true);
            this.wheelmoveModule = builder.comment("Wheel move module").translation("inventorysorter.config.wheelmovemodule").define("wheelmovemodule", true);
            this.dodgeMousetweaks = builder.comment("Avoid conflicts with mousetweaks wheel moves").translation("inventorysorter.config.avoidmousetweaks").define("dodgemousetweaks", true);
            builder.pop();
        }

        static {
            Pair conf = new ModConfigSpec.Builder().configure(ClientConfig::new);
            CONFIG = (ClientConfig)conf.getLeft();
            SPEC = (ModConfigSpec)conf.getRight();
        }
    }

    public static class ServerConfig {
        static final ServerConfig CONFIG;
        static final ModConfigSpec SPEC;
        final ModConfigSpec.ConfigValue<List<? extends String>> containerBlacklist;
        final ModConfigSpec.ConfigValue<List<? extends String>> slotBlacklist;

        private ServerConfig(ModConfigSpec.Builder builder) {
            builder.comment("Inventory sorter blacklists");
            builder.push("blacklists");
            this.containerBlacklist = builder.comment("Container blacklist").translation("inventorysorter.config.containerblacklist").defineList("containerBlacklist", ArrayList::new, t -> true);
            this.slotBlacklist = builder.comment("Slot type blacklist").translation("inventorysorter.config.slotblacklist").defineList("slotBlacklist", ArrayList::new, t -> true);
            builder.pop();
        }

        static {
            Pair conf = new ModConfigSpec.Builder().configure(ServerConfig::new);
            CONFIG = (ServerConfig)conf.getLeft();
            SPEC = (ModConfigSpec)conf.getRight();
        }
    }
}

