/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.client.input;

import com.github.flandre923.berrypouch.client.input.KeyAction;
import com.github.flandre923.berrypouch.event.FishingRodEventHandler;
import com.github.flandre923.berrypouch.item.BerryPouch;
import com.github.flandre923.berrypouch.network.CycleBaitPacket;
import dev.architectury.networking.NetworkManager;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CycleBaitAction
implements KeyAction {
    private static final Component NEED_POUCH_MESSAGE = Component.translatable((String)"message.berrypouch.need_pouch");
    private final boolean isLeftCycle;

    public CycleBaitAction(boolean isLeftCycle) {
        this.isLeftCycle = isLeftCycle;
    }

    @Override
    public void onKeyPressed(Minecraft client) {
        NetworkManager.sendToServer((CustomPacketPayload)new CycleBaitPacket(this.isMainHandRod((Player)client.player), this.isLeftCycle));
    }

    @Override
    public boolean shouldTrigger(Player player) {
        if (!this.isHoldingFishingRod(player)) {
            return false;
        }
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability == null) {
            this.sendFeedback(player, NEED_POUCH_MESSAGE);
            return false;
        }
        SlotEntryReference entry = capability.getFirstEquipped(stack -> stack.getItem() instanceof BerryPouch);
        if (entry == null || entry.stack().isEmpty()) {
            this.sendFeedback(player, NEED_POUCH_MESSAGE);
            return false;
        }
        return true;
    }

    private boolean isHoldingFishingRod(Player player) {
        return FishingRodEventHandler.isCobblemonFishingRod(player.getMainHandItem()) || FishingRodEventHandler.isCobblemonFishingRod(player.getOffhandItem());
    }

    private boolean isMainHandRod(Player player) {
        return FishingRodEventHandler.isCobblemonFishingRod(player.getMainHandItem());
    }
}

