/*
 * Decompiled with CFR 0.152.
 */
package com.github.flandre923.berrypouch.client.hud;

import com.cobblemon.mod.common.item.interactive.PokerodItem;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.events.client.ClientGuiEvent;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BaitRenderHandler
implements ClientGuiEvent.RenderHud {
    private static final ResourceLocation GUI_ICONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"berrypouch", (String)"textures/gui/gui_icon.png");
    private static final int ICON_TEXTURE_SIZE = 32;
    private static final int TEXTURE_SHEET_WIDTH = 64;
    private static final int TEXTURE_SHEET_HEIGHT = 64;
    private static final int ICON_RENDER_SIZE = 24;
    private static final int ICON_SPACING = 2;
    private static final int PADDING_X = 10;
    private static final int PADDING_Y = 10;
    private static final int TOTAL_WIDTH = 76;
    private static final int TOTAL_HEIGHT = 24;
    private static final int LEFT_ARROW_U = 0;
    private static final int LEFT_ARROW_V = 0;
    private static final int RIGHT_ARROW_U = 32;
    private static final int RIGHT_ARROW_V = 0;
    private static final int FRAME_U = 0;
    private static final int FRAME_V = 32;

    public void renderHud(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.getMainHandItem();
        Item item = heldItem.getItem();
        if (item instanceof PokerodItem) {
            PokerodItem pokerodItem = (PokerodItem)item;
        } else {
            heldItem = player.getOffhandItem();
            if (!(heldItem.getItem() instanceof PokerodItem)) {
                return;
            }
        }
        ItemStack baitStack = PokerodItem.Companion.getBaitStackOnRod(heldItem);
        if (baitStack.isEmpty()) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        int baseX = screenWidth - 10 - 76;
        int baseY = screenHeight - 10 - 24;
        int leftArrowX = baseX;
        int frameX = leftArrowX + 24 + 2;
        int rightArrowX = frameX + 24 + 2;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ICONS_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(GUI_ICONS_TEXTURE, leftArrowX, baseY, 24, 24, 0.0f, 0.0f, 32, 32, 64, 64);
        guiGraphics.blit(GUI_ICONS_TEXTURE, frameX, baseY, 24, 24, 0.0f, 32.0f, 32, 32, 64, 64);
        guiGraphics.blit(GUI_ICONS_TEXTURE, rightArrowX, baseY, 24, 24, 32.0f, 0.0f, 32, 32, 64, 64);
        RenderSystem.disableBlend();
        int itemRenderX = frameX + 4;
        int itemRenderY = baseY + 4;
        guiGraphics.renderItem(baitStack, itemRenderX, itemRenderY);
    }
}

