/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.ui.render;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import com.anthonyhilyard.advancementplaques.config.AdvancementPlaquesConfig;
import com.anthonyhilyard.iceberg.renderer.CustomItemRenderer;
import com.anthonyhilyard.iceberg.services.Services;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class AdvancementPlaque {
    private final AdvancementToast toast;
    private long animationTime = -1L;
    private long visibleTime = -1L;
    private boolean hasPlayedSound = false;
    private boolean hasTakenScreenshot = false;
    private Toast.Visibility visibility = Toast.Visibility.SHOW;
    private Minecraft mc;
    private CustomItemRenderer itemRenderer;

    public AdvancementPlaque(AdvancementToast toastIn, Minecraft mcIn, CustomItemRenderer itemRendererIn) {
        this.toast = toastIn;
        this.mc = mcIn;
        this.itemRenderer = itemRendererIn;
    }

    public AdvancementToast getToast() {
        return this.toast;
    }

    public int width() {
        return 256;
    }

    public int height() {
        return 32;
    }

    private float getVisibility(long currentTime) {
        float f = Mth.clamp((float)((float)(currentTime - this.animationTime) / 200.0f), (float)0.0f, (float)1.0f);
        f *= f;
        return this.visibility == Toast.Visibility.HIDE ? 1.0f - f : f;
    }

    private Toast.Visibility drawPlaque(GuiGraphics graphics, long displayTime) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen instanceof PauseScreen || mc.screen instanceof LevelLoadingScreen) {
            return Toast.Visibility.SHOW;
        }
        DisplayInfo displayInfo = this.toast.advancement.value().display().orElse(null);
        PoseStack poseStack = graphics.pose();
        if (displayInfo != null) {
            float fadeOutTime;
            float fadeInTime;
            float duration = switch (displayInfo.getType()) {
                default -> {
                    fadeInTime = (float)(AdvancementPlaquesConfig.getInstance().taskEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)(AdvancementPlaquesConfig.getInstance().taskEffectFadeOutTime.get() * 1000.0);
                    yield (float)(AdvancementPlaquesConfig.getInstance().taskDuration.get() * 1000.0);
                }
                case AdvancementType.GOAL -> {
                    fadeInTime = (float)(AdvancementPlaquesConfig.getInstance().goalEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)(AdvancementPlaquesConfig.getInstance().goalEffectFadeOutTime.get() * 1000.0);
                    yield (float)(AdvancementPlaquesConfig.getInstance().goalDuration.get() * 1000.0);
                }
                case AdvancementType.CHALLENGE -> {
                    fadeInTime = (float)(AdvancementPlaquesConfig.getInstance().challengeEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)(AdvancementPlaquesConfig.getInstance().challengeEffectFadeOutTime.get() * 1000.0);
                    yield (float)(AdvancementPlaquesConfig.getInstance().challengeDuration.get() * 1000.0);
                }
            };
            graphics.drawManaged(() -> {
                float alpha;
                if ((float)displayTime >= fadeInTime) {
                    alpha = 1.0f;
                    if ((float)displayTime > duration) {
                        alpha = Math.max(0.0f, Math.min(1.0f, 1.0f - ((float)displayTime - duration) / 1000.0f));
                        if (Services.getPlatformHelper().isModLoaded("canvas")) {
                            alpha = 0.0f;
                        }
                    }
                    int titleColor = AdvancementPlaquesConfig.getInstance().getTitleColor(alpha).getValue();
                    int nameColor = AdvancementPlaquesConfig.getInstance().getNameColor(alpha).getValue();
                    RenderSystem.enableBlend();
                    graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)AdvancementPlaques.TEXTURE_PLAQUES);
                    int frameOffset = 0;
                    if (displayInfo.getType() == AdvancementType.GOAL) {
                        frameOffset = 1;
                    } else if (displayInfo.getType() == AdvancementType.CHALLENGE) {
                        frameOffset = 2;
                    }
                    GuiHelper.blit((PoseStack)poseStack, (int)-1, (int)-1, (int)this.width(), (int)this.height(), (float)0.0f, (float)(this.height() * frameOffset), (int)this.width(), (int)this.height(), (int)256, (int)256);
                    if (alpha > 0.1f) {
                        int typeWidth = mc.font.width((FormattedText)displayInfo.getType().getDisplayName());
                        mc.font.drawInBatch(displayInfo.getType().getDisplayName(), (float)((int)((float)(this.width() - typeWidth) / 2.0f + 15.0f)), 5.0f, titleColor, false, poseStack.last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                        graphics.flush();
                        int titleWidth = mc.font.width((FormattedText)displayInfo.getTitle());
                        if ((float)titleWidth <= 146.66667f) {
                            poseStack.pushPose();
                            poseStack.scale(1.5f, 1.5f, 1.0f);
                            mc.font.drawInBatch(displayInfo.getTitle(), (float)((int)(((float)this.width() / 1.5f - (float)titleWidth) / 2.0f + 10.0f)), 9.0f, nameColor, false, poseStack.last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                            poseStack.popPose();
                        } else {
                            mc.font.drawInBatch(displayInfo.getTitle(), (float)((int)((float)(this.width() - titleWidth) / 2.0f + 15.0f)), 15.0f, nameColor, false, poseStack.last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                        }
                        graphics.flush();
                    }
                    poseStack.pushPose();
                    poseStack.translate(1.0f, 1.0f, 0.0f);
                    poseStack.scale(1.5f, 1.5f, 1.0f);
                    if (Services.getPlatformHelper().isModLoaded("canvas")) {
                        if (alpha > 0.0f) {
                            poseStack.translate(0.0f, 0.0f, -2000.0f);
                            graphics.renderItem(displayInfo.getIcon(), 1, 1);
                        }
                    } else {
                        this.itemRenderer.renderItemModelIntoGUIWithAlpha(graphics, displayInfo.getIcon(), 1, 1, alpha);
                    }
                    poseStack.popPose();
                    if (!this.hasPlayedSound) {
                        this.hasPlayedSound = true;
                        try {
                            SoundEvent sound = null;
                            if (Services.getPlatformHelper().isModLoaded("aether")) {
                                try {
                                    sound = (SoundEvent)Class.forName("com.anthonyhilyard.advancementplaques.compat.AetherHandler").getMethod("getSoundOverride", AdvancementHolder.class).invoke(null, this.toast.advancement);
                                }
                                catch (Exception e) {
                                    AdvancementPlaques.LOGGER.error((Object)e);
                                }
                            }
                            if (sound == null) {
                                switch (displayInfo.getType()) {
                                    case TASK: {
                                        sound = AdvancementPlaques.TASK_COMPLETE;
                                        break;
                                    }
                                    case GOAL: {
                                        sound = AdvancementPlaques.GOAL_COMPLETE;
                                        break;
                                    }
                                    default: {
                                        sound = SoundEvents.UI_TOAST_CHALLENGE_COMPLETE;
                                    }
                                }
                            }
                            switch (displayInfo.getType()) {
                                case TASK: {
                                    if (AdvancementPlaquesConfig.getInstance().taskVolume.get() > 0.0) {
                                        mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f, (float)AdvancementPlaquesConfig.getInstance().taskVolume.get().floatValue()));
                                    }
                                    break;
                                }
                                case GOAL: {
                                    if (AdvancementPlaquesConfig.getInstance().goalVolume.get() > 0.0) {
                                        mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f, (float)AdvancementPlaquesConfig.getInstance().goalVolume.get().floatValue()));
                                    }
                                    break;
                                }
                                default: {
                                    if (AdvancementPlaquesConfig.getInstance().challengeVolume.get() > 0.0) {
                                        mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f, (float)AdvancementPlaquesConfig.getInstance().challengeVolume.get().floatValue()));
                                    }
                                    break;
                                }
                            }
                        }
                        catch (NullPointerException e) {
                            AdvancementPlaques.LOGGER.warn("Tried to play a custom sound for an advancement, but that sound was not registered! Install Advancement Plaques on the server or mute tasks and goals in the config file.");
                        }
                    }
                    if ((float)displayTime >= fadeInTime + fadeOutTime && alpha == 1.0f && !this.hasTakenScreenshot && Services.getPlatformHelper().isModLoaded("advancementscreenshot")) {
                        try {
                            Class.forName("com.anthonyhilyard.advancementplaques.compat.AdvancementScreenshotHandler").getMethod("takeScreenshot", new Class[0]).invoke(null, new Object[0]);
                            this.hasTakenScreenshot = true;
                        }
                        catch (Exception e) {
                            AdvancementPlaques.LOGGER.error((Object)e);
                        }
                    }
                }
                if ((float)displayTime < fadeInTime + fadeOutTime) {
                    alpha = 1.0f - ((float)displayTime - fadeInTime) / fadeOutTime;
                    if ((float)displayTime < fadeInTime) {
                        alpha = (float)displayTime / fadeInTime;
                    }
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 0.0f, 95.0f);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)AdvancementPlaques.TEXTURE_PLAQUE_EFFECTS);
                    if (displayInfo.getType() == AdvancementType.CHALLENGE) {
                        GuiHelper.blit((PoseStack)poseStack, (int)-16, (int)-16, (int)(this.width() + 32), (int)(this.height() + 32), (float)0.0f, (float)(this.height() + 32), (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                    } else {
                        GuiHelper.blit((PoseStack)poseStack, (int)-16, (int)-16, (int)(this.width() + 32), (int)(this.height() + 32), (float)0.0f, (float)0.0f, (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                    }
                    poseStack.popPose();
                }
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            });
            return (float)displayTime >= fadeInTime + fadeOutTime + duration ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }

    public boolean render(int screenWidth, int index, GuiGraphics graphics) {
        long currentTime = Util.getMillis();
        if (this.animationTime == -1L) {
            this.animationTime = currentTime;
        }
        if (this.visibility == Toast.Visibility.SHOW && currentTime - this.animationTime <= 200L) {
            this.visibleTime = currentTime;
        }
        RenderSystem.disableDepthTest();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        if (AdvancementPlaquesConfig.getInstance().onTop.get().booleanValue()) {
            poseStack.translate((float)(graphics.guiWidth() - this.width()) / 2.0f + (float)AdvancementPlaquesConfig.getInstance().horizontalOffset.get().intValue(), (float)AdvancementPlaquesConfig.getInstance().distance.get().intValue(), 800.0f + (float)index);
        } else {
            poseStack.translate((float)(graphics.guiWidth() - this.width()) / 2.0f + (float)AdvancementPlaquesConfig.getInstance().horizontalOffset.get().intValue(), (float)(this.mc.getWindow().getGuiScaledHeight() - (this.height() + AdvancementPlaquesConfig.getInstance().distance.get())), 800.0f + (float)index);
        }
        Toast.Visibility newVisibility = this.drawPlaque(graphics, currentTime - this.visibleTime);
        poseStack.popPose();
        RenderSystem.enableDepthTest();
        if (newVisibility != this.visibility) {
            this.animationTime = currentTime - (long)((int)((1.0f - this.getVisibility(currentTime)) * 200.0f));
            this.visibility = newVisibility;
        }
        return this.visibility == Toast.Visibility.HIDE && currentTime - this.animationTime > 200L;
    }
}

