/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.world.entity.ModEntityTypes;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import com.talhanation.smallships.world.item.ModItems;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BriggEntity
extends ContainerShip
implements Bannerable,
Sailable,
Cannonable,
Ability {
    public static final String ID = "brigg";
    private static final int ORIGINAL_CONTAINER_SIZE = (Integer)SmallShipsConfig.Common.shipContainerBriggContainerSize.get();

    public BriggEntity(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level, ORIGINAL_CONTAINER_SIZE);
    }

    private BriggEntity(Level level, double d, double e, double f) {
        this(ModEntityTypes.BRIGG, level);
        this.setPos(d, e, f);
        this.xo = d;
        this.yo = e;
        this.zo = f;
    }

    public static BriggEntity summon(Level level, double d, double e, double f) {
        return new BriggEntity(level, d, e, f);
    }

    @Override
    public CompoundTag createDefaultAttributes() {
        Attributes attributes = new Attributes();
        attributes.maxHealth = ((Double)SmallShipsConfig.Common.shipAttributeBriggMaxHealth.get()).floatValue();
        attributes.maxSpeed = ((Double)SmallShipsConfig.Common.shipAttributeBriggMaxSpeed.get()).floatValue();
        attributes.maxReverseSpeed = ((Double)SmallShipsConfig.Common.shipAttributeBriggMaxReverseSpeed.get()).floatValue();
        attributes.maxRotationSpeed = ((Double)SmallShipsConfig.Common.shipAttributeBriggMaxRotationSpeed.get()).floatValue();
        attributes.acceleration = ((Double)SmallShipsConfig.Common.shipAttributeBriggAcceleration.get()).floatValue();
        attributes.rotationAcceleration = ((Double)SmallShipsConfig.Common.shipAttributeBriggRotationAcceleration.get()).floatValue();
        CompoundTag tag = new CompoundTag();
        attributes.addSaveData(tag);
        return tag;
    }

    @Override
    public int getMaxPassengers() {
        return 11;
    }

    @Override
    @NotNull
    public Item getDropItem() {
        if (!((Boolean)SmallShipsConfig.Common.shipGeneralDoItemDrop.get()).booleanValue()) {
            return ItemStack.EMPTY.getItem();
        }
        return ModItems.BRIGG_ITEMS.get(this.getVariant());
    }

    @Override
    public Ship.BiomeModifierType getBiomeModifierType() {
        return (Ship.BiomeModifierType)((Object)SmallShipsConfig.Common.shipModifierBriggBiome.get());
    }

    @NotNull
    public Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        float v = 1.0f;
        float h = 0.0f;
        if (!this.getPassengers().isEmpty()) {
            int i = this.getPassengers().indexOf(entity);
            switch (i) {
                case 0: {
                    v += -4.0f;
                    h = 0.0f;
                    break;
                }
                case 1: {
                    v += -2.5f;
                    h = 0.75f;
                    break;
                }
                case 2: {
                    v += -2.5f;
                    h = -0.75f;
                    break;
                }
                case 3: {
                    v += -1.5f;
                    h = -0.75f;
                    break;
                }
                case 4: {
                    v += -1.5f;
                    h = 0.75f;
                    break;
                }
                case 5: {
                    v += -0.5f;
                    h = -0.75f;
                    break;
                }
                case 6: {
                    v += -0.5f;
                    h = 0.75f;
                    break;
                }
                case 7: {
                    v += 0.5f;
                    h = -0.75f;
                    break;
                }
                case 8: {
                    v += 0.5f;
                    h = 0.75f;
                    break;
                }
                default: {
                    v += 1.5f;
                    h = 0.0f;
                }
            }
        }
        return new Vec3((double)v, (double)dimensions.height() - 0.1, (double)h).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
    }

    @Override
    public Bannerable.BannerPosition getBannerPosition() {
        return new Bannerable.BannerPosition(-180.0f, 90.0f, -6.6, 1.65, 0.05);
    }

    @Override
    public void waterSplash() {
        Vec3 vector3d = this.getViewVector(0.0f);
        float f0 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 1.2f;
        float f1 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 1.2f;
        float f2 = 4.0f - this.random.nextFloat() * 0.7f;
        float f2_ = -2.3f - this.random.nextFloat() * 0.7f;
        float x = 0.0f;
        for (int i = 0; i < 2; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 + (double)f1 * 5.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 - (double)f1 * 5.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1 * 1.1, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public Cannonable.CannonPosition getCannonPosition(int index) {
        ArrayList<Cannonable.CannonPosition> positionList = new ArrayList<Cannonable.CannonPosition>();
        Cannonable.CannonPosition pos1 = new Cannonable.CannonPosition(1.4, 0.0, 0.75, true);
        Cannonable.CannonPosition pos2 = new Cannonable.CannonPosition(1.4, 0.0, 0.75, false);
        Cannonable.CannonPosition pos3 = new Cannonable.CannonPosition(-0.1, 0.0, 0.85, true);
        Cannonable.CannonPosition pos4 = new Cannonable.CannonPosition(-0.1, 0.0, 0.85, false);
        Cannonable.CannonPosition pos5 = new Cannonable.CannonPosition(-1.2, 0.0, 0.75, true);
        Cannonable.CannonPosition pos6 = new Cannonable.CannonPosition(-1.2, 0.0, 0.75, false);
        positionList.add(pos1);
        positionList.add(pos2);
        positionList.add(pos3);
        positionList.add(pos4);
        positionList.add(pos5);
        positionList.add(pos6);
        return (Cannonable.CannonPosition)positionList.get(index);
    }

    @Override
    public byte getMaxCannonPerSide() {
        return 3;
    }
}

