/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.cannon;

import com.mojang.datafixers.util.Pair;
import com.talhanation.smallships.utils.ServerParticleUtils;
import com.talhanation.smallships.utils.VectorMath;
import com.talhanation.smallships.world.entity.cannon.ICannon;
import com.talhanation.smallships.world.entity.projectile.ICannonProjectile;
import com.talhanation.smallships.world.sound.ModSoundTypes;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Cannon {
    private final RandomSource random;
    private int shootDelayTimer;
    private Pair<Entity, Supplier<ICannonProjectile>> cachedShoot = null;
    private int coolDown;
    private final Level level;
    private final ICannon owner;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private float pitch = 0.0f;
    private float prevPitch = 0.0f;
    private Vector3d pos = new Vector3d();
    private final float barrelHeight = 0.3f;
    private final float speed = 2.6f;

    public Cannon(ICannon owner) {
        this.owner = owner;
        this.level = owner.getLevel();
        this.random = this.level.getRandom();
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPrevYaw() {
        return this.prevYaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getPrevPitch() {
        return this.prevPitch;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = Math.clamp(pitch, -90.0f, 20.0f);
    }

    public Vector3d getForward() {
        Vector3d dir = new Vector3d(0.0, 0.0, 1.0);
        dir.rotateX((double)((float)Math.toRadians(this.pitch)));
        dir.rotateY((double)((float)Math.toRadians(this.yaw)));
        return dir;
    }

    public Vector3d getBarrelEndPoint() {
        return this.getBarrelEndPointLocal().add((Vector3dc)this.pos);
    }

    public Vector3d getBarrelEndPointLocal() {
        Vector3d barrelMiddle = new Vector3d();
        double d = barrelMiddle.y;
        Objects.requireNonNull(this);
        barrelMiddle.y = d + (double)0.3f;
        return barrelMiddle.add((Vector3dc)this.getForward().normalize().mul((double)1.2f));
    }

    public Vector3d getPos() {
        return new Vector3d((Vector3dc)this.pos);
    }

    public void tick(double x, double y, double z, double yaw, double pitch) {
        this.prevPitch = this.pitch;
        this.prevYaw = this.yaw;
        this.setYaw((float)yaw);
        this.setPitch((float)pitch);
        this.pos.set(x, y, z);
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        if (this.shootDelayTimer > 0) {
            --this.shootDelayTimer;
            if (!this.level.isClientSide() && this.shootDelayTimer == 0 && this.cachedShoot != null) {
                ICannonProjectile projectile = (ICannonProjectile)((Supplier)this.cachedShoot.getSecond()).get();
                if (projectile != null) {
                    this.shoot((Entity)this.cachedShoot.getFirst(), projectile);
                }
                this.cachedShoot = null;
            }
        }
        if (this.coolDown == 3) {
            this.playReloadedSound();
        }
    }

    private void resetTimer() {
        this.shootDelayTimer = 10 + this.random.nextInt(10);
    }

    private void setCoolDown() {
        this.coolDown = 50;
    }

    public boolean isCooldown() {
        return this.coolDown > 0;
    }

    public boolean isFuzing() {
        return this.shootDelayTimer > 0;
    }

    public void triggerFuze(Entity shooter, Supplier<ICannonProjectile> projectileSupplier) {
        if (this.level.isClientSide() || this.isCooldown() || this.isFuzing()) {
            return;
        }
        this.resetTimer();
        this.playFuzeSound();
        this.cachedShoot = new Pair((Object)shooter, projectileSupplier);
    }

    protected void shoot(Entity shooter, ICannonProjectile projectile) {
        ServerLevel serverLevel;
        block5: {
            block4: {
                Level level = this.level;
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (!this.isCooldown() && !this.isFuzing()) break block5;
            }
            return;
        }
        this.setCoolDown();
        Vector3d forward = this.getForward();
        projectile.shootAndSpawn(this, this.getBarrelEndPoint(), VectorMath.castToVector3f(forward), this.speed, 1.0f, shooter);
        this.playCannonShotSound();
        Vector3d particlePos = this.getBarrelEndPoint();
        particlePos.add((Vector3dc)this.getForward().mul(0.25));
        ServerParticleUtils.sendParticle(serverLevel, this.owner.provideShootParticles(), particlePos, forward);
        ParticleOptions particles = projectile.getAdditionalCannonShootParticles();
        if (particles != null) {
            ServerParticleUtils.sendParticle(serverLevel, particles, particlePos, forward);
        }
    }

    public void shootAdvanced(Vec3 shootVec, double yShootVec, LivingEntity driverEntity, double speed, double accuracy) {
    }

    private void playReloadedSound() {
        if (this.level.isClientSide()) {
            return;
        }
        this.owner.playSoundAt((SoundEvent)SoundEvents.ARMOR_EQUIP_NETHERITE.value(), 2.0f, 1.0f);
    }

    private void playCannonShotSound() {
        if (this.level.isClientSide()) {
            return;
        }
        this.owner.playSoundAt(ModSoundTypes.CANNON_SHOT, 10.0f, 1.0f);
    }

    private void playFuzeSound() {
        if (this.level.isClientSide()) {
            return;
        }
        this.owner.playSoundAt(SoundEvents.TNT_PRIMED, 1.0f, 1.5f);
    }
}

