/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjeiextras.geneticsresequenced.recipes;

import dev.aaronhowser.mods.geneticsresequenced.data.EntityGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.ftb.mods.ftbjeiextras.geneticsresequenced.recipes.ConversionRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class DecryptHelixRecipe
implements ConversionRecipe {
    private final Ingredient input;
    private final ItemStack output;
    private final float chance;

    public DecryptHelixRecipe(EntityType<?> entityType, Holder<Gene> gene, float chance) {
        ItemStack helixStack;
        ItemStack stack = ModItems.INSTANCE.getDNA_HELIX().toStack();
        EntityDnaItem.Companion.setEntityType(stack, entityType);
        this.input = DataComponentIngredient.of((boolean)true, (ItemStack)stack);
        this.output = helixStack = DnaHelixItem.Companion.getHelixStack(gene);
        this.chance = chance;
    }

    @Override
    public Ingredient input() {
        return this.input;
    }

    @Override
    public ItemStack output() {
        return this.output;
    }

    public float getChance() {
        return this.chance;
    }

    public static List<DecryptHelixRecipe> collectAllRecipes(RegistryAccess registries) {
        ArrayList<DecryptHelixRecipe> recipes = new ArrayList<DecryptHelixRecipe>();
        Map entityGeneHolderMap = EntityGenes.Companion.getEntityGeneHolderMap((HolderLookup.Provider)registries);
        entityGeneHolderMap.forEach((entityType, geneHolderMap) -> {
            int weight = geneHolderMap.values().stream().mapToInt(Integer::intValue).sum();
            geneHolderMap.forEach((gene, geneWeight) -> {
                float chance = (float)geneWeight.intValue() / (float)weight;
                recipes.add(new DecryptHelixRecipe((EntityType<?>)entityType, (Holder<Gene>)gene, chance));
            });
        });
        return recipes;
    }
}

