/*
 * Decompiled with CFR 0.152.
 */
package com.pam.pamhc2trees.worldgen.placers;

import com.mojang.serialization.MapCodec;
import com.pam.pamhc2trees.init.BlockRegistration;
import com.pam.pamhc2trees.worldgen.ConfiguredFeatures;
import com.pam.pamhc2trees.worldgen.placers.FruitTreeFoliagePlacer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class CoconutFruitBlockFoliagePlacer
extends FruitTreeFoliagePlacer {
    private static BlockState fruit;
    public static final MapCodec<FruitTreeFoliagePlacer> CODEC;

    public CoconutFruitBlockFoliagePlacer(BlockState fruit) {
        super(fruit);
    }

    public static BlockState getFruit() {
        return fruit;
    }

    public static void setFruit(BlockState fruit) {
        CoconutFruitBlockFoliagePlacer.fruit = fruit;
    }

    protected FoliagePlacerType<?> type() {
        return ConfiguredFeatures.COCONUT_FRUIT_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader p_273066_, FoliagePlacer.FoliageSetter foliageSetter, RandomSource p_273178_, TreeConfiguration p_272850_, int p_273067_, FoliagePlacer.FoliageAttachment p_273711_, int p_273580_, int p_273511_, int p_273685_) {
        for (int i = p_273685_; i >= p_273685_ - p_273580_; --i) {
            int j = Math.max(p_273511_ + p_273711_.radiusOffset() - 1 - i / 2, 0);
            this.placeLeavesRow(p_273066_, foliageSetter, p_273178_, p_272850_, p_273711_.pos(), j - 1, i + 1, p_273711_.doubleTrunk());
            this.placeFruitRow(p_273066_, foliageSetter, p_273178_, p_272850_, p_273711_.pos(), 1, p_273685_ - 4, p_273711_.doubleTrunk());
        }
    }

    public int foliageHeight(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return 4;
    }

    protected boolean shouldSkipLocation(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return false;
    }

    protected void placeFruitRow(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomsource, TreeConfiguration treeconfig, BlockPos pos, int p_161443_, int p_161444_, boolean p_161445_) {
        int i = p_161445_ ? 1 : 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = -p_161443_; j <= p_161443_ + i; ++j) {
            for (int k = -p_161443_; k <= p_161443_ + i; ++k) {
                if (this.shouldSkipLocationSigned(randomsource, j, p_161444_, k, p_161443_, p_161445_)) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, j, p_161444_, k);
                this.tryPlaceFruit(pLevel, foliageSetter, randomsource, treeconfig, (BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)pos, j, p_161444_, k));
            }
        }
    }

    protected static boolean tryPlaceLeaf(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomsource, TreeConfiguration treeconfig, BlockPos pos) {
        if (CoconutFruitBlockFoliagePlacer.validTreePos(pLevel, pos)) {
            foliageSetter.set(pos, treeconfig.foliageProvider.getState(randomsource, pos));
            return true;
        }
        return false;
    }

    protected void tryPlaceFruit(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomsource, TreeConfiguration treeconfig, BlockPos pos) {
        if (CoconutFruitBlockFoliagePlacer.validTreePos(pLevel, pos)) {
            foliageSetter.set(pos, ((Block)BlockRegistration.pamcoconut.get()).defaultBlockState());
        }
    }

    public static boolean validTreePos(LevelSimulatedReader pLevel, BlockPos pos) {
        return pLevel.isStateAtPosition(pos, state -> !state.hasProperty((Property)LeavesBlock.PERSISTENT) || (Boolean)state.getValue((Property)LeavesBlock.PERSISTENT) == false) && TreeFeature.validTreePos((LevelSimulatedReader)pLevel, (BlockPos)pos);
    }

    static {
        CODEC = MapCodec.unit(() -> new CoconutFruitBlockFoliagePlacer(((Block)BlockRegistration.pamcoconut.get()).defaultBlockState()));
    }
}

