/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.mixins.entities.EntityAccessor;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.configs.GenericMobConfig;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SkeletonHorseman
extends Feature<GenericMobConfig> {
    public SkeletonHorseman() {
        super(GenericMobConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<GenericMobConfig> context) {
        SkeletonHorse skeletonHorseEntity = (SkeletonHorse)EntityType.SKELETON_HORSE.create((Level)context.level().getLevel());
        skeletonHorseEntity.setPersistenceRequired();
        skeletonHorseEntity.moveTo((double)context.origin().getX() + 0.5, (double)context.origin().getY(), (double)context.origin().getZ() + 0.5, 0.0f, 0.0f);
        skeletonHorseEntity.finalizeSpawn((ServerLevelAccessor)context.level(), context.level().getCurrentDifficultyAt(context.origin()), MobSpawnType.STRUCTURE, null);
        Skeleton skeletonEntity = (Skeleton)EntityType.SKELETON.create((Level)context.level().getLevel());
        skeletonEntity.finalizeSpawn((ServerLevelAccessor)context.level(), context.level().getCurrentDifficultyAt(context.origin()), MobSpawnType.STRUCTURE, null);
        ((GenericMobConfig)context.config()).heldItem.ifPresent(item -> {
            ItemStack heldItem = new ItemStack((ItemLike)item);
            skeletonEntity.setItemInHand(InteractionHand.MAIN_HAND, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), heldItem, 0.1f));
            skeletonEntity.setLeftHanded(context.random().nextFloat() < 0.05f);
        });
        ((GenericMobConfig)context.config()).helmet.ifPresent(item -> skeletonEntity.setItemSlot(EquipmentSlot.HEAD, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), item.getDefaultInstance(), 0.075f)));
        ((GenericMobConfig)context.config()).chestplate.ifPresent(item -> skeletonEntity.setItemSlot(EquipmentSlot.CHEST, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), item.getDefaultInstance(), 0.075f)));
        ((GenericMobConfig)context.config()).leggings.ifPresent(item -> skeletonEntity.setItemSlot(EquipmentSlot.LEGS, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), item.getDefaultInstance(), 0.075f)));
        ((GenericMobConfig)context.config()).boots.ifPresent(item -> skeletonEntity.setItemSlot(EquipmentSlot.FEET, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), item.getDefaultInstance(), 0.075f)));
        skeletonEntity.setPersistenceRequired();
        skeletonEntity.setHealth((float)((GenericMobConfig)context.config()).health);
        skeletonEntity.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)((GenericMobConfig)context.config()).health);
        skeletonEntity.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)((GenericMobConfig)context.config()).speedModifier);
        skeletonEntity.moveTo((double)context.origin().getX() + 0.5, (double)(context.origin().getY() + 1), (double)context.origin().getZ() + 0.5, 0.0f, 0.0f);
        if (skeletonHorseEntity.getPassengers().isEmpty()) {
            ((EntityAccessor)skeletonHorseEntity).setPassengers((ImmutableList<Entity>)ImmutableList.of((Object)skeletonEntity));
        } else {
            ArrayList list = Lists.newArrayList((Iterable)skeletonHorseEntity.getPassengers());
            list.add(skeletonEntity);
            ((EntityAccessor)skeletonHorseEntity).setPassengers((ImmutableList<Entity>)ImmutableList.copyOf((Collection)list));
        }
        context.level().addFreshEntityWithPassengers((Entity)skeletonHorseEntity);
        return true;
    }
}

