/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.utils;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.item.SizeEssenceItem;
import dev.cudzer.cobblemonsizevariation.network.SizeChangedPacket;
import java.util.Objects;
import kotlin.jvm.functions.Function0;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SizeItemInteractions {
    private static final ResourceLocation SIZE_CHANGED_SOUND = ResourceLocation.fromNamespaceAndPath((String)"cobblemonsizevariation", (String)"size_changed");

    public static boolean handleEntityInteract(Player player, Level level, InteractionHand hand, PokemonEntity target) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (!(item instanceof SizeEssenceItem)) {
            return false;
        }
        SizeEssenceItem sizeItem = (SizeEssenceItem)item;
        if (target.getPokemon().getOwnerUUID() == null) {
            return false;
        }
        if (!target.getPokemon().getOwnerUUID().equals(player.getUUID())) {
            return false;
        }
        if (level.isClientSide) {
            return true;
        }
        if (target.getPokemon().getScaleModifier() >= CobblemonSizeVariation.SIZER.getMaxSizeModifier() && sizeItem.getSizeModificationType() == SizeEssenceItem.SizeModificationType.GROW) {
            player.displayClientMessage((Component)Component.literal((String)(SizeItemInteractions.getPokemonName(target) + " is at maximum size!")), true);
            return false;
        }
        if (target.getPokemon().getScaleModifier() <= CobblemonSizeVariation.SIZER.getMinSizeModifier() && sizeItem.getSizeModificationType() == SizeEssenceItem.SizeModificationType.SHRINK) {
            player.displayClientMessage((Component)Component.literal((String)(SizeItemInteractions.getPokemonName(target) + " is at minimum size!")), true);
            return false;
        }
        if (sizeItem.getSizeModification().equals((Object)SizeEssenceItem.SizeModification.SET)) {
            SizeItemInteractions.setPokemonSize((ServerPlayer)player, target, sizeItem.getSizeChange());
            player.displayClientMessage((Component)Component.literal((String)(SizeItemInteractions.getPokemonName(target) + " is now size " + String.format("%.2f", Float.valueOf(sizeItem.getSizeChange())))), true);
        } else {
            float currentSize = SizeItemInteractions.getPokemonSize(target);
            float newSize = Math.max(0.1f, Math.min(10.0f, currentSize + sizeItem.getSizeChange()));
            SizeItemInteractions.setPokemonSize((ServerPlayer)player, target, newSize);
            player.displayClientMessage((Component)Component.literal((String)(SizeItemInteractions.getPokemonName(target) + " is now size " + String.format("%.2f", Float.valueOf(newSize)))), true);
        }
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        SoundEvent sound = SoundEvent.createFixedRangeEvent((ResourceLocation)SIZE_CHANGED_SOUND, (float)64.0f);
        target.level().playSound((Entity)target, target.blockPosition(), sound, SoundSource.NEUTRAL, 2.0f, 1.0f);
        return true;
    }

    private static float getPokemonSize(PokemonEntity pokemon) {
        return pokemon.getPokemon().getScaleModifier();
    }

    private static void setPokemonSize(ServerPlayer player, PokemonEntity pokemonEntity, float newSize) {
        if (!pokemonEntity.level().isClientSide) {
            pokemonEntity.getPokemon().setScaleModifier(newSize);
            CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(Objects.requireNonNull(player), (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> ((PokemonEntity)pokemonEntity).getPokemon()), Double.valueOf(newSize)));
        }
    }

    private static String getPokemonName(PokemonEntity pokemon) {
        return pokemon.getPokemon().getSpecies().getName();
    }
}

