/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.data;

import com.cobblemon.mod.common.pokemon.Species;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.data.PokemonSize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class CustomSizeDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();
    protected static Map<ResourceLocation, PokemonSize> data = new HashMap<ResourceLocation, PokemonSize>();
    protected static List<ResourceLocation> resourceLocationList = new ArrayList<ResourceLocation>();
    protected static Map<String, PokemonSize> speciesSizeMap = new HashMap<String, PokemonSize>();

    public CustomSizeDataManager() {
        super(GSON, CobblemonSizeVariation.cobblemonSizeResource("custom_sizes").getPath());
    }

    protected void apply(Map<ResourceLocation, JsonElement> json, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        CobblemonSizeVariation.LOGGER.info("Loading custom pokemon sizes...");
        HashMap<ResourceLocation, PokemonSize> newMap = new HashMap<ResourceLocation, PokemonSize>();
        ArrayList<ResourceLocation> newResourceLocationList = new ArrayList<ResourceLocation>();
        HashMap<String, PokemonSize> newSpeciesMap = new HashMap<String, PokemonSize>();
        data.clear();
        resourceLocationList.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : json.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            PokemonSize.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).ifSuccess(result -> {
                PokemonSize pokemonSize = (PokemonSize)result.getFirst();
                newMap.put(key, pokemonSize);
                pokemonSize.setJsonLocation(key);
                newResourceLocationList.add(key);
                for (String speciesName : pokemonSize.speciesList) {
                    if (speciesName == null || speciesName.isBlank()) continue;
                    newSpeciesMap.put(speciesName.toLowerCase(Locale.ROOT), pokemonSize);
                }
            }).ifError(partial -> CobblemonSizeVariation.LOGGER.error("Failed to parse json data for {} due to {}", (Object)key, (Object)partial.message()));
        }
        resourceLocationList = newResourceLocationList;
        data = newMap;
        speciesSizeMap = newSpeciesMap;
        CobblemonSizeVariation.LOGGER.info("Loaded {} custom size files", (Object)data.size());
    }

    public static PokemonSize getCustomSizeFile(Species species) {
        if (species == null) {
            return null;
        }
        return speciesSizeMap.get(species.getName().toLowerCase(Locale.ROOT));
    }
}

