/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.config.RespawnConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodData;

public class EffectComponent {
    private final List<MobEffectInstance> effects;
    private final int resetHp;
    private final int resetHunger;
    private final float resetSaturation;

    public EffectComponent(ServerPlayer player) {
        YigdConfig config = YigdConfig.getConfig();
        RespawnConfig rConfig = config.respawnConfig;
        this.effects = new ArrayList<MobEffectInstance>();
        this.loadEffectsFromConfig(rConfig);
        this.resetHp = rConfig.respawnHealth;
        FoodData hungerManager = player.getFoodData();
        this.resetHunger = !rConfig.resetHunger ? hungerManager.getFoodLevel() : rConfig.respawnHunger;
        this.resetSaturation = !rConfig.resetSaturation ? hungerManager.getSaturationLevel() : rConfig.respawnSaturation;
    }

    public EffectComponent(List<MobEffectInstance> effects, int resetHp, int resetHunger, float resetSaturation) {
        this.effects = effects;
        this.resetHp = resetHp;
        this.resetHunger = resetHunger;
        this.resetSaturation = resetSaturation;
    }

    public void applyToPlayer(ServerPlayer player) {
        if (this.resetHp > 0) {
            player.setHealth((float)this.resetHp);
        }
        FoodData hungerManager = player.getFoodData();
        if (this.resetHunger >= 0) {
            hungerManager.setFoodLevel(this.resetHunger);
        }
        if (this.resetSaturation >= 0.0f) {
            hungerManager.setSaturation(this.resetSaturation);
        }
        for (MobEffectInstance effect : this.effects) {
            player.addEffect(effect);
        }
    }

    public CompoundTag toNbt() {
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.putInt("hp", this.resetHp);
        nbtCompound.putInt("hunger", this.resetHunger);
        nbtCompound.putFloat("saturation", this.resetSaturation);
        ListTag nbtEffects = new ListTag();
        for (MobEffectInstance instance : this.effects) {
            nbtEffects.add((Object)instance.save());
        }
        nbtCompound.put("effects", (Tag)nbtEffects);
        return nbtCompound;
    }

    private void loadEffectsFromConfig(RespawnConfig rConfig) {
        for (RespawnConfig.EffectConfig effect : rConfig.respawnEffects) {
            MobEffect statusEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)effect.effectName));
            if (statusEffect == null) continue;
            Holder effectRegistryEntry = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)statusEffect);
            MobEffectInstance effectInstance = new MobEffectInstance(effectRegistryEntry, effect.effectTime, effect.effectLevel - 1, false, effect.showBubbles);
            this.effects.add(effectInstance);
        }
    }

    public static EffectComponent fromNbt(CompoundTag nbt) {
        int resetHp = nbt.getInt("hp");
        int resetHunger = nbt.getInt("hunger");
        float resetSaturation = nbt.getFloat("saturation");
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        ListTag effectsNbt = nbt.getList("effects", 10);
        for (Tag e : effectsNbt) {
            CompoundTag compound = (CompoundTag)e;
            MobEffectInstance instance = MobEffectInstance.load((CompoundTag)compound);
            effects.add(instance);
        }
        return new EffectComponent(effects, resetHp, resetHunger, resetSaturation);
    }
}

