/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.CompatConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.events.YigdEvents;
import com.b1n_ry.yigd.util.DropRule;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class TravelersBackpackCompat
implements InvModCompat<GraveItem> {
    public static boolean isIntegrationEnabled() {
        try {
            return TravelersBackpack.enableIntegration();
        }
        catch (Error | Exception e) {
            return false;
        }
    }

    @Override
    public String getModName() {
        return "travelers backpack";
    }

    @Override
    public void clear(ServerPlayer player) {
        AttachmentUtils.getAttachment((Player)player).ifPresent(ITravelersBackpack::removeWearable);
    }

    @Override
    public CompatComponent<GraveItem> readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)nbt).orElse(ItemStack.EMPTY);
        DropRule dropRule = nbt.contains("dropRule") ? DropRule.valueOf(nbt.getString("dropRule")) : YigdConfig.getConfig().compatConfig.defaultTravelersBackpackDropRule;
        return new TBCompatComponent(new GraveItem(stack, dropRule));
    }

    @Override
    public CompatComponent<GraveItem> getNewComponent(ServerPlayer player) {
        return new TBCompatComponent(player);
    }

    private static class TBCompatComponent
    extends CompatComponent<GraveItem> {
        public TBCompatComponent(ServerPlayer player) {
            super(player);
        }

        public TBCompatComponent(GraveItem inventory) {
            super(inventory);
        }

        @Override
        public GraveItem getInventory(ServerPlayer player) {
            DropRule defaultDropRule = YigdConfig.getConfig().compatConfig.defaultTravelersBackpackDropRule;
            ItemStack stack = AttachmentUtils.getWearingBackpack((Player)player);
            return stack == null ? InventoryComponent.EMPTY_GRAVE_ITEM : new GraveItem(stack, defaultDropRule);
        }

        @Override
        public NonNullList<GraveItem> merge(CompatComponent<?> mergingComponent, ServerPlayer merger) {
            NonNullList extraItems = NonNullList.create();
            GraveItem graveItem = (GraveItem)mergingComponent.inventory;
            ItemStack mergingStack = graveItem.stack;
            ItemStack currentStack = ((GraveItem)this.inventory).stack;
            if (mergingStack.isEmpty()) {
                return extraItems;
            }
            if (!currentStack.isEmpty()) {
                extraItems.add((Object)graveItem);
                return extraItems;
            }
            this.inventory = new GraveItem(mergingStack, graveItem.dropRule);
            return extraItems;
        }

        @Override
        public NonNullList<ItemStack> storeToPlayer(ServerPlayer player) {
            if (((GraveItem)this.inventory).stack.isEmpty()) {
                return NonNullList.create();
            }
            AttachmentUtils.equipBackpack((Player)player, (ItemStack)((GraveItem)this.inventory).stack.copy());
            return NonNullList.create();
        }

        @Override
        public void handleDropRules(DeathContext context) {
            CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
            DropRule dropRule = compatConfig.defaultTravelersBackpackDropRule;
            ItemStack stack = ((GraveItem)this.inventory).stack;
            if (stack.isEmpty()) {
                return;
            }
            if (dropRule == DropRule.PUT_IN_GRAVE) {
                dropRule = ((YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent(stack, -1, context, true))).getDropRule();
            }
            ((GraveItem)this.inventory).dropRule = dropRule;
        }

        @Override
        public NonNullList<GraveItem> getAsGraveItemList() {
            NonNullList stacks = NonNullList.create();
            stacks.add((Object)((GraveItem)this.inventory));
            return stacks;
        }

        @Override
        public CompatComponent<GraveItem> filterInv(Predicate<DropRule> predicate) {
            GraveItem graveItem = predicate.test(((GraveItem)this.inventory).dropRule) ? (GraveItem)this.inventory : InventoryComponent.EMPTY_GRAVE_ITEM;
            return new TBCompatComponent(graveItem);
        }

        @Override
        public boolean removeItem(Predicate<ItemStack> predicate, int itemCount) {
            ItemStack stack = ((GraveItem)this.inventory).stack;
            if (predicate.test(stack)) {
                stack.shrink(itemCount);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.inventory = InventoryComponent.EMPTY_GRAVE_ITEM;
        }

        @Override
        public CompoundTag writeNbt(HolderLookup.Provider registries) {
            try {
                CompoundTag nbt = !((GraveItem)this.inventory).stack.isEmpty() ? (CompoundTag)((GraveItem)this.inventory).stack.save(registries) : new CompoundTag();
                nbt.putString("dropRule", ((GraveItem)this.inventory).dropRule.name());
                return nbt;
            }
            catch (Exception e) {
                Yigd.LOGGER.error("Error while converting item to NBT: {}", (Object)((GraveItem)this.inventory).stack, (Object)e);
                return new CompoundTag();
            }
        }
    }
}

