/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.epherolib.config;

import com.epherical.epherolib.CommonPlatform;
import com.epherical.epherolib.lang.ServerLanguage;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;

public class LanguageConfig {
    private static final Pattern UNSUPPORTED_FORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected static final Logger LOGGER = LogUtils.getLogger();
    private final boolean devEnvironment = Boolean.getBoolean("epherolib.dev");
    private final String folderName;
    private static final Map<String, ServerLanguage> languages = new HashMap<String, ServerLanguage>();

    public LanguageConfig(String folderName) {
        this.folderName = folderName;
    }

    public boolean loadTranslations(String modId, String ... files) {
        Path output = this.getConfigPath(modId).resolve(this.folderName);
        if (!Files.exists(output, new LinkOption[0])) {
            try {
                Files.createDirectories(output, new FileAttribute[0]);
                for (String file : files) {
                    try (InputStream fileStream = this.getClass().getClassLoader().getResourceAsStream("translations/" + file + ".json");){
                        JsonObject jsonobject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(fileStream, StandardCharsets.UTF_8), JsonObject.class);
                        HashMap map = Maps.newHashMap();
                        LanguageConfig.loadFromJson(jsonobject, map::put);
                        languages.put(file, new ServerLanguage(map));
                        Files.writeString(output.resolve(file + ".json"), (CharSequence)GSON.toJson((JsonElement)jsonobject), new OpenOption[0]);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("", (Throwable)e);
            }
        } else {
            try (Stream<Path> walk = Files.walk(output, new FileVisitOption[0]);){
                walk.forEach(path -> {
                    if (path.toFile().getName().endsWith(".json")) {
                        try {
                            JsonObject jsonObject = (JsonObject)GSON.fromJson(Files.readString(path), JsonObject.class);
                            HashMap map = Maps.newHashMap();
                            LanguageConfig.loadFromJson(jsonObject, map::put);
                            languages.put(FilenameUtils.getBaseName((String)path.toFile().getName()), new ServerLanguage(map));
                        }
                        catch (IOException e) {
                            LOGGER.warn("", (Throwable)e);
                        }
                    }
                });
            }
            catch (IOException e) {
                LOGGER.warn("", (Throwable)e);
            }
        }
        return true;
    }

    public Path getConfigPath(String modID) {
        return CommonPlatform.platform.getRootConfigPath(modID);
    }

    public static void loadFromJson(JsonObject jsonObject, BiConsumer<String, String> consumer) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String replacement = UNSUPPORTED_FORMAT_PATTERN.matcher(GsonHelper.convertToString((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()))).replaceAll("%$1s");
            consumer.accept((String)entry.getKey(), replacement);
        }
    }

    public static Map<String, ServerLanguage> getLanguages() {
        return languages;
    }

    public static ServerLanguage getLanguage(ServerPlayer player) {
        return languages.get(CommonPlatform.platform.getPlayerLanguage(player));
    }
}

