/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.util;

import com.scouter.cobblemonoutbreaks.config.OutbreakConfigManager;
import com.scouter.cobblemonoutbreaks.event.CobblemonOutbreaksEvent;
import com.scouter.cobblemonoutbreaks.manager.OutbreakWorldManager;
import com.scouter.cobblemonoutbreaks.portal.entity.OutbreakPortalEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class PortalUtils {
    public static BlockPos findSuitableSpawnPoint(Player player) {
        int maxRange = OutbreakConfigManager.getConfig().getSpawningConfig().getMaxSpawnRadius();
        int minRange = OutbreakConfigManager.getConfig().getSpawningConfig().getMinSpawnRadius();
        int randomX = PortalUtils.generateRandomOffset(player.level(), minRange, maxRange);
        int randomZ = PortalUtils.generateRandomOffset(player.level(), minRange, maxRange);
        int spawnY = PortalUtils.findSpawnYLevel(player, randomX, randomZ);
        return new BlockPos(player.getBlockX() + randomX, spawnY, player.getBlockZ() + randomZ);
    }

    private static int generateRandomOffset(Level level, int range, int range2) {
        int offset = level.random.nextInt(range2 - range) + (level.random.nextBoolean() ? 5 : -5);
        return level.random.nextBoolean() ? -offset : offset;
    }

    private static int findSpawnYLevel(Player player, int offsetX, int offsetZ) {
        int y = (int)player.getY() + 10;
        Level level = player.level();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(player.getBlockX() + offsetX, y, player.getBlockZ() + offsetZ);
        while (PortalUtils.shouldContinueSearching(level, (BlockPos)pos) && y >= -64 && level.getBlockState((BlockPos)pos).getFluidState().isEmpty()) {
            pos.setY(--y);
        }
        return y;
    }

    private static boolean shouldContinueSearching(Level level, BlockPos pos) {
        return level.getBlockState(pos).isAir() && level.getBlockState(pos.below()).isAir() || !level.getBlockState(pos).isAir() && !level.getBlockState(pos.below()).isAir() || !level.getBlockState(pos).isAir() && level.getBlockState(pos.below()).isAir();
    }

    public static void sendMessageToPlayer(Player player, int y) {
        if (OutbreakConfigManager.getConfig().getMessages().isSendPortalSpawnMessage()) {
            if (OutbreakConfigManager.getConfig().getMessages().isBiomeSpecificSpawnsDebug()) {
                MutableComponent yLevel = Component.literal((String)String.valueOf(y)).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.ITALIC);
                MutableComponent outBreakMessage = Component.translatable((String)"cobblemonoutbreaks.unlucky_spawn_debug", (Object[])new Object[]{yLevel}).withStyle(ChatFormatting.DARK_AQUA);
                player.sendSystemMessage((Component)outBreakMessage);
            } else {
                MutableComponent outBreakMessage = Component.translatable((String)"cobblemonoutbreaks.unlucky_spawn").withStyle(ChatFormatting.DARK_AQUA);
                player.sendSystemMessage((Component)outBreakMessage);
            }
        }
    }

    public static boolean isValidSpawnY(ServerPlayer serverPlayer, int y) {
        ResourceKey dimension = serverPlayer.level().dimension();
        return !(dimension == Level.NETHER && y <= 0 || dimension == Level.END && y <= 0) && (dimension != Level.OVERWORLD || y > -64);
    }

    public static boolean chunkIsProtected(ServerLevel level, BlockPos pos) {
        OutbreakWorldManager manager = OutbreakWorldManager.get((Level)level);
        return manager.containsChunk(pos);
    }

    public static void handleInvalidSpawnY(ServerPlayer serverPlayer, int y) {
        PortalUtils.sendMessageToPlayerY((Player)serverPlayer, y);
    }

    private static void sendMessageToPlayerY(Player player, int y) {
        if (OutbreakConfigManager.getConfig().getMessages().isSendPortalSpawnMessage()) {
            if (OutbreakConfigManager.getConfig().getMessages().isBiomeSpecificSpawnsDebug()) {
                MutableComponent yLevel = Component.literal((String)String.valueOf(y)).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC});
                MutableComponent outBreakMessage = Component.translatable((String)"cobblemonoutbreaks.unlucky_spawn_debug", (Object[])new Object[]{yLevel}).withStyle(ChatFormatting.DARK_AQUA);
                player.sendSystemMessage((Component)outBreakMessage);
            } else {
                MutableComponent outBreakMessage = Component.translatable((String)"cobblemonoutbreaks.unlucky_spawn").withStyle(ChatFormatting.DARK_AQUA);
                player.sendSystemMessage((Component)outBreakMessage);
            }
        }
    }

    public static void handleChunkProtection(ServerPlayer serverPlayer, BlockPos pos) {
        if (OutbreakConfigManager.getConfig().getMessages().isSendPortalSpawnMessage()) {
            MutableComponent message = Component.translatable((String)"cobblemonoutbreaks.chunk_protected").withStyle(ChatFormatting.RED);
            serverPlayer.sendSystemMessage((Component)message);
        }
    }

    public static void spawnPortal(ServerPlayer serverPlayer, BlockPos pos) {
        OutbreakPortalEntity outbreakPortal = new OutbreakPortalEntity(serverPlayer.level(), (Player)serverPlayer, pos);
        CobblemonOutbreaksEvent.PortalSpawn portalSpawn = new CobblemonOutbreaksEvent.PortalSpawn((ServerLevel)serverPlayer.level(), outbreakPortal);
        NeoForge.EVENT_BUS.post((Event)portalSpawn);
    }
}

