/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.sound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.config.OutbreakConfigManager;
import com.scouter.cobblemonoutbreaks.sound.SoundSourceCodec;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;

public class OutbreakSounds {
    public static final Codec<OutbreakSounds> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SoundChoice.CODEC.fieldOf("sound_choice").forGetter(OutbreakSounds::getSoundChoice), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("sound_to_play").forGetter(OutbreakSounds::getSoundEvent), (App)SoundSourceCodec.CODEC.fieldOf("source_source").forGetter(OutbreakSounds::getSource), (App)Codec.STRING.fieldOf("config_key").forGetter(OutbreakSounds::getConfigKey), (App)Codec.FLOAT.fieldOf("volume").forGetter(OutbreakSounds::getVolume), (App)Codec.INT.fieldOf("pitch").forGetter(OutbreakSounds::getPitch)).apply((Applicative)inst, OutbreakSounds::new));
    private final SoundChoice choice;
    private final SoundEvent event;
    private final SoundSource source;
    private final String configKey;
    private final float volume;
    private final int pitch;

    public OutbreakSounds(SoundChoice choice, SoundEvent event, SoundSource source, String configKey, float volume, int pitch) {
        this.choice = choice;
        this.event = event;
        this.source = source;
        this.configKey = configKey;
        this.volume = volume;
        this.pitch = pitch;
    }

    public SoundChoice getSoundChoice() {
        return this.choice;
    }

    public SoundEvent getSoundEvent() {
        return this.event;
    }

    public SoundSource getSource() {
        return this.source;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public float getVolume() {
        return this.volume;
    }

    public int getPitch() {
        return this.pitch;
    }

    public void playSound(ServerLevel level, BlockPos pos) {
        if (this.choice == SoundChoice.CONFIG) {
            Map<String, Float> volumes = OutbreakConfigManager.getConfig().getSound().getVolumes();
            float configVolume = volumes.getOrDefault(this.configKey, Float.valueOf(this.volume)).floatValue();
            level.playSound(null, pos, this.event, this.source, configVolume, (float)this.pitch);
        } else {
            level.playSound(null, pos, this.event, this.source, this.volume, (float)this.pitch);
        }
    }

    public static enum SoundChoice implements StringRepresentable
    {
        CONFIG,
        CUSTOM;

        public static final Codec<SoundChoice> CODEC;

        public static SoundChoice byName(String name) {
            return SoundChoice.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static SoundChoice fromId(int id) {
            return SoundChoice.values()[id];
        }

        static {
            CODEC = StringRepresentable.fromEnum(SoundChoice::values);
        }
    }
}

