/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.reward;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.reward.ItemStackRewards;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class OutbreakRewards {
    public static final OutbreakRewards DEFAULT = new OutbreakRewards(Collections.emptyList(), 0);
    public static final OutbreakRewards WITH_STACK = new OutbreakRewards(List.of(new ItemStackRewards(new ItemStack((ItemLike)Items.DIAMOND, 5), 0.5f)), 0);
    public static Codec<OutbreakRewards> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStackRewards.CODEC.listOf().fieldOf("item_rewards").forGetter(OutbreakRewards::getRewards), (App)Codec.INT.fieldOf("experience_reward").forGetter(OutbreakRewards::getExperience)).apply((Applicative)inst, OutbreakRewards::new));
    private final List<ItemStackRewards> itemRewards;
    private final int experienceReward;

    public OutbreakRewards(List<ItemStackRewards> itemRewards, int experienceReward) {
        this.itemRewards = itemRewards;
        this.experienceReward = experienceReward;
    }

    public List<ItemStackRewards> getRewards() {
        return this.itemRewards;
    }

    public int getExperience() {
        return this.experienceReward;
    }

    public double spawnExperienceRewards(ServerLevel level, BlockPos pos) {
        double completionXp;
        int i;
        for (completionXp = (double)this.getExperience(); completionXp > 0.0; completionXp -= (double)i) {
            i = 20;
            level.addFreshEntity((Entity)new ExperienceOrb((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), i));
        }
        return completionXp;
    }

    public List<ItemStack> spawnItemRewards(ServerLevel level, BlockPos pos) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        List<ItemStackRewards> rewards = this.getRewards();
        for (ItemStackRewards stackRewards : rewards) {
            float randomNr = level.getRandom().nextFloat();
            if (!(randomNr <= stackRewards.getChance())) continue;
            stacks.add(stackRewards.getItemReward());
        }
        stacks.forEach(s -> level.addFreshEntity((Entity)new ItemEntity((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), s)));
        return stacks;
    }
}

