/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.portal.old;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.data.OutbreakAlgorithmsData;
import com.scouter.cobblemonoutbreaks.data.OutbreakMessageData;
import com.scouter.cobblemonoutbreaks.data.OutbreakSoundsData;
import com.scouter.cobblemonoutbreaks.data.OutbreakWaveData;
import com.scouter.cobblemonoutbreaks.data.SpeciesShinyData;
import com.scouter.cobblemonoutbreaks.portal.OutbreakPortal;
import com.scouter.cobblemonoutbreaks.portal.OutbreakPortalSpawnBiomes;
import com.scouter.cobblemonoutbreaks.portal.OutbreakPortalSpawnSettings;
import com.scouter.cobblemonoutbreaks.portal.OutbreakSpecies;
import com.scouter.cobblemonoutbreaks.portal.old.OutbreakAlgorithmsOld;
import com.scouter.cobblemonoutbreaks.portal.old.OutbreakRewardsOld;
import com.scouter.cobblemonoutbreaks.portal.old.OutbreakSpeciesOld;
import com.scouter.cobblemonoutbreaks.reward.ItemStackRewards;
import com.scouter.cobblemonoutbreaks.reward.OutbreakRewards;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.slf4j.Logger;

public class OutbreakPortalOld {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Codec<OutbreakPortalOld> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)OutbreakSpeciesOld.CODEC.fieldOf("species_data").forGetter(s -> s.speciesData), (App)OutbreakRewardsOld.CODEC.optionalFieldOf("rewards", (Object)OutbreakRewardsOld.getDefaultRewards()).forGetter(r -> r.outbreakRewards), (App)OutbreakAlgorithmsOld.CODEC.optionalFieldOf("algorithms", (Object)OutbreakAlgorithmsOld.getDefaultAlgoritms()).forGetter(a -> a.outbreakAlgorithms), (App)Codec.INT.optionalFieldOf("gate_timer", (Object)36000).forGetter(t -> t.gateTimer), (App)Codec.intRange((int)-63, (int)255).optionalFieldOf("outbreak_min_y", (Object)-63).forGetter(r -> r.minOutbreakY), (App)Codec.intRange((int)-63, (int)255).optionalFieldOf("outbreak_max_y", (Object)255).forGetter(r -> r.maxOutbreakY), (App)ExtraCodecs.TAG_OR_ELEMENT_ID.listOf().optionalFieldOf("biome", Collections.emptyList()).forGetter(t -> t.biomeTags)).apply((Applicative)inst, OutbreakPortalOld::new));
    private OutbreakSpeciesOld speciesData;
    private OutbreakRewardsOld outbreakRewards;
    protected int gateTimer;
    private OutbreakAlgorithmsOld outbreakAlgorithms;
    protected final List<ResourceLocation> spawnBiomeTags;
    protected final List<ExtraCodecs.TagOrElementLocation> biomeTags;
    protected final List<ResourceLocation> spawnBiome;
    private ResourceLocation jsonLocation;
    private int minOutbreakY;
    private int maxOutbreakY;
    private boolean isOld;

    public OutbreakPortalOld(OutbreakSpeciesOld speciesData, OutbreakRewardsOld rewards, OutbreakAlgorithmsOld outbreakAlgorithms, int gateTimer, int minOutbreakY, int maxOutbreakY, List<ExtraCodecs.TagOrElementLocation> spawnBiome) {
        this.speciesData = speciesData;
        this.outbreakRewards = rewards;
        this.outbreakAlgorithms = outbreakAlgorithms;
        this.gateTimer = gateTimer;
        this.minOutbreakY = minOutbreakY;
        this.maxOutbreakY = maxOutbreakY;
        ArrayList<ResourceLocation> spawnBiomeTags = new ArrayList<ResourceLocation>();
        ArrayList<ResourceLocation> spawnBiomes = new ArrayList<ResourceLocation>();
        for (ExtraCodecs.TagOrElementLocation tagOrElementLocation : spawnBiome) {
            if (tagOrElementLocation.tag()) {
                spawnBiomeTags.add(tagOrElementLocation.id());
                continue;
            }
            spawnBiomes.add(tagOrElementLocation.id());
        }
        this.spawnBiome = spawnBiomes;
        this.spawnBiomeTags = spawnBiomeTags;
        this.biomeTags = spawnBiome;
    }

    public List<ExtraCodecs.TagOrElementLocation> getBiomeTags() {
        return this.biomeTags;
    }

    public void setJsonLocation(ResourceLocation location) {
        this.jsonLocation = location;
    }

    public ResourceLocation getJsonLocation() {
        try {
            return this.jsonLocation;
        }
        catch (Exception e) {
            LOGGER.error("Could not find jsonLocation due to {}", (Throwable)e);
            return ResourceLocation.withDefaultNamespace((String)"");
        }
    }

    public OutbreakAlgorithmsOld getOutbreakAlgorithms() {
        return this.outbreakAlgorithms;
    }

    public double getMaxGateTime() {
        return this.gateTimer;
    }

    public List<ResourceLocation> getSpawnBiomeTags() {
        return this.spawnBiomeTags;
    }

    public List<ResourceLocation> getSpawnBiome() {
        return this.spawnBiome;
    }

    public OutbreakSpeciesOld getSpeciesData() {
        return this.speciesData;
    }

    public OutbreakRewardsOld getOutbreakRewards() {
        return this.outbreakRewards;
    }

    public int getMinOutbreakY() {
        return this.minOutbreakY;
    }

    public int getMaxOutbreakY() {
        return this.maxOutbreakY;
    }

    public void setOld(boolean old) {
        this.isOld = old;
    }

    public boolean isOld() {
        return this.isOld;
    }

    public OutbreakPortal getOutBreakPortalNew() {
        OutbreakWaveData waveData = new OutbreakWaveData(this.getSpeciesData().getWaves(), this.getSpeciesData().getSpawnCount());
        OutbreakSpecies species = new OutbreakSpecies(this.getSpeciesData().getSpecies(), waveData, SpeciesShinyData.DEFAULT, this.getSpeciesData().getRarity());
        ArrayList<ItemStackRewards> stackRewards = new ArrayList<ItemStackRewards>();
        for (Item item : this.getOutbreakRewards().getRewards()) {
            if (item.getDefaultInstance().is(Items.AIR)) {
                LOGGER.info("Skipped AIR for {}", (Object)this.getJsonLocation());
                continue;
            }
            stackRewards.add(new ItemStackRewards(item.getDefaultInstance(), 1.0f));
        }
        OutbreakRewards rewards = new OutbreakRewards(stackRewards, this.getOutbreakRewards().getExperience());
        OutbreakPortalSpawnBiomes spawnBiomes = new OutbreakPortalSpawnBiomes(this.getBiomeTags(), List.of());
        OutbreakPortalSpawnSettings portalSpawnSettings = new OutbreakPortalSpawnSettings(this.getMinOutbreakY(), this.getMaxOutbreakY(), spawnBiomes);
        OutbreakPortal outbreakPortal = new OutbreakPortal(species, rewards, OutbreakAlgorithmsData.DEFAULT, portalSpawnSettings, OutbreakSoundsData.DEFAULT, OutbreakMessageData.DEFAULT, this.gateTimer);
        outbreakPortal.setOld(true);
        return outbreakPortal;
    }
}

