/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.portal.entity;

import com.google.common.collect.ConcurrentHashMultiset;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;

public class OutbreakPortalEntityIdData {
    public static final Codec<OutbreakPortalEntityIdData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("owner_uuid").forGetter(OutbreakPortalEntityIdData::getOwnerUUID), (App)UUIDUtil.CODEC.fieldOf("outbreak_uuid").forGetter(OutbreakPortalEntityIdData::getOutbreakUUID), (App)UUIDUtil.CODEC.listOf().fieldOf("current_entity_uuids").xmap(ConcurrentHashMultiset::create, List::copyOf).forGetter(OutbreakPortalEntityIdData::getCurrentOutbreakWaveEntities), (App)UUIDUtil.CODEC.listOf().fieldOf("total_entity_uuids").xmap(ConcurrentHashMultiset::create, List::copyOf).forGetter(OutbreakPortalEntityIdData::getTotalOutbreakEntityIds)).apply((Applicative)instance, OutbreakPortalEntityIdData::new));
    private UUID ownerUUID;
    private UUID outbreakUUID;
    private ConcurrentHashMultiset<UUID> currentOutbreakWaveEntities;
    private ConcurrentHashMultiset<UUID> totalOutbreakEntityIds;

    public OutbreakPortalEntityIdData(UUID ownerUUID, UUID outbreakUUID) {
        this.ownerUUID = ownerUUID;
        this.outbreakUUID = outbreakUUID;
        this.currentOutbreakWaveEntities = ConcurrentHashMultiset.create();
        this.totalOutbreakEntityIds = ConcurrentHashMultiset.create();
    }

    public OutbreakPortalEntityIdData(UUID ownerUUID, UUID outbreakUUID, ConcurrentHashMultiset<UUID> currentOutbreakWaveEntities, ConcurrentHashMultiset<UUID> totalOutbreakEntityIds) {
        this.ownerUUID = ownerUUID;
        this.outbreakUUID = outbreakUUID;
        this.currentOutbreakWaveEntities = currentOutbreakWaveEntities;
        this.totalOutbreakEntityIds = totalOutbreakEntityIds;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public UUID getOutbreakUUID() {
        return this.outbreakUUID;
    }

    public ConcurrentHashMultiset<UUID> getCurrentOutbreakWaveEntities() {
        return this.currentOutbreakWaveEntities;
    }

    public ConcurrentHashMultiset<UUID> getTotalOutbreakEntityIds() {
        return this.totalOutbreakEntityIds;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public void setOutbreakUUID(UUID outbreakUUID) {
        this.outbreakUUID = outbreakUUID;
    }

    public void setCurrentOutbreakWaveEntities(ConcurrentHashMultiset<UUID> currentOutbreakWaveEntities) {
        this.currentOutbreakWaveEntities = currentOutbreakWaveEntities;
    }

    public void setTotalOutbreakEntityIds(ConcurrentHashMultiset<UUID> totalOutbreakEntityIds) {
        this.totalOutbreakEntityIds = totalOutbreakEntityIds;
    }

    public String toString() {
        return "OutbreakPortalEntityIdData{ownerUUID=" + String.valueOf(this.ownerUUID) + ", outbreakUUID=" + String.valueOf(this.outbreakUUID) + ", currentOutbreakWaveEntities=" + String.valueOf(this.currentOutbreakWaveEntities) + ", totalOutbreakEntityIds=" + String.valueOf(this.totalOutbreakEntityIds) + "}";
    }
}

