/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.portal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.data.OutbreakAlgorithmsData;
import com.scouter.cobblemonoutbreaks.data.OutbreakMessageData;
import com.scouter.cobblemonoutbreaks.data.OutbreakSoundsData;
import com.scouter.cobblemonoutbreaks.data.OutbreakWaveData;
import com.scouter.cobblemonoutbreaks.data.SpeciesShinyData;
import com.scouter.cobblemonoutbreaks.portal.OutbreakPortalSpawnSettings;
import com.scouter.cobblemonoutbreaks.portal.OutbreakSpecies;
import com.scouter.cobblemonoutbreaks.portal.PokemonRarity;
import com.scouter.cobblemonoutbreaks.portal.old.OutbreakPortalOld;
import com.scouter.cobblemonoutbreaks.reward.OutbreakRewards;
import net.minecraft.resources.ResourceLocation;

public class OutbreakPortal {
    public static final OutbreakPortal DEFAULT = new OutbreakPortal(new OutbreakSpecies("pikachu", new OutbreakWaveData(3, 6), SpeciesShinyData.DEFAULT, PokemonRarity.COMMON), OutbreakRewards.WITH_STACK, OutbreakAlgorithmsData.DEFAULT, OutbreakPortalSpawnSettings.DEFAULT, OutbreakSoundsData.DEFAULT, OutbreakMessageData.DEFAULT, 36000);
    public static final Codec<OutbreakPortal> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OutbreakSpecies.CODEC.fieldOf("species_data").forGetter(OutbreakPortal::getSpeciesData), (App)OutbreakRewards.CODEC.fieldOf("rewards").forGetter(OutbreakPortal::getRewards), (App)OutbreakAlgorithmsData.CODEC.fieldOf("algorithms").forGetter(OutbreakPortal::getOutbreakAlgorithms), (App)OutbreakPortalSpawnSettings.CODEC.fieldOf("spawn_settings").forGetter(OutbreakPortal::getOutbreakPortalSpawnSettings), (App)OutbreakSoundsData.CODEC.optionalFieldOf("sounds", (Object)OutbreakSoundsData.DEFAULT).forGetter(OutbreakPortal::getOutbreakSounds), (App)OutbreakMessageData.CODEC.optionalFieldOf("messages", (Object)OutbreakMessageData.DEFAULT).forGetter(OutbreakPortal::getOutbreakMessageData), (App)Codec.INT.fieldOf("gate_timer").forGetter(OutbreakPortal::getGateTimer)).apply((Applicative)instance, OutbreakPortal::new));
    public static Codec<OutbreakPortal> EITHER = Codec.either(OutbreakPortalOld.CODEC, CODEC).xmap(either -> {
        if (either.left().isPresent()) {
            OutbreakPortalOld outbreakPortalOld = (OutbreakPortalOld)either.left().get();
            OutbreakPortal OutbreakPortalOld2 = outbreakPortalOld.getOutBreakPortalNew();
            return OutbreakPortalOld2;
        }
        OutbreakPortal outbreakPortal = (OutbreakPortal)either.right().get();
        return outbreakPortal;
    }, Either::right);
    private final OutbreakSpecies species;
    private final OutbreakRewards rewards;
    private final OutbreakAlgorithmsData outbreakAlgorithms;
    private final OutbreakPortalSpawnSettings outbreakPortalSpawnSettings;
    private final OutbreakSoundsData outbreakSounds;
    private final OutbreakMessageData outbreakMessageData;
    private final int gateTimer;
    private ResourceLocation id;
    private boolean isOld;

    public OutbreakPortal(OutbreakSpecies species, OutbreakRewards rewards, OutbreakAlgorithmsData outbreakAlgorithms, OutbreakPortalSpawnSettings outbreakPortalSpawnSettings, OutbreakSoundsData outbreakSounds, OutbreakMessageData outbreakMessageData, int gateTimer) {
        this.species = species;
        this.rewards = rewards;
        this.outbreakAlgorithms = outbreakAlgorithms;
        this.outbreakPortalSpawnSettings = outbreakPortalSpawnSettings;
        this.outbreakSounds = outbreakSounds;
        this.outbreakMessageData = outbreakMessageData;
        this.gateTimer = gateTimer;
    }

    public OutbreakSpecies getSpeciesData() {
        return this.species;
    }

    public OutbreakRewards getRewards() {
        return this.rewards;
    }

    public OutbreakAlgorithmsData getOutbreakAlgorithms() {
        return this.outbreakAlgorithms;
    }

    public OutbreakPortalSpawnSettings getOutbreakPortalSpawnSettings() {
        return this.outbreakPortalSpawnSettings;
    }

    public OutbreakSoundsData getOutbreakSounds() {
        return this.outbreakSounds;
    }

    public OutbreakMessageData getOutbreakMessageData() {
        return this.outbreakMessageData;
    }

    public int getGateTimer() {
        return this.gateTimer;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public boolean isOld() {
        return this.isOld;
    }

    public void setOld(boolean old) {
        this.isOld = old;
    }

    public String toString() {
        return "OutbreakPortal{species=" + String.valueOf(this.species) + ", rewards=" + String.valueOf(this.rewards) + ", outbreakAlgorithms=" + String.valueOf(this.outbreakAlgorithms) + ", outbreakPortalSpawnSettings=" + String.valueOf(this.outbreakPortalSpawnSettings) + ", outbreakSounds=" + String.valueOf(this.outbreakSounds) + ", outbreakMessageData=" + String.valueOf(this.outbreakMessageData) + ", gateTimer=" + this.gateTimer + "}";
    }
}

