/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.manager;

import com.google.common.collect.ConcurrentHashMultiset;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.scouter.cobblemonoutbreaks.codec.OutbreaksExtraCodec;
import com.scouter.cobblemonoutbreaks.config.OutbreakConfigManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;

public class OutbreakWorldManager
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final SavedData.Factory<OutbreakWorldManager> OUTBREAK_WORLD_MANAGER_FACTORY = new SavedData.Factory(OutbreakWorldManager::new, OutbreakWorldManager::new);
    private ConcurrentHashMultiset<ChunkPos> chunkPosList = ConcurrentHashMultiset.create();
    private static final Codec<List<ChunkPos>> CHUNK_POS_CODEC = Codec.list(OutbreaksExtraCodec.CHUNK_POS_CODEC_STRING);
    private int timeLeft;

    public static OutbreakWorldManager get(Level level) {
        if (level.isClientSide) {
            throw new RuntimeException("Don't access this client-side!");
        }
        ServerLevel serverLevel = level.getServer().overworld();
        DimensionDataStorage storage = serverLevel.getDataStorage();
        return (OutbreakWorldManager)storage.computeIfAbsent(OUTBREAK_WORLD_MANAGER_FACTORY, "outbreakworldmanager");
    }

    public int decreaseAndGetTime() {
        --this.timeLeft;
        this.setDirty();
        return this.timeLeft;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public void increaseTimeLeft() {
        ++this.timeLeft;
        this.setDirty();
    }

    public void decreaseTimeLeft() {
        --this.timeLeft;
        this.setDirty();
    }

    public void setTimeLeft(int time) {
        this.timeLeft = time;
        this.setDirty();
    }

    public void clearTimeLeft() {
        this.timeLeft = 0;
        this.setDirty();
    }

    public void setTimeLeftToNewConfig() {
        int time;
        this.timeLeft = time = OutbreakConfigManager.getConfig().getSpawningConfig().getRandomOutbreakTimer();
        this.setDirty();
    }

    public boolean containsChunk(ChunkPos pos) {
        return this.chunkPosList.contains((Object)pos);
    }

    public boolean containsChunk(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        boolean containsChunk = this.chunkPosList.contains((Object)chunkPos);
        return containsChunk;
    }

    public void addChunkToList(ChunkPos pos) {
        this.chunkPosList.add((Object)pos);
        this.setDirty();
    }

    public void removeChunkFromList(ChunkPos pos) {
        this.chunkPosList.remove((Object)pos);
        this.setDirty();
    }

    public void clearChunkList() {
        this.chunkPosList.clear();
        this.setDirty();
    }

    public OutbreakWorldManager() {
    }

    public OutbreakWorldManager(CompoundTag compoundTag, HolderLookup.Provider provider) {
        this.timeLeft = compoundTag.getInt("world_timer");
        ListTag chunkListTag = compoundTag.getList("chunk_pos_list", 10);
        for (int i = 0; i < chunkListTag.size(); ++i) {
            CompoundTag chunkTag = chunkListTag.getCompound(i);
            int x = chunkTag.getInt("x");
            int z = chunkTag.getInt("z");
            this.chunkPosList.add((Object)new ChunkPos(x, z));
        }
        LOGGER.info("Loaded {} chunk positions successfully.", (Object)this.chunkPosList.size());
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        compoundTag.putInt("world_timer", this.timeLeft);
        ListTag chunkListTag = new ListTag();
        for (ChunkPos chunkPos : this.chunkPosList) {
            CompoundTag chunkTag = new CompoundTag();
            chunkTag.putInt("x", chunkPos.x);
            chunkTag.putInt("z", chunkPos.z);
            chunkListTag.add((Object)chunkTag);
        }
        compoundTag.put("chunk_pos_list", (Tag)chunkListTag);
        LOGGER.info("Saved {} chunk positions successfully.", (Object)this.chunkPosList.size());
        return compoundTag;
    }
}

