/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.manager;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.scouter.cobblemonoutbreaks.config.OutbreakConfigManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;

public class OutbreakPlayerManager
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final SavedData.Factory<OutbreakPlayerManager> OUTBREAK_PLAYER_MANAGER_FACTORY = new SavedData.Factory(OutbreakPlayerManager::new, OutbreakPlayerManager::new);
    private final Map<UUID, Integer> timeLeftMap = new ConcurrentHashMap<UUID, Integer>();
    private static final Codec<Map<UUID, Integer>> MAPPER = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)Codec.INT);

    public static OutbreakPlayerManager get(Level level) {
        if (level.isClientSide) {
            throw new RuntimeException("Don't access this client-side!");
        }
        ServerLevel serverLevel = level.getServer().overworld();
        DimensionDataStorage storage = serverLevel.getDataStorage();
        return (OutbreakPlayerManager)storage.computeIfAbsent(OUTBREAK_PLAYER_MANAGER_FACTORY, "outbreakplayermanager");
    }

    public boolean containsUUID(UUID player) {
        return this.timeLeftMap.containsKey(player);
    }

    public int getTimeLeft(UUID player) {
        return this.timeLeftMap.get(player);
    }

    public void setTimeLeft(UUID player, int time) {
        this.timeLeftMap.put(player, time);
        this.setDirty();
    }

    public void clearTimeLeft() {
        for (Map.Entry<UUID, Integer> key : this.timeLeftMap.entrySet()) {
            this.timeLeftMap.put(key.getKey(), 0);
        }
        this.setDirty();
    }

    public void setTimeLeftToNewConfig() {
        for (Map.Entry<UUID, Integer> key : this.timeLeftMap.entrySet()) {
            int time = OutbreakConfigManager.getConfig().getSpawningConfig().getPerPlayerOutbreakTimer();
            if (key.getValue() <= time) continue;
            this.timeLeftMap.put(key.getKey(), time);
        }
        this.setDirty();
    }

    public OutbreakPlayerManager() {
    }

    public OutbreakPlayerManager(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag tag = compoundTag.getCompound("outbreak_player_map");
        MAPPER.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).ifSuccess(this.timeLeftMap::putAll).ifError(partial -> LOGGER.error("Failed to load outbreak portal map due to {}", partial));
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider pRegistries) {
        MAPPER.encodeStart((DynamicOps)NbtOps.INSTANCE, this.timeLeftMap).ifSuccess(e -> compoundTag.put("outbreak_player_map", e)).ifError(partial -> LOGGER.error("Failed to save outbreak portal map due to {}", partial)).result().orElse(compoundTag);
        return compoundTag;
    }
}

