/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.data;

import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.ShinyChanceCalculationEvent;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.config.OutbreakConfigManager;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;

public class SpeciesShinyData {
    public static final SpeciesShinyData DEFAULT = new SpeciesShinyData(ShinyChoice.CONFIG, 1024.0);
    private final ShinyChoice choice;
    private final double shinyChance;
    public static Codec<SpeciesShinyData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ShinyChoice.CODEC.fieldOf("shiny_choice").forGetter(SpeciesShinyData::getShinyChoice), (App)Codec.DOUBLE.fieldOf("shiny_chance").forGetter(SpeciesShinyData::getChance)).apply((Applicative)inst, SpeciesShinyData::new));

    public SpeciesShinyData(ShinyChoice choice, double shinyChance) {
        this.choice = choice;
        this.shinyChance = shinyChance;
    }

    public double getChance() {
        return this.shinyChance;
    }

    public ShinyChoice getShinyChoice() {
        return this.choice;
    }

    public double getShinyChance(Pokemon pokemon) {
        return switch (this.choice.ordinal()) {
            case 0 -> OutbreakConfigManager.getConfig().getShinyConfig().getChance();
            case 2 -> {
                ShinyChanceCalculationEvent shinyChanceCalculationEvent = new ShinyChanceCalculationEvent((float)this.shinyChance, pokemon);
                CobblemonEvents.SHINY_CHANCE_CALCULATION.emit((Object[])new ShinyChanceCalculationEvent[]{shinyChanceCalculationEvent});
                shinyChanceCalculationEvent.calculate(null);
                yield shinyChanceCalculationEvent.getChance();
            }
            default -> this.shinyChance;
        };
    }

    public static enum ShinyChoice implements StringRepresentable
    {
        CONFIG,
        CUSTOM,
        EVENT;

        public static final Codec<ShinyChoice> CODEC;

        public static ShinyChoice byName(String name) {
            return ShinyChoice.valueOf(name.toLowerCase());
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static ShinyChoice fromId(int id) {
            return ShinyChoice.values()[id];
        }

        static {
            CODEC = StringRepresentable.fromEnum(ShinyChoice::values);
        }
    }
}

