/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.scouter.cobblemonoutbreaks.CobblemonOutbreaks;
import com.scouter.cobblemonoutbreaks.config.OutbreakConfigManager;
import com.scouter.cobblemonoutbreaks.portal.OutbreakPortal;
import com.scouter.cobblemonoutbreaks.portal.OutbreakPortalSpawnSettings;
import com.scouter.cobblemonoutbreaks.portal.PokemonRarity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class OutbreaksJsonDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson STANDARD_GSON = new Gson();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String folderName;
    protected static Map<ResourceLocation, OutbreakPortal> data = new HashMap<ResourceLocation, OutbreakPortal>();
    protected static Map<Holder<Biome>, Map<PokemonRarity, List<OutbreakPortal>>> biomeData = new HashMap<Holder<Biome>, Map<PokemonRarity, List<OutbreakPortal>>>();
    protected static Map<PokemonRarity, List<ResourceLocation>> listWithRarity = new HashMap<PokemonRarity, List<ResourceLocation>>();
    protected static Map<Holder<Biome>, List<ResourceLocation>> resourceLocationMap = new HashMap<Holder<Biome>, List<ResourceLocation>>();
    protected static List<ResourceLocation> resourceLocationList = new ArrayList<ResourceLocation>();

    public OutbreaksJsonDataManager() {
        this(STANDARD_GSON, CobblemonOutbreaks.prefix("outbreaks").getPath());
    }

    public OutbreaksJsonDataManager(Gson gson, String folderName) {
        super(gson, folderName);
        this.folderName = folderName;
    }

    public static OutbreakPortal getPortalFromResourceLocation(ResourceLocation location) {
        return data.getOrDefault(location, OutbreakPortal.DEFAULT);
    }

    public static OutbreakPortal getRandomPortalFromBiome(ServerLevel level, Holder<Biome> biome) {
        Map<PokemonRarity, List<OutbreakPortal>> rarityMap;
        if (biomeData.isEmpty()) {
            OutbreaksJsonDataManager.populateBiomes(level);
        }
        if ((rarityMap = biomeData.get(biome)) == null || rarityMap.isEmpty()) {
            return OutbreaksJsonDataManager.getRandomPortal((Level)level);
        }
        PokemonRarity rarity = OutbreakConfigManager.getConfig().getRarities().getRandomRarity(level.getRandom());
        List<OutbreakPortal> portals = rarityMap.getOrDefault((Object)rarity, rarityMap.get((Object)PokemonRarity.COMMON));
        if (portals == null || portals.isEmpty()) {
            return OutbreaksJsonDataManager.getRandomPortal((Level)level);
        }
        return portals.get(level.getRandom().nextInt(portals.size()));
    }

    public static OutbreakPortal getRandomPortal(Level level) {
        ResourceLocation rl = OutbreaksJsonDataManager.getRandomResourceLocation(level);
        return data.getOrDefault(rl, OutbreakPortal.DEFAULT);
    }

    private static ResourceLocation getRandomResourceLocation(Level level) {
        if (!listWithRarity.isEmpty()) {
            List resourceLocations = listWithRarity.getOrDefault((Object)PokemonRarity.COMMON, null);
            if (resourceLocations == null || resourceLocations.isEmpty()) {
                return null;
            }
            return (ResourceLocation)resourceLocations.get(level.random.nextInt(resourceLocations.size()));
        }
        return null;
    }

    private static void populateBiomes(ServerLevel level) {
        HashMap<Holder<Biome>, Map<PokemonRarity, List<OutbreakPortal>>> newBiomeData = new HashMap<Holder<Biome>, Map<PokemonRarity, List<OutbreakPortal>>>();
        HashMap<Holder<Biome>, List<ResourceLocation>> resourceLocationBiomeMap = new HashMap<Holder<Biome>, List<ResourceLocation>>();
        for (OutbreakPortal portal : OutbreaksJsonDataManager.getData().values()) {
            OutbreakPortalSpawnSettings settings = portal.getOutbreakPortalSpawnSettings();
            List<ResourceLocation> spawnTags = settings.getOutbreakPortalSpawnBiomes().getSpawnBiomeTags();
            List<ResourceLocation> directBiomes = settings.getOutbreakPortalSpawnBiomes().getSpawnBiomes();
            List<ResourceLocation> blacklistTags = settings.getOutbreakPortalSpawnBiomes().getBlacklistBiomeTags();
            List<ResourceLocation> blacklistBiomes = settings.getOutbreakPortalSpawnBiomes().getBlacklistBiomes();
            HashSet<Holder<Biome>> validBiomes = new HashSet<Holder<Biome>>();
            OutbreaksJsonDataManager.collectBiomesFromTags(level, spawnTags, validBiomes);
            validBiomes.addAll(OutbreaksJsonDataManager.convertToBiomeHolders(level, directBiomes));
            HashSet<Holder<Biome>> blacklistedBiomes = new HashSet<Holder<Biome>>();
            OutbreaksJsonDataManager.collectBiomesFromTags(level, blacklistTags, blacklistedBiomes);
            blacklistedBiomes.addAll(OutbreaksJsonDataManager.convertToBiomeHolders(level, blacklistBiomes));
            validBiomes.removeAll(blacklistedBiomes);
            for (Holder holder : validBiomes) {
                OutbreaksJsonDataManager.addPortalToBiomeData(portal, (Holder<Biome>)holder, newBiomeData, resourceLocationBiomeMap);
            }
        }
        LOGGER.info("Registered {} biomes with Pok\u00e9mon!", (Object)newBiomeData.keySet().size());
        biomeData.putAll(newBiomeData);
        resourceLocationMap.putAll(resourceLocationBiomeMap);
    }

    private static void collectBiomesFromTags(ServerLevel level, List<ResourceLocation> tags, Set<Holder<Biome>> biomeSet) {
        for (ResourceLocation tag : tags) {
            TagKey biomeTagKey = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tag);
            level.registryAccess().registry(Registries.BIOME).ifPresent(reg -> {
                for (Holder biome : reg.getTagOrEmpty(biomeTagKey)) {
                    biomeSet.add(biome);
                }
            });
        }
    }

    private static Set<Holder<Biome>> convertToBiomeHolders(ServerLevel level, List<ResourceLocation> biomeLocations) {
        HashSet<Holder<Biome>> biomeHolders = new HashSet<Holder<Biome>>();
        level.registryAccess().registry(Registries.BIOME).ifPresent(registry -> {
            for (ResourceLocation biomeLocation : biomeLocations) {
                Optional biomeHolder = registry.getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeLocation));
                biomeHolder.ifPresent(biomeHolders::add);
            }
        });
        return biomeHolders;
    }

    private static void addPortalToBiomeData(OutbreakPortal portal, Holder<Biome> biomeHolder, Map<Holder<Biome>, Map<PokemonRarity, List<OutbreakPortal>>> biomeData, Map<Holder<Biome>, List<ResourceLocation>> resourceLocationBiomeMap) {
        PokemonRarity rarity = portal.getSpeciesData().getPokemonRarity();
        biomeData.computeIfAbsent(biomeHolder, k -> new HashMap()).computeIfAbsent(rarity, k -> new ArrayList()).add(portal);
        resourceLocationBiomeMap.computeIfAbsent(biomeHolder, k -> new ArrayList()).add(portal.getId());
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        LOGGER.info("Beginning loading of data for data loader: {}", (Object)this.getFolderName());
        listWithRarity.clear();
        resourceLocationList.clear();
        resourceLocationMap.clear();
        data.clear();
        biomeData.clear();
        HashMap<ResourceLocation, OutbreakPortal> newMap = new HashMap<ResourceLocation, OutbreakPortal>();
        HashMap<PokemonRarity, List<ResourceLocation>> newResourceLocationMap = new HashMap<PokemonRarity, List<ResourceLocation>>();
        ArrayList<ResourceLocation> newResourceLocationList = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            OutbreakPortal.EITHER.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).ifSuccess(success -> {
                OutbreakPortal portal = (OutbreakPortal)success.getFirst();
                portal.setId(key);
                newMap.put(key, portal);
                newResourceLocationList.add(key);
                PokemonRarity rarity = portal.getSpeciesData().getPokemonRarity();
                List resourceLocations = newResourceLocationMap.computeIfAbsent(rarity, k -> new ArrayList());
                resourceLocations.add(key);
                newResourceLocationMap.put(rarity, resourceLocations);
            }).ifError(error -> LOGGER.error("Failed to parse data json for {} due to: {}", (Object)key, (Object)error.message()));
        }
        listWithRarity = newResourceLocationMap;
        resourceLocationList = newResourceLocationList;
        data = newMap;
        LOGGER.info("Data loader for {} loaded {} jsons", (Object)this.getFolderName(), (Object)this.getData().size());
    }

    public static Map<ResourceLocation, OutbreakPortal> getData() {
        return data;
    }

    public String getFolderName() {
        return this.folderName;
    }
}

