/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.algorithms.level.RandomAlgorithm;
import com.scouter.cobblemonoutbreaks.algorithms.particle.CustomParticleAlgorithm;
import com.scouter.cobblemonoutbreaks.algorithms.spawning.OpenFieldAlgorithm;
import com.scouter.cobblemonoutbreaks.data.LevelAlgorithm;
import com.scouter.cobblemonoutbreaks.data.ParticleSpawningAlgorithm;
import com.scouter.cobblemonoutbreaks.data.SpawnAlgorithm;

public class OutbreakAlgorithmsData {
    public static final OutbreakAlgorithmsData DEFAULT = new OutbreakAlgorithmsData(RandomAlgorithm.ALGO, OpenFieldAlgorithm.ALGO, CustomParticleAlgorithm.DEBUG_PARTICLE);
    public static Codec<OutbreakAlgorithmsData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LevelAlgorithm.DIRECT_CODEC.fieldOf("level_algorithm").forGetter(OutbreakAlgorithmsData::getLevelAlgorithm), (App)SpawnAlgorithm.DIRECT_CODEC.fieldOf("spawn_algorithm").forGetter(OutbreakAlgorithmsData::getSpawnAlgorithm), (App)ParticleSpawningAlgorithm.DIRECT_CODEC.optionalFieldOf("particle_spawn_algorithm", (Object)CustomParticleAlgorithm.DEBUG_PARTICLE).forGetter(OutbreakAlgorithmsData::getParticleSpawningAlgorithm)).apply((Applicative)inst, OutbreakAlgorithmsData::new));
    private final LevelAlgorithm levelAlgorithm;
    private final SpawnAlgorithm spawnAlgorithm;
    private final ParticleSpawningAlgorithm particleSpawningAlgorithm;

    public OutbreakAlgorithmsData(LevelAlgorithm levelAlgorithm, SpawnAlgorithm spawnAlgorithm, ParticleSpawningAlgorithm particleSpawningAlgorithm) {
        this.levelAlgorithm = levelAlgorithm;
        this.spawnAlgorithm = spawnAlgorithm;
        this.particleSpawningAlgorithm = particleSpawningAlgorithm;
    }

    public LevelAlgorithm getLevelAlgorithm() {
        return this.levelAlgorithm;
    }

    public ParticleSpawningAlgorithm getParticleSpawningAlgorithm() {
        return this.particleSpawningAlgorithm;
    }

    public SpawnAlgorithm getSpawnAlgorithm() {
        return this.spawnAlgorithm;
    }
}

