/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.config.helper.fileformats;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.scouter.cobblemonoutbreaks.config.helper.fileformats.ImportFormatStrategy;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class GenericJsonImportStrategy<T>
implements ImportFormatStrategy<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Codec<T> codec;

    public GenericJsonImportStrategy(Codec<T> codec) {
        this.codec = codec;
    }

    @Override
    @Nullable
    public T importData(Path filePath) throws IOException {
        try (FileReader reader = new FileReader(filePath.toFile());){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            T t = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).resultOrPartial(err -> LOGGER.error("Failed to load data for path {}: {}", (Object)filePath, err)).map(Pair::getFirst).orElse(null);
            return t;
        }
    }

    @Override
    public String getExtension() {
        return "";
    }
}

