/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.portal.PokemonRarity;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.RandomSource;

public final class RarityConfig {
    private final Map<PokemonRarity, Integer> rarityProbabilities = new EnumMap<PokemonRarity, Integer>(PokemonRarity.class);
    private final int totalRarity;
    public static final Codec<RarityConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("common_outbreak_rarity").orElse((Object)40).forGetter(RarityConfig::getCommonRarity), (App)Codec.INT.fieldOf("uncommon_outbreak_rarity").orElse((Object)30).forGetter(RarityConfig::getUncommonRarity), (App)Codec.INT.fieldOf("rare_outbreak_rarity").orElse((Object)20).forGetter(RarityConfig::getRareRarity), (App)Codec.INT.fieldOf("epic_outbreak_rarity").orElse((Object)8).forGetter(RarityConfig::getEpicRarity), (App)Codec.INT.fieldOf("legendary_outbreak_rarity").orElse((Object)2).forGetter(RarityConfig::getLegendaryRarity)).apply((Applicative)instance, RarityConfig::new));

    public RarityConfig(int commonRarity, int uncommonRarity, int rareRarity, int epicRarity, int legendaryRarity) {
        this.rarityProbabilities.put(PokemonRarity.COMMON, commonRarity);
        this.rarityProbabilities.put(PokemonRarity.UNCOMMON, uncommonRarity);
        this.rarityProbabilities.put(PokemonRarity.RARE, rareRarity);
        this.rarityProbabilities.put(PokemonRarity.EPIC, epicRarity);
        this.rarityProbabilities.put(PokemonRarity.LEGENDARY, legendaryRarity);
        this.totalRarity = commonRarity + uncommonRarity + rareRarity + epicRarity + legendaryRarity;
    }

    public int getCommonRarity() {
        return this.rarityProbabilities.get((Object)PokemonRarity.COMMON);
    }

    public int getUncommonRarity() {
        return this.rarityProbabilities.get((Object)PokemonRarity.UNCOMMON);
    }

    public int getRareRarity() {
        return this.rarityProbabilities.get((Object)PokemonRarity.RARE);
    }

    public int getEpicRarity() {
        return this.rarityProbabilities.get((Object)PokemonRarity.EPIC);
    }

    public int getLegendaryRarity() {
        return this.rarityProbabilities.get((Object)PokemonRarity.LEGENDARY);
    }

    public int getTotalRarity() {
        return this.totalRarity;
    }

    public int getProbability(PokemonRarity rarity) {
        return this.rarityProbabilities.getOrDefault((Object)rarity, 0);
    }

    public PokemonRarity getRandomRarity(RandomSource randomSource) {
        int randomNumber = randomSource.nextInt(this.getTotalRarity());
        int cumulativeProbability = 0;
        for (PokemonRarity rarity : PokemonRarity.values()) {
            if (randomNumber >= (cumulativeProbability += this.getProbability(rarity))) continue;
            return rarity;
        }
        return PokemonRarity.COMMON;
    }

    public static RarityConfig defaultInstance() {
        return new RarityConfig(40, 30, 20, 8, 2);
    }
}

