/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.algorithms.spawning;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.data.SpawnAlgorithm;
import com.scouter.cobblemonoutbreaks.data.SpawnAlgorithmType;
import com.scouter.cobblemonoutbreaks.portal.entity.OutbreakPortalEntity;
import com.scouter.cobblemonoutbreaks.registries.SpawnAlgorithmRegistry;
import com.scouter.cobblemonoutbreaks.util.AABBHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;

public class ClusteredAlgorithm
implements SpawnAlgorithm {
    public static final MapCodec<ClusteredAlgorithm> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.doubleRange((double)5.0, (double)40.0).optionalFieldOf("spawn_range", (Object)15.0).forGetter(ClusteredAlgorithm::getSpawnRange), (App)Codec.doubleRange((double)5.0, (double)40.0).optionalFieldOf("leash_range", (Object)32.0).forGetter(ClusteredAlgorithm::getLeashRange)).apply((Applicative)instance, ClusteredAlgorithm::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClusteredAlgorithm> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, ClusteredAlgorithm::getSpawnRange, (StreamCodec)ByteBufCodecs.DOUBLE, ClusteredAlgorithm::getLeashRange, ClusteredAlgorithm::new);
    public static final SpawnAlgorithmType<ClusteredAlgorithm> TYPE = new SpawnAlgorithmType<ClusteredAlgorithm>(){

        @Override
        public MapCodec<ClusteredAlgorithm> mapCodec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ClusteredAlgorithm> streamCodec() {
            return STREAM_CODEC;
        }
    };
    protected double spawnRange;
    protected double leashRange;

    public ClusteredAlgorithm(double spawnRange, double leashRange) {
        this.spawnRange = spawnRange;
        this.leashRange = leashRange;
    }

    public double getLeashRange() {
        return this.leashRange;
    }

    public double getSpawnRange() {
        return this.spawnRange;
    }

    @Override
    public Vec3 spawnPosition(ServerLevel level, Vec3 pos, OutbreakPortalEntity outbreakPortalEntity, PokemonEntity pokemon) {
        double spawnRange = this.getSpawnRange();
        int tries = 0;
        double x = pos.x() + (-1.0 + 2.0 * level.random.nextDouble()) * spawnRange;
        double y = pos.y() + (double)level.random.nextInt(3) - 1.0;
        double z = pos.z() + (-1.0 + 2.0 * level.random.nextDouble()) * spawnRange;
        while (!level.noCollision(AABBHelper.getAABB(x, y, z, pokemon)) && tries++ < 25) {
            x = x + (level.random.nextDouble() - level.random.nextDouble()) * spawnRange + 0.5;
            y = y + (double)level.random.nextInt(3) + 1.0;
            z = z + (level.random.nextDouble() - level.random.nextDouble()) * spawnRange + 0.5;
        }
        while (level.getBlockState(BlockPos.containing((double)x, (double)(y - 1.0), (double)z)).isAir() && y > (double)level.getMinBuildHeight()) {
            y -= 1.0;
        }
        while (!level.noCollision(AABBHelper.getAABB(x, y, z, pokemon))) {
            y += 1.0;
        }
        if (outbreakPortalEntity.distanceToSqr(x, y, z) > this.getLeashRange() * this.getLeashRange()) {
            return null;
        }
        if (level.noCollision(AABBHelper.getAABB(x, y, z, pokemon))) {
            return new Vec3(x, y, z);
        }
        return null;
    }

    @Override
    public SpawnAlgorithmType<? extends SpawnAlgorithm> type() {
        return (SpawnAlgorithmType)SpawnAlgorithmRegistry.CLUSTERED.get();
    }
}

