/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.algorithms.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.codec.OutbreaksStreamCodecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;

public class OutbreakParticleData {
    public static final MapCodec<OutbreakParticleData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ParticleTypes.CODEC.fieldOf("particle").forGetter(OutbreakParticleData::getOptions), (App)BlockPos.CODEC.fieldOf("offset").forGetter(OutbreakParticleData::getOffSet), (App)Codec.BOOL.optionalFieldOf("random", (Object)false).forGetter(OutbreakParticleData::isRandom), (App)Codec.BOOL.optionalFieldOf("negative", (Object)false).forGetter(OutbreakParticleData::isNegative), (App)Codec.INT.optionalFieldOf("particle_count", (Object)1).forGetter(OutbreakParticleData::getParticleCount), (App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(OutbreakParticleData::getxOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(OutbreakParticleData::getyOffset), (App)Codec.INT.optionalFieldOf("z_offset", (Object)0).forGetter(OutbreakParticleData::getzOffset), (App)Codec.INT.optionalFieldOf("speed", (Object)0).forGetter(OutbreakParticleData::getSpeed)).apply((Applicative)instance, OutbreakParticleData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, OutbreakParticleData> STREAM_CODEC = OutbreaksStreamCodecs.composite(ParticleTypes.STREAM_CODEC, OutbreakParticleData::getOptions, BlockPos.STREAM_CODEC, OutbreakParticleData::getOffSet, ByteBufCodecs.BOOL, OutbreakParticleData::isRandom, ByteBufCodecs.BOOL, OutbreakParticleData::isNegative, ByteBufCodecs.INT, OutbreakParticleData::getParticleCount, ByteBufCodecs.INT, OutbreakParticleData::getxOffset, ByteBufCodecs.INT, OutbreakParticleData::getyOffset, ByteBufCodecs.INT, OutbreakParticleData::getzOffset, ByteBufCodecs.INT, OutbreakParticleData::getSpeed, OutbreakParticleData::new);
    private final ParticleOptions options;
    private final BlockPos offSet;
    private final boolean random;
    private final boolean negative;
    private final int particleCount;
    private final int xOffset;
    private final int yOffset;
    private final int zOffset;
    private final int speed;

    public OutbreakParticleData(ParticleOptions options, BlockPos offSet, boolean random, boolean negative, int particleCount, int xOffset, int yOffset, int zOffset, int speed) {
        this.options = options;
        this.offSet = offSet;
        this.random = random;
        this.negative = negative;
        this.particleCount = particleCount;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.speed = speed;
    }

    public void spawnParticle(ServerLevel level, BlockPos pos, int tick) {
        if (level == null) {
            return;
        }
        BlockPos spawnPos = pos.offset((Vec3i)this.offSet);
        if (this.random) {
            double randomDoubleX = level.random.nextDouble() * (double)(this.isNegative() ? -1 : 1);
            double randomDoubleY = level.random.nextDouble() * (double)(this.isNegative() ? -1 : 1);
            double randomDoubleZ = level.random.nextDouble() * (double)(this.isNegative() ? -1 : 1);
            level.sendParticles(this.options, (double)spawnPos.getX() + randomDoubleX, (double)spawnPos.getY() + randomDoubleY, (double)spawnPos.getZ() + randomDoubleZ, this.particleCount, (double)this.xOffset, (double)this.yOffset, (double)this.zOffset, (double)this.speed);
        } else {
            level.sendParticles(this.options, (double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ(), this.particleCount, (double)this.xOffset, (double)this.yOffset, (double)this.zOffset, (double)this.speed);
        }
    }

    public boolean isNegative() {
        return this.negative;
    }

    public boolean isRandom() {
        return this.random;
    }

    public BlockPos getOffSet() {
        return this.offSet;
    }

    public ParticleOptions getOptions() {
        return this.options;
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getxOffset() {
        return this.xOffset;
    }

    public int getyOffset() {
        return this.yOffset;
    }

    public int getzOffset() {
        return this.zOffset;
    }
}

