/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.algorithms.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.cobblemonoutbreaks.algorithms.particle.OutbreakParticleData;
import com.scouter.cobblemonoutbreaks.data.ParticleSpawningAlgorithm;
import com.scouter.cobblemonoutbreaks.data.ParticleSpawninglAlgorithmType;
import com.scouter.cobblemonoutbreaks.registries.ParticleSpawningAlgorithmRegistry;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;

public class MovingCustomParticleAlgorithm
implements ParticleSpawningAlgorithm {
    private final List<OutbreakParticleData> outbreakParticleDataList;
    private final int showSpeed;
    private final BlockPos totalOffset;
    private final float xSpeed;
    private final float zSpeed;
    private final float ySpeed;
    public static final MovingCustomParticleAlgorithm DEFAULT = new MovingCustomParticleAlgorithm(Collections.emptyList(), BlockPos.ZERO, 0, 0.0f, 0.0f, 0.0f);
    public static final MapCodec<MovingCustomParticleAlgorithm> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)OutbreakParticleData.CODEC.codec().listOf().fieldOf("outbreak_particle_data").forGetter(MovingCustomParticleAlgorithm::getOutbreakParticleDataList), (App)BlockPos.CODEC.fieldOf("total_offset").forGetter(MovingCustomParticleAlgorithm::getTotalOffset), (App)Codec.INT.fieldOf("show_speed").forGetter(MovingCustomParticleAlgorithm::getShowSpeed), (App)Codec.FLOAT.fieldOf("x_speed").forGetter(MovingCustomParticleAlgorithm::getxSpeed), (App)Codec.FLOAT.fieldOf("y_speed").forGetter(MovingCustomParticleAlgorithm::getySpeed), (App)Codec.FLOAT.fieldOf("z_speed").forGetter(MovingCustomParticleAlgorithm::getzSpeed)).apply((Applicative)instance, MovingCustomParticleAlgorithm::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MovingCustomParticleAlgorithm> STREAM_CODEC = StreamCodec.composite((StreamCodec)OutbreakParticleData.STREAM_CODEC.apply(ByteBufCodecs.list()), MovingCustomParticleAlgorithm::getOutbreakParticleDataList, (StreamCodec)BlockPos.STREAM_CODEC, MovingCustomParticleAlgorithm::getTotalOffset, (StreamCodec)ByteBufCodecs.INT, MovingCustomParticleAlgorithm::getShowSpeed, (StreamCodec)ByteBufCodecs.FLOAT, MovingCustomParticleAlgorithm::getxSpeed, (StreamCodec)ByteBufCodecs.FLOAT, MovingCustomParticleAlgorithm::getySpeed, (StreamCodec)ByteBufCodecs.FLOAT, MovingCustomParticleAlgorithm::getzSpeed, MovingCustomParticleAlgorithm::new);
    public static final ParticleSpawninglAlgorithmType<MovingCustomParticleAlgorithm> TYPE = new ParticleSpawninglAlgorithmType<MovingCustomParticleAlgorithm>(){

        @Override
        public MapCodec<MovingCustomParticleAlgorithm> mapCodec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, MovingCustomParticleAlgorithm> streamCodec() {
            return STREAM_CODEC;
        }
    };

    public MovingCustomParticleAlgorithm(List<OutbreakParticleData> outbreakParticleDataList, BlockPos totalOffset, int showSpeed, float xSpeed, float zSpeed, float ySpeed) {
        this.outbreakParticleDataList = outbreakParticleDataList;
        this.totalOffset = totalOffset;
        this.showSpeed = showSpeed;
        this.xSpeed = xSpeed;
        this.zSpeed = zSpeed;
        this.ySpeed = ySpeed;
    }

    @Override
    public void spawnParticle(ServerLevel level, BlockPos pos, int tick) {
        if (level == null || tick % this.showSpeed != 0) {
            return;
        }
        for (OutbreakParticleData data : this.getOutbreakParticleDataList()) {
            BlockPos spawnPos = pos.offset((Vec3i)data.getOffSet());
            if (data.isRandom()) {
                double randomDoubleX = level.random.nextDouble() * (double)(data.isNegative() ? -1 : 1);
                double randomDoubleY = level.random.nextDouble() * (double)(data.isNegative() ? -1 : 1);
                double randomDoubleZ = level.random.nextDouble() * (double)(data.isNegative() ? -1 : 1);
                level.sendParticles(data.getOptions(), (double)spawnPos.getX() + randomDoubleX + Math.sin(tick) * (double)this.getxSpeed(), (double)spawnPos.getY() + randomDoubleY + Math.sin(tick) * (double)this.getySpeed(), (double)spawnPos.getZ() + randomDoubleZ + Math.cos(tick) * (double)this.getzSpeed(), data.getParticleCount(), (double)data.getxOffset(), (double)data.getyOffset(), (double)data.getzOffset(), (double)data.getSpeed());
                continue;
            }
            level.sendParticles(data.getOptions(), (double)spawnPos.getX() + Math.sin(tick) * (double)this.getxSpeed(), (double)spawnPos.getY() + Math.sin(tick) * (double)this.getySpeed(), (double)spawnPos.getZ() + Math.cos(tick) * (double)this.getzSpeed(), data.getParticleCount(), (double)data.getxOffset(), (double)data.getyOffset(), (double)data.getzOffset(), (double)data.getSpeed());
        }
    }

    public BlockPos getTotalOffset() {
        return this.totalOffset;
    }

    public float getxSpeed() {
        return this.xSpeed;
    }

    public float getySpeed() {
        return this.ySpeed;
    }

    public float getzSpeed() {
        return this.zSpeed;
    }

    public int getShowSpeed() {
        return this.showSpeed;
    }

    public List<OutbreakParticleData> getOutbreakParticleDataList() {
        return this.outbreakParticleDataList;
    }

    @Override
    public ParticleSpawninglAlgorithmType<? extends ParticleSpawningAlgorithm> type() {
        return (ParticleSpawninglAlgorithmType)ParticleSpawningAlgorithmRegistry.MOVING.get();
    }
}

