/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.cobblemonoutbreaks.algorithms.level;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.serialization.MapCodec;
import com.scouter.cobblemonoutbreaks.data.LevelAlgorithm;
import com.scouter.cobblemonoutbreaks.data.LevelAlgorithmType;
import com.scouter.cobblemonoutbreaks.registries.LevelAlgorithmRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ScaledAlgorithm
implements LevelAlgorithm {
    public static final ScaledAlgorithm ALGO = new ScaledAlgorithm();
    public static final MapCodec<ScaledAlgorithm> CODEC = MapCodec.unit((Object)ALGO);
    public static final StreamCodec<RegistryFriendlyByteBuf, ScaledAlgorithm> STREAM_CODEC = StreamCodec.unit((Object)ALGO);
    public static final LevelAlgorithmType<ScaledAlgorithm> TYPE = new LevelAlgorithmType<ScaledAlgorithm>(){

        @Override
        public MapCodec<ScaledAlgorithm> mapCodec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ScaledAlgorithm> streamCodec() {
            return STREAM_CODEC;
        }
    };

    public static int random(ServerLevel level, Player player) {
        return level.random.nextInt(1, 100);
    }

    @Override
    public int getLevel(ServerLevel level, Player player) {
        if (player == null) {
            return ScaledAlgorithm.random(level, player);
        }
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
        int totalLevel = 0;
        int count = 0;
        for (Pokemon pokemon : party) {
            totalLevel += pokemon.getLevel();
            ++count;
        }
        if (count == 0 || totalLevel == 0) {
            return ScaledAlgorithm.random(level, player);
        }
        int scaledLevel = totalLevel / count;
        if ((scaledLevel += level.random.nextInt(-5, 5)) <= 0) {
            scaledLevel = 5;
        }
        if (scaledLevel > 100) {
            scaledLevel = 100;
        }
        return scaledLevel;
    }

    @Override
    public LevelAlgorithmType<? extends LevelAlgorithm> type() {
        return (LevelAlgorithmType)LevelAlgorithmRegistry.SCALED.get();
    }
}

