/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.viewer.rei;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.levelscraft7.recipeitemsync.client.VirtualItemIndex;
import net.levelscraft7.recipeitemsync.util.VirtualItemUtil;
import net.levelscraft7.recipeitemsync.viewer.ViewerBridge;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class ReiViewerBridge
implements ViewerBridge {
    public static final ReiViewerBridge INSTANCE = new ReiViewerBridge();
    private EntryRegistry entryRegistry;
    private List<EntryStack<?>> lastVirtualEntries = List.of();
    private List<EntryStack<?>> lastVariantEntries = List.of();
    private List<ItemStack> queuedVirtual = List.of();
    private List<ItemStack> queuedVariants = List.of();

    private ReiViewerBridge() {
    }

    public static ReiViewerBridge getInstance() {
        return INSTANCE;
    }

    public boolean isAttached() {
        return this.entryRegistry != null;
    }

    public void attach(EntryRegistry registry) {
        this.entryRegistry = registry;
        this.pushVirtual();
        this.pushVariants();
    }

    @Override
    public String id() {
        return "rei";
    }

    @Override
    public void updateVirtualStacks(List<ItemStack> virtualStacks) {
        this.queuedVirtual = ReiViewerBridge.copyStacks(virtualStacks);
        this.pushVirtual();
    }

    @Override
    public void updateVariantStacks(List<ItemStack> variantStacks) {
        this.queuedVariants = ReiViewerBridge.copyStacks(variantStacks);
        this.pushVariants();
    }

    @Override
    public void onDeselected() {
        this.entryRegistry = null;
        this.lastVirtualEntries = List.of();
        this.lastVariantEntries = List.of();
        this.queuedVirtual = List.of();
        this.queuedVariants = List.of();
    }

    private void pushVirtual() {
        if (this.entryRegistry == null) {
            return;
        }
        if (!this.lastVirtualEntries.isEmpty()) {
            this.entryRegistry.removeEntryIf(entry -> this.lastVirtualEntries.contains(entry) || ReiViewerBridge.matchesTrackedVirtualIds(entry));
        }
        this.lastVirtualEntries = ReiViewerBridge.buildEntries(this.queuedVirtual);
        if (!this.lastVirtualEntries.isEmpty()) {
            this.entryRegistry.addEntries(this.lastVirtualEntries);
            this.entryRegistry.refilter();
        }
    }

    private void pushVariants() {
        if (this.entryRegistry == null) {
            return;
        }
        if (!this.lastVariantEntries.isEmpty()) {
            this.entryRegistry.removeEntryIf(entry -> this.lastVariantEntries.contains(entry));
        }
        this.lastVariantEntries = ReiViewerBridge.buildEntries(this.queuedVariants);
        if (!this.lastVariantEntries.isEmpty()) {
            this.entryRegistry.addEntries(this.lastVariantEntries);
            this.entryRegistry.refilter();
        }
    }

    private static List<EntryStack<?>> buildEntries(List<ItemStack> stacks) {
        ArrayList<EntryStack> entries = new ArrayList<EntryStack>();
        for (ItemStack stack : stacks) {
            EntryStack entry = EntryStacks.of((ItemStack)stack);
            String virtualId = VirtualItemUtil.getVirtualId(stack);
            if (virtualId != null) {
                entry = entry.setting(EntryStack.Settings.CONTAINING_NS, (ignored, original) -> {
                    ResourceLocation parsed = ResourceLocation.tryParse((String)virtualId);
                    return parsed != null ? parsed.getNamespace() : original;
                }).setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, ignored -> {
                    ArrayList<Object> components = new ArrayList<Object>();
                    components.add(stack.getHoverName());
                    components.add(Component.literal((String)virtualId).withStyle(ChatFormatting.DARK_GRAY));
                    return components;
                });
                entry = entry.tooltip(ignored -> {
                    ArrayList<Object> tooltip = new ArrayList<Object>();
                    tooltip.add(stack.getHoverName());
                    tooltip.add(Component.literal((String)virtualId).withStyle(ChatFormatting.DARK_GRAY));
                    return tooltip;
                });
            }
            entries.add(entry);
        }
        return List.copyOf(entries);
    }

    private static List<ItemStack> copyStacks(List<ItemStack> stacks) {
        ArrayList<ItemStack> copies = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            copies.add(stack.copy());
        }
        return List.copyOf(copies);
    }

    private static boolean matchesTrackedVirtualIds(EntryStack<?> entry) {
        List<String> currentIds = VirtualItemIndex.trackedVirtualIds();
        Object value = entry.getValue();
        if (!(value instanceof ItemStack)) {
            return false;
        }
        ItemStack stack = (ItemStack)value;
        String virtualId = VirtualItemUtil.getVirtualId(stack);
        return virtualId != null && currentIds.contains(virtualId);
    }
}

