/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.recipeitemsync.viewer.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import net.levelscraft7.recipeitemsync.viewer.ViewerBridge;
import net.minecraft.world.item.ItemStack;

public final class JeiViewerBridge
implements ViewerBridge {
    public static final JeiViewerBridge INSTANCE = new JeiViewerBridge();
    private IIngredientManager ingredientManager;
    private List<ItemStack> lastVirtual = List.of();
    private List<ItemStack> lastVariants = List.of();
    private List<ItemStack> queuedVirtual = List.of();
    private List<ItemStack> queuedVariants = List.of();

    private JeiViewerBridge() {
    }

    public static JeiViewerBridge getInstance() {
        return INSTANCE;
    }

    public void attach(IIngredientManager manager) {
        this.ingredientManager = manager;
        this.pushVirtual();
        this.pushVariants();
    }

    @Override
    public String id() {
        return "jei";
    }

    @Override
    public void onDeselected() {
        this.ingredientManager = null;
        this.lastVirtual = List.of();
        this.lastVariants = List.of();
        this.queuedVirtual = List.of();
        this.queuedVariants = List.of();
    }

    @Override
    public void updateVirtualStacks(List<ItemStack> virtualStacks) {
        this.queuedVirtual = JeiViewerBridge.copyStacks(virtualStacks);
        this.pushVirtual();
    }

    @Override
    public void updateVariantStacks(List<ItemStack> variantStacks) {
        this.queuedVariants = JeiViewerBridge.copyStacks(variantStacks);
        this.pushVariants();
    }

    private void pushVirtual() {
        if (this.ingredientManager == null) {
            return;
        }
        try {
            if (!this.lastVirtual.isEmpty()) {
                this.ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.lastVirtual);
            }
            if (!this.queuedVirtual.isEmpty()) {
                this.ingredientManager.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.queuedVirtual);
            }
            this.lastVirtual = this.queuedVirtual;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void pushVariants() {
        if (this.ingredientManager == null) {
            return;
        }
        try {
            if (!this.lastVariants.isEmpty()) {
                this.ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.lastVariants);
            }
            if (!this.queuedVariants.isEmpty()) {
                this.ingredientManager.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.queuedVariants);
            }
            this.lastVariants = this.queuedVariants;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static List<ItemStack> copyStacks(List<ItemStack> stacks) {
        ArrayList<ItemStack> copies = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            copies.add(stack.copy());
        }
        return List.copyOf(copies);
    }
}

